/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.redshift;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.redshift.;
import software.amazon.awscdk.services.redshift.CfnCluster;
import software.amazon.awscdk.services.redshift.CfnClusterProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-redshift.CfnCluster")
public class CfnCluster
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnCluster.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnCluster(@NotNull Construct scope, @NotNull String id, @NotNull CfnClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrDeferMaintenanceIdentifier() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrDeferMaintenanceIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrEndpointAddress() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrEndpointAddress", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrEndpointPort() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrEndpointPort", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.forClass(TagManager.class));
    }

    @NotNull
    public String getClusterType() {
        return (String)Kernel.get((Object)((Object)this), (String)"clusterType", (NativeType)NativeType.forClass(String.class));
    }

    public void setClusterType(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"clusterType", (Object)Objects.requireNonNull(value, "clusterType is required"));
    }

    @NotNull
    public String getDbName() {
        return (String)Kernel.get((Object)((Object)this), (String)"dbName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDbName(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"dbName", (Object)Objects.requireNonNull(value, "dbName is required"));
    }

    @NotNull
    public String getMasterUsername() {
        return (String)Kernel.get((Object)((Object)this), (String)"masterUsername", (NativeType)NativeType.forClass(String.class));
    }

    public void setMasterUsername(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"masterUsername", (Object)Objects.requireNonNull(value, "masterUsername is required"));
    }

    @NotNull
    public String getMasterUserPassword() {
        return (String)Kernel.get((Object)((Object)this), (String)"masterUserPassword", (NativeType)NativeType.forClass(String.class));
    }

    public void setMasterUserPassword(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"masterUserPassword", (Object)Objects.requireNonNull(value, "masterUserPassword is required"));
    }

    @NotNull
    public String getNodeType() {
        return (String)Kernel.get((Object)((Object)this), (String)"nodeType", (NativeType)NativeType.forClass(String.class));
    }

    public void setNodeType(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"nodeType", (Object)Objects.requireNonNull(value, "nodeType is required"));
    }

    @Nullable
    public Object getAllowVersionUpgrade() {
        return Kernel.get((Object)((Object)this), (String)"allowVersionUpgrade", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAllowVersionUpgrade(@Nullable Boolean value) {
        Kernel.set((Object)((Object)this), (String)"allowVersionUpgrade", (Object)value);
    }

    public void setAllowVersionUpgrade(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"allowVersionUpgrade", (Object)value);
    }

    @Nullable
    public String getAquaConfigurationStatus() {
        return (String)Kernel.get((Object)((Object)this), (String)"aquaConfigurationStatus", (NativeType)NativeType.forClass(String.class));
    }

    public void setAquaConfigurationStatus(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"aquaConfigurationStatus", (Object)value);
    }

    @Nullable
    public Number getAutomatedSnapshotRetentionPeriod() {
        return (Number)Kernel.get((Object)((Object)this), (String)"automatedSnapshotRetentionPeriod", (NativeType)NativeType.forClass(Number.class));
    }

    public void setAutomatedSnapshotRetentionPeriod(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"automatedSnapshotRetentionPeriod", (Object)value);
    }

    @Nullable
    public String getAvailabilityZone() {
        return (String)Kernel.get((Object)((Object)this), (String)"availabilityZone", (NativeType)NativeType.forClass(String.class));
    }

    public void setAvailabilityZone(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"availabilityZone", (Object)value);
    }

    @Nullable
    public Object getAvailabilityZoneRelocation() {
        return Kernel.get((Object)((Object)this), (String)"availabilityZoneRelocation", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAvailabilityZoneRelocation(@Nullable Boolean value) {
        Kernel.set((Object)((Object)this), (String)"availabilityZoneRelocation", (Object)value);
    }

    public void setAvailabilityZoneRelocation(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"availabilityZoneRelocation", (Object)value);
    }

    @Nullable
    public String getAvailabilityZoneRelocationStatus() {
        return (String)Kernel.get((Object)((Object)this), (String)"availabilityZoneRelocationStatus", (NativeType)NativeType.forClass(String.class));
    }

    public void setAvailabilityZoneRelocationStatus(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"availabilityZoneRelocationStatus", (Object)value);
    }

    @Nullable
    public Object getClassic() {
        return Kernel.get((Object)((Object)this), (String)"classic", (NativeType)NativeType.forClass(Object.class));
    }

    public void setClassic(@Nullable Boolean value) {
        Kernel.set((Object)((Object)this), (String)"classic", (Object)value);
    }

    public void setClassic(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"classic", (Object)value);
    }

    @Nullable
    public String getClusterIdentifier() {
        return (String)Kernel.get((Object)((Object)this), (String)"clusterIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setClusterIdentifier(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"clusterIdentifier", (Object)value);
    }

    @Nullable
    public String getClusterParameterGroupName() {
        return (String)Kernel.get((Object)((Object)this), (String)"clusterParameterGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setClusterParameterGroupName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"clusterParameterGroupName", (Object)value);
    }

    @Nullable
    public List<String> getClusterSecurityGroups() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"clusterSecurityGroups", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setClusterSecurityGroups(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"clusterSecurityGroups", value);
    }

    @Nullable
    public String getClusterSubnetGroupName() {
        return (String)Kernel.get((Object)((Object)this), (String)"clusterSubnetGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setClusterSubnetGroupName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"clusterSubnetGroupName", (Object)value);
    }

    @Nullable
    public String getClusterVersion() {
        return (String)Kernel.get((Object)((Object)this), (String)"clusterVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setClusterVersion(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"clusterVersion", (Object)value);
    }

    @Nullable
    public Object getDeferMaintenance() {
        return Kernel.get((Object)((Object)this), (String)"deferMaintenance", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDeferMaintenance(@Nullable Boolean value) {
        Kernel.set((Object)((Object)this), (String)"deferMaintenance", (Object)value);
    }

    public void setDeferMaintenance(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"deferMaintenance", (Object)value);
    }

    @Nullable
    public Number getDeferMaintenanceDuration() {
        return (Number)Kernel.get((Object)((Object)this), (String)"deferMaintenanceDuration", (NativeType)NativeType.forClass(Number.class));
    }

    public void setDeferMaintenanceDuration(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"deferMaintenanceDuration", (Object)value);
    }

    @Nullable
    public String getDeferMaintenanceEndTime() {
        return (String)Kernel.get((Object)((Object)this), (String)"deferMaintenanceEndTime", (NativeType)NativeType.forClass(String.class));
    }

    public void setDeferMaintenanceEndTime(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"deferMaintenanceEndTime", (Object)value);
    }

    @Nullable
    public String getDeferMaintenanceStartTime() {
        return (String)Kernel.get((Object)((Object)this), (String)"deferMaintenanceStartTime", (NativeType)NativeType.forClass(String.class));
    }

    public void setDeferMaintenanceStartTime(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"deferMaintenanceStartTime", (Object)value);
    }

    @Nullable
    public String getDestinationRegion() {
        return (String)Kernel.get((Object)((Object)this), (String)"destinationRegion", (NativeType)NativeType.forClass(String.class));
    }

    public void setDestinationRegion(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"destinationRegion", (Object)value);
    }

    @Nullable
    public String getElasticIp() {
        return (String)Kernel.get((Object)((Object)this), (String)"elasticIp", (NativeType)NativeType.forClass(String.class));
    }

    public void setElasticIp(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"elasticIp", (Object)value);
    }

    @Nullable
    public Object getEncrypted() {
        return Kernel.get((Object)((Object)this), (String)"encrypted", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEncrypted(@Nullable Boolean value) {
        Kernel.set((Object)((Object)this), (String)"encrypted", (Object)value);
    }

    public void setEncrypted(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"encrypted", (Object)value);
    }

    @Nullable
    public Object getEndpoint() {
        return Kernel.get((Object)((Object)this), (String)"endpoint", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEndpoint(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"endpoint", (Object)value);
    }

    public void setEndpoint(@Nullable EndpointProperty value) {
        Kernel.set((Object)((Object)this), (String)"endpoint", (Object)value);
    }

    @Nullable
    public Object getEnhancedVpcRouting() {
        return Kernel.get((Object)((Object)this), (String)"enhancedVpcRouting", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnhancedVpcRouting(@Nullable Boolean value) {
        Kernel.set((Object)((Object)this), (String)"enhancedVpcRouting", (Object)value);
    }

    public void setEnhancedVpcRouting(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"enhancedVpcRouting", (Object)value);
    }

    @Nullable
    public String getHsmClientCertificateIdentifier() {
        return (String)Kernel.get((Object)((Object)this), (String)"hsmClientCertificateIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setHsmClientCertificateIdentifier(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"hsmClientCertificateIdentifier", (Object)value);
    }

    @Nullable
    public String getHsmConfigurationIdentifier() {
        return (String)Kernel.get((Object)((Object)this), (String)"hsmConfigurationIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setHsmConfigurationIdentifier(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"hsmConfigurationIdentifier", (Object)value);
    }

    @Nullable
    public List<String> getIamRoles() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"iamRoles", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setIamRoles(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"iamRoles", value);
    }

    @Nullable
    public String getKmsKeyId() {
        return (String)Kernel.get((Object)((Object)this), (String)"kmsKeyId", (NativeType)NativeType.forClass(String.class));
    }

    public void setKmsKeyId(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"kmsKeyId", (Object)value);
    }

    @Nullable
    public Object getLoggingProperties() {
        return Kernel.get((Object)((Object)this), (String)"loggingProperties", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLoggingProperties(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"loggingProperties", (Object)value);
    }

    public void setLoggingProperties(@Nullable LoggingPropertiesProperty value) {
        Kernel.set((Object)((Object)this), (String)"loggingProperties", (Object)value);
    }

    @Nullable
    public String getMaintenanceTrackName() {
        return (String)Kernel.get((Object)((Object)this), (String)"maintenanceTrackName", (NativeType)NativeType.forClass(String.class));
    }

    public void setMaintenanceTrackName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"maintenanceTrackName", (Object)value);
    }

    @Nullable
    public Number getManualSnapshotRetentionPeriod() {
        return (Number)Kernel.get((Object)((Object)this), (String)"manualSnapshotRetentionPeriod", (NativeType)NativeType.forClass(Number.class));
    }

    public void setManualSnapshotRetentionPeriod(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"manualSnapshotRetentionPeriod", (Object)value);
    }

    @Nullable
    public Number getNumberOfNodes() {
        return (Number)Kernel.get((Object)((Object)this), (String)"numberOfNodes", (NativeType)NativeType.forClass(Number.class));
    }

    public void setNumberOfNodes(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"numberOfNodes", (Object)value);
    }

    @Nullable
    public String getOwnerAccount() {
        return (String)Kernel.get((Object)((Object)this), (String)"ownerAccount", (NativeType)NativeType.forClass(String.class));
    }

    public void setOwnerAccount(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"ownerAccount", (Object)value);
    }

    @Nullable
    public Number getPort() {
        return (Number)Kernel.get((Object)((Object)this), (String)"port", (NativeType)NativeType.forClass(Number.class));
    }

    public void setPort(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"port", (Object)value);
    }

    @Nullable
    public String getPreferredMaintenanceWindow() {
        return (String)Kernel.get((Object)((Object)this), (String)"preferredMaintenanceWindow", (NativeType)NativeType.forClass(String.class));
    }

    public void setPreferredMaintenanceWindow(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"preferredMaintenanceWindow", (Object)value);
    }

    @Nullable
    public Object getPubliclyAccessible() {
        return Kernel.get((Object)((Object)this), (String)"publiclyAccessible", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPubliclyAccessible(@Nullable Boolean value) {
        Kernel.set((Object)((Object)this), (String)"publiclyAccessible", (Object)value);
    }

    public void setPubliclyAccessible(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"publiclyAccessible", (Object)value);
    }

    @Nullable
    public String getResourceAction() {
        return (String)Kernel.get((Object)((Object)this), (String)"resourceAction", (NativeType)NativeType.forClass(String.class));
    }

    public void setResourceAction(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"resourceAction", (Object)value);
    }

    @Nullable
    public String getRevisionTarget() {
        return (String)Kernel.get((Object)((Object)this), (String)"revisionTarget", (NativeType)NativeType.forClass(String.class));
    }

    public void setRevisionTarget(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"revisionTarget", (Object)value);
    }

    @Nullable
    public Object getRotateEncryptionKey() {
        return Kernel.get((Object)((Object)this), (String)"rotateEncryptionKey", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRotateEncryptionKey(@Nullable Boolean value) {
        Kernel.set((Object)((Object)this), (String)"rotateEncryptionKey", (Object)value);
    }

    public void setRotateEncryptionKey(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"rotateEncryptionKey", (Object)value);
    }

    @Nullable
    public String getSnapshotClusterIdentifier() {
        return (String)Kernel.get((Object)((Object)this), (String)"snapshotClusterIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setSnapshotClusterIdentifier(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"snapshotClusterIdentifier", (Object)value);
    }

    @Nullable
    public String getSnapshotCopyGrantName() {
        return (String)Kernel.get((Object)((Object)this), (String)"snapshotCopyGrantName", (NativeType)NativeType.forClass(String.class));
    }

    public void setSnapshotCopyGrantName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"snapshotCopyGrantName", (Object)value);
    }

    @Nullable
    public Object getSnapshotCopyManual() {
        return Kernel.get((Object)((Object)this), (String)"snapshotCopyManual", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSnapshotCopyManual(@Nullable Boolean value) {
        Kernel.set((Object)((Object)this), (String)"snapshotCopyManual", (Object)value);
    }

    public void setSnapshotCopyManual(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"snapshotCopyManual", (Object)value);
    }

    @Nullable
    public Number getSnapshotCopyRetentionPeriod() {
        return (Number)Kernel.get((Object)((Object)this), (String)"snapshotCopyRetentionPeriod", (NativeType)NativeType.forClass(Number.class));
    }

    public void setSnapshotCopyRetentionPeriod(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"snapshotCopyRetentionPeriod", (Object)value);
    }

    @Nullable
    public String getSnapshotIdentifier() {
        return (String)Kernel.get((Object)((Object)this), (String)"snapshotIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setSnapshotIdentifier(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"snapshotIdentifier", (Object)value);
    }

    @Nullable
    public List<String> getVpcSecurityGroupIds() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"vpcSecurityGroupIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setVpcSecurityGroupIds(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"vpcSecurityGroupIds", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnCluster> {
        private final Construct scope;
        private final String id;
        private final CfnClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnClusterProps.Builder();
        }

        public Builder clusterType(String clusterType) {
            this.props.clusterType(clusterType);
            return this;
        }

        public Builder dbName(String dbName) {
            this.props.dbName(dbName);
            return this;
        }

        public Builder masterUsername(String masterUsername) {
            this.props.masterUsername(masterUsername);
            return this;
        }

        public Builder masterUserPassword(String masterUserPassword) {
            this.props.masterUserPassword(masterUserPassword);
            return this;
        }

        public Builder nodeType(String nodeType) {
            this.props.nodeType(nodeType);
            return this;
        }

        public Builder allowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.props.allowVersionUpgrade(allowVersionUpgrade);
            return this;
        }

        public Builder allowVersionUpgrade(IResolvable allowVersionUpgrade) {
            this.props.allowVersionUpgrade(allowVersionUpgrade);
            return this;
        }

        public Builder aquaConfigurationStatus(String aquaConfigurationStatus) {
            this.props.aquaConfigurationStatus(aquaConfigurationStatus);
            return this;
        }

        public Builder automatedSnapshotRetentionPeriod(Number automatedSnapshotRetentionPeriod) {
            this.props.automatedSnapshotRetentionPeriod(automatedSnapshotRetentionPeriod);
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        public Builder availabilityZoneRelocation(Boolean availabilityZoneRelocation) {
            this.props.availabilityZoneRelocation(availabilityZoneRelocation);
            return this;
        }

        public Builder availabilityZoneRelocation(IResolvable availabilityZoneRelocation) {
            this.props.availabilityZoneRelocation(availabilityZoneRelocation);
            return this;
        }

        public Builder availabilityZoneRelocationStatus(String availabilityZoneRelocationStatus) {
            this.props.availabilityZoneRelocationStatus(availabilityZoneRelocationStatus);
            return this;
        }

        public Builder classic(Boolean classic) {
            this.props.classic(classic);
            return this;
        }

        public Builder classic(IResolvable classic) {
            this.props.classic(classic);
            return this;
        }

        public Builder clusterIdentifier(String clusterIdentifier) {
            this.props.clusterIdentifier(clusterIdentifier);
            return this;
        }

        public Builder clusterParameterGroupName(String clusterParameterGroupName) {
            this.props.clusterParameterGroupName(clusterParameterGroupName);
            return this;
        }

        public Builder clusterSecurityGroups(List<String> clusterSecurityGroups) {
            this.props.clusterSecurityGroups(clusterSecurityGroups);
            return this;
        }

        public Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.props.clusterSubnetGroupName(clusterSubnetGroupName);
            return this;
        }

        public Builder clusterVersion(String clusterVersion) {
            this.props.clusterVersion(clusterVersion);
            return this;
        }

        public Builder deferMaintenance(Boolean deferMaintenance) {
            this.props.deferMaintenance(deferMaintenance);
            return this;
        }

        public Builder deferMaintenance(IResolvable deferMaintenance) {
            this.props.deferMaintenance(deferMaintenance);
            return this;
        }

        public Builder deferMaintenanceDuration(Number deferMaintenanceDuration) {
            this.props.deferMaintenanceDuration(deferMaintenanceDuration);
            return this;
        }

        public Builder deferMaintenanceEndTime(String deferMaintenanceEndTime) {
            this.props.deferMaintenanceEndTime(deferMaintenanceEndTime);
            return this;
        }

        public Builder deferMaintenanceStartTime(String deferMaintenanceStartTime) {
            this.props.deferMaintenanceStartTime(deferMaintenanceStartTime);
            return this;
        }

        public Builder destinationRegion(String destinationRegion) {
            this.props.destinationRegion(destinationRegion);
            return this;
        }

        public Builder elasticIp(String elasticIp) {
            this.props.elasticIp(elasticIp);
            return this;
        }

        public Builder encrypted(Boolean encrypted) {
            this.props.encrypted(encrypted);
            return this;
        }

        public Builder encrypted(IResolvable encrypted) {
            this.props.encrypted(encrypted);
            return this;
        }

        public Builder endpoint(IResolvable endpoint) {
            this.props.endpoint(endpoint);
            return this;
        }

        public Builder endpoint(EndpointProperty endpoint) {
            this.props.endpoint(endpoint);
            return this;
        }

        public Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.props.enhancedVpcRouting(enhancedVpcRouting);
            return this;
        }

        public Builder enhancedVpcRouting(IResolvable enhancedVpcRouting) {
            this.props.enhancedVpcRouting(enhancedVpcRouting);
            return this;
        }

        public Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.props.hsmClientCertificateIdentifier(hsmClientCertificateIdentifier);
            return this;
        }

        public Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.props.hsmConfigurationIdentifier(hsmConfigurationIdentifier);
            return this;
        }

        public Builder iamRoles(List<String> iamRoles) {
            this.props.iamRoles(iamRoles);
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        public Builder loggingProperties(IResolvable loggingProperties) {
            this.props.loggingProperties(loggingProperties);
            return this;
        }

        public Builder loggingProperties(LoggingPropertiesProperty loggingProperties) {
            this.props.loggingProperties(loggingProperties);
            return this;
        }

        public Builder maintenanceTrackName(String maintenanceTrackName) {
            this.props.maintenanceTrackName(maintenanceTrackName);
            return this;
        }

        public Builder manualSnapshotRetentionPeriod(Number manualSnapshotRetentionPeriod) {
            this.props.manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod);
            return this;
        }

        public Builder numberOfNodes(Number numberOfNodes) {
            this.props.numberOfNodes(numberOfNodes);
            return this;
        }

        public Builder ownerAccount(String ownerAccount) {
            this.props.ownerAccount(ownerAccount);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        public Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }

        public Builder publiclyAccessible(IResolvable publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }

        public Builder resourceAction(String resourceAction) {
            this.props.resourceAction(resourceAction);
            return this;
        }

        public Builder revisionTarget(String revisionTarget) {
            this.props.revisionTarget(revisionTarget);
            return this;
        }

        public Builder rotateEncryptionKey(Boolean rotateEncryptionKey) {
            this.props.rotateEncryptionKey(rotateEncryptionKey);
            return this;
        }

        public Builder rotateEncryptionKey(IResolvable rotateEncryptionKey) {
            this.props.rotateEncryptionKey(rotateEncryptionKey);
            return this;
        }

        public Builder snapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.props.snapshotClusterIdentifier(snapshotClusterIdentifier);
            return this;
        }

        public Builder snapshotCopyGrantName(String snapshotCopyGrantName) {
            this.props.snapshotCopyGrantName(snapshotCopyGrantName);
            return this;
        }

        public Builder snapshotCopyManual(Boolean snapshotCopyManual) {
            this.props.snapshotCopyManual(snapshotCopyManual);
            return this;
        }

        public Builder snapshotCopyManual(IResolvable snapshotCopyManual) {
            this.props.snapshotCopyManual(snapshotCopyManual);
            return this;
        }

        public Builder snapshotCopyRetentionPeriod(Number snapshotCopyRetentionPeriod) {
            this.props.snapshotCopyRetentionPeriod(snapshotCopyRetentionPeriod);
            return this;
        }

        public Builder snapshotIdentifier(String snapshotIdentifier) {
            this.props.snapshotIdentifier(snapshotIdentifier);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            this.props.vpcSecurityGroupIds(vpcSecurityGroupIds);
            return this;
        }

        public CfnCluster build() {
            return new CfnCluster(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-redshift.CfnCluster.LoggingPropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoggingPropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketName();

        @Nullable
        default public String getS3KeyPrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoggingPropertiesProperty> {
            private String bucketName;
            private String s3KeyPrefix;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public Builder s3KeyPrefix(String s3KeyPrefix) {
                this.s3KeyPrefix = s3KeyPrefix;
                return this;
            }

            public LoggingPropertiesProperty build() {
                return new Jsii.Proxy(this.bucketName, this.s3KeyPrefix);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-redshift.CfnCluster.EndpointProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EndpointProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAddress() {
            return null;
        }

        @Nullable
        default public String getPort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EndpointProperty> {
            private String address;
            private String port;

            public Builder address(String address) {
                this.address = address;
                return this;
            }

            public Builder port(String port) {
                this.port = port;
                return this;
            }

            public EndpointProperty build() {
                return new Jsii.Proxy(this.address, this.port);
            }
        }
    }
}

