package software.amazon.awscdk.services.redshift.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.redshift.$Module.class, fqn = "@aws-cdk/aws-redshift.cloudformation.ClusterResource")
public class ClusterResource extends software.amazon.awscdk.Resource {
    protected ClusterResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.redshift.cloudformation.ClusterResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::Redshift::Cluster``.
     * @param parent the ``cdk.Construct`` this ``ClusterResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``ClusterResource``
     */
    public ClusterResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.redshift.cloudformation.ClusterResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @cloudformation_attribute Endpoint.Address
     */
    public software.amazon.awscdk.services.redshift.ClusterEndpointAddress getClusterEndpointAddress() {
        return this.jsiiGet("clusterEndpointAddress", software.amazon.awscdk.services.redshift.ClusterEndpointAddress.class);
    }
    /**
     * @cloudformation_attribute Endpoint.Port
     */
    public software.amazon.awscdk.services.redshift.ClusterEndpointPort getClusterEndpointPort() {
        return this.jsiiGet("clusterEndpointPort", software.amazon.awscdk.services.redshift.ClusterEndpointPort.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html
     */
    public static interface LoggingPropertiesProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ClusterResource.LoggingPropertiesProperty.BucketName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-bucketname
         */
        java.lang.Object getBucketName();
        /**
         * ``ClusterResource.LoggingPropertiesProperty.BucketName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-bucketname
         */
        void setBucketName(final java.lang.String value);
        /**
         * ``ClusterResource.LoggingPropertiesProperty.BucketName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-bucketname
         */
        void setBucketName(final software.amazon.awscdk.Token value);
        /**
         * ``ClusterResource.LoggingPropertiesProperty.S3KeyPrefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-s3keyprefix
         */
        java.lang.Object getS3KeyPrefix();
        /**
         * ``ClusterResource.LoggingPropertiesProperty.S3KeyPrefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-s3keyprefix
         */
        void setS3KeyPrefix(final java.lang.String value);
        /**
         * ``ClusterResource.LoggingPropertiesProperty.S3KeyPrefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-s3keyprefix
         */
        void setS3KeyPrefix(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link LoggingPropertiesProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``ClusterResource.LoggingPropertiesProperty.BucketName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-bucketname
             */
            public Build withBucketName(final java.lang.String value) {
                return new FullBuilder().withBucketName(value);
            }
            /**
             * ``ClusterResource.LoggingPropertiesProperty.BucketName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-bucketname
             */
            public Build withBucketName(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withBucketName(value);
            }

            public interface Build {
                /**
                 * @return a new {@link LoggingPropertiesProperty} object, initialized with the values set on this builder.
                 */
                LoggingPropertiesProperty build();
                /**
                 * ``ClusterResource.LoggingPropertiesProperty.S3KeyPrefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-s3keyprefix
                 */
                Build withS3KeyPrefix(final java.lang.String value);
                /**
                 * ``ClusterResource.LoggingPropertiesProperty.S3KeyPrefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-s3keyprefix
                 */
                Build withS3KeyPrefix(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``ClusterResource.LoggingPropertiesProperty.BucketName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-bucketname
                 */
                public Build withBucketName(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "LoggingPropertiesProperty#bucketName is required");
                    this.instance._bucketName = value;
                    return this;
                }
                /**
                 * ``ClusterResource.LoggingPropertiesProperty.BucketName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-bucketname
                 */
                public Build withBucketName(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "LoggingPropertiesProperty#bucketName is required");
                    this.instance._bucketName = value;
                    return this;
                }
                /**
                 * ``ClusterResource.LoggingPropertiesProperty.S3KeyPrefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-s3keyprefix
                 */
                public Build withS3KeyPrefix(final java.lang.String value) {
                    this.instance._s3KeyPrefix = value;
                    return this;
                }
                /**
                 * ``ClusterResource.LoggingPropertiesProperty.S3KeyPrefix``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-s3keyprefix
                 */
                public Build withS3KeyPrefix(final software.amazon.awscdk.Token value) {
                    this.instance._s3KeyPrefix = value;
                    return this;
                }
                public LoggingPropertiesProperty build() {
                    LoggingPropertiesProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link LoggingPropertiesProperty}.
         */
        final class Jsii$Pojo implements LoggingPropertiesProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _bucketName;

            public java.lang.Object getBucketName() {
                return this._bucketName;
            }
            public void setBucketName(final java.lang.String value) {
                this._bucketName = value;
            }
            public void setBucketName(final software.amazon.awscdk.Token value) {
                this._bucketName = value;
            }

            protected java.lang.Object _s3KeyPrefix;

            public java.lang.Object getS3KeyPrefix() {
                return this._s3KeyPrefix;
            }
            public void setS3KeyPrefix(final java.lang.String value) {
                this._s3KeyPrefix = value;
            }
            public void setS3KeyPrefix(final software.amazon.awscdk.Token value) {
                this._s3KeyPrefix = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.redshift.cloudformation.ClusterResource.LoggingPropertiesProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``ClusterResource.LoggingPropertiesProperty.BucketName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-bucketname
             */
            public java.lang.Object getBucketName() {
                return this.jsiiGet("bucketName", java.lang.Object.class);
            }
            /**
             * ``ClusterResource.LoggingPropertiesProperty.BucketName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-bucketname
             */
            public void setBucketName(final java.lang.String value) {
                this.jsiiSet("bucketName", java.util.Objects.requireNonNull(value, "bucketName is required"));
            }
            /**
             * ``ClusterResource.LoggingPropertiesProperty.BucketName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-bucketname
             */
            public void setBucketName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("bucketName", java.util.Objects.requireNonNull(value, "bucketName is required"));
            }
            /**
             * ``ClusterResource.LoggingPropertiesProperty.S3KeyPrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-s3keyprefix
             */
            @javax.annotation.Nullable
            public java.lang.Object getS3KeyPrefix() {
                return this.jsiiGet("s3KeyPrefix", java.lang.Object.class);
            }
            /**
             * ``ClusterResource.LoggingPropertiesProperty.S3KeyPrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-s3keyprefix
             */
            public void setS3KeyPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("s3KeyPrefix", value);
            }
            /**
             * ``ClusterResource.LoggingPropertiesProperty.S3KeyPrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-s3keyprefix
             */
            public void setS3KeyPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("s3KeyPrefix", value);
            }
        }
    }
}
