package software.amazon.awscdk.services.redshift.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-clusterparametergroup.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.redshift.$Module.class, fqn = "@aws-cdk/aws-redshift.cloudformation.ClusterParameterGroupResource")
public class ClusterParameterGroupResource extends software.amazon.awscdk.Resource {
    protected ClusterParameterGroupResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.redshift.cloudformation.ClusterParameterGroupResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::Redshift::ClusterParameterGroup``.
     * @param parent the ``cdk.Construct`` this ``ClusterParameterGroupResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``ClusterParameterGroupResource``
     */
    public ClusterParameterGroupResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.redshift.cloudformation.ClusterParameterGroupResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html
     */
    public static interface ParameterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ClusterParameterGroupResource.ParameterProperty.ParameterName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametername
         */
        java.lang.Object getParameterName();
        /**
         * ``ClusterParameterGroupResource.ParameterProperty.ParameterName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametername
         */
        void setParameterName(final java.lang.String value);
        /**
         * ``ClusterParameterGroupResource.ParameterProperty.ParameterName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametername
         */
        void setParameterName(final software.amazon.awscdk.Token value);
        /**
         * ``ClusterParameterGroupResource.ParameterProperty.ParameterValue``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametervalue
         */
        java.lang.Object getParameterValue();
        /**
         * ``ClusterParameterGroupResource.ParameterProperty.ParameterValue``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametervalue
         */
        void setParameterValue(final java.lang.String value);
        /**
         * ``ClusterParameterGroupResource.ParameterProperty.ParameterValue``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametervalue
         */
        void setParameterValue(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link ParameterProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``ClusterParameterGroupResource.ParameterProperty.ParameterName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametername
             */
            public ParameterValueStep withParameterName(final java.lang.String value) {
                return new FullBuilder().withParameterName(value);
            }
            /**
             * ``ClusterParameterGroupResource.ParameterProperty.ParameterName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametername
             */
            public ParameterValueStep withParameterName(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withParameterName(value);
            }

            public interface ParameterValueStep {
                /**
                 * ``ClusterParameterGroupResource.ParameterProperty.ParameterValue``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametervalue
                 */
                Build withParameterValue(final java.lang.String value);
                /**
                 * ``ClusterParameterGroupResource.ParameterProperty.ParameterValue``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametervalue
                 */
                Build withParameterValue(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link ParameterProperty} object, initialized with the values set on this builder.
                 */
                ParameterProperty build();
            }

            final class FullBuilder implements ParameterValueStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``ClusterParameterGroupResource.ParameterProperty.ParameterName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametername
                 */
                public ParameterValueStep withParameterName(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "ParameterProperty#parameterName is required");
                    this.instance._parameterName = value;
                    return this;
                }
                /**
                 * ``ClusterParameterGroupResource.ParameterProperty.ParameterName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametername
                 */
                public ParameterValueStep withParameterName(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "ParameterProperty#parameterName is required");
                    this.instance._parameterName = value;
                    return this;
                }
                /**
                 * ``ClusterParameterGroupResource.ParameterProperty.ParameterValue``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametervalue
                 */
                public Build withParameterValue(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "ParameterProperty#parameterValue is required");
                    this.instance._parameterValue = value;
                    return this;
                }
                /**
                 * ``ClusterParameterGroupResource.ParameterProperty.ParameterValue``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametervalue
                 */
                public Build withParameterValue(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "ParameterProperty#parameterValue is required");
                    this.instance._parameterValue = value;
                    return this;
                }
                public ParameterProperty build() {
                    ParameterProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ParameterProperty}.
         */
        final class Jsii$Pojo implements ParameterProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _parameterName;

            public java.lang.Object getParameterName() {
                return this._parameterName;
            }
            public void setParameterName(final java.lang.String value) {
                this._parameterName = value;
            }
            public void setParameterName(final software.amazon.awscdk.Token value) {
                this._parameterName = value;
            }

            protected java.lang.Object _parameterValue;

            public java.lang.Object getParameterValue() {
                return this._parameterValue;
            }
            public void setParameterValue(final java.lang.String value) {
                this._parameterValue = value;
            }
            public void setParameterValue(final software.amazon.awscdk.Token value) {
                this._parameterValue = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.redshift.cloudformation.ClusterParameterGroupResource.ParameterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``ClusterParameterGroupResource.ParameterProperty.ParameterName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametername
             */
            public java.lang.Object getParameterName() {
                return this.jsiiGet("parameterName", java.lang.Object.class);
            }
            /**
             * ``ClusterParameterGroupResource.ParameterProperty.ParameterName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametername
             */
            public void setParameterName(final java.lang.String value) {
                this.jsiiSet("parameterName", java.util.Objects.requireNonNull(value, "parameterName is required"));
            }
            /**
             * ``ClusterParameterGroupResource.ParameterProperty.ParameterName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametername
             */
            public void setParameterName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("parameterName", java.util.Objects.requireNonNull(value, "parameterName is required"));
            }
            /**
             * ``ClusterParameterGroupResource.ParameterProperty.ParameterValue``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametervalue
             */
            public java.lang.Object getParameterValue() {
                return this.jsiiGet("parameterValue", java.lang.Object.class);
            }
            /**
             * ``ClusterParameterGroupResource.ParameterProperty.ParameterValue``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametervalue
             */
            public void setParameterValue(final java.lang.String value) {
                this.jsiiSet("parameterValue", java.util.Objects.requireNonNull(value, "parameterValue is required"));
            }
            /**
             * ``ClusterParameterGroupResource.ParameterProperty.ParameterValue``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametervalue
             */
            public void setParameterValue(final software.amazon.awscdk.Token value) {
                this.jsiiSet("parameterValue", java.util.Objects.requireNonNull(value, "parameterValue is required"));
            }
        }
    }
}
