package software.amazon.awscdk.services.redshift;

/**
 * A CloudFormation `AWS::Redshift::ClusterParameterGroup`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-clusterparametergroup.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-06T20:51:31.511Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.redshift.$Module.class, fqn = "@aws-cdk/aws-redshift.CfnClusterParameterGroup")
public class CfnClusterParameterGroup extends software.amazon.awscdk.CfnResource {
    protected CfnClusterParameterGroup(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.redshift.CfnClusterParameterGroup.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::Redshift::ClusterParameterGroup`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnClusterParameterGroup(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.redshift.CfnClusterParameterGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getClusterParameterGroupName() {
        return this.jsiiGet("clusterParameterGroupName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.redshift.CfnClusterParameterGroupProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.redshift.CfnClusterParameterGroupProps.class);
    }

    /**
     * The `TagManager` handles setting, removing and formatting tags.
     * 
     * Tags should be managed either passing them as properties during
     * initiation or by calling methods on this object. If both techniques are
     * used only the tags from the TagManager will be used. `Tag` (aspect)
     * will use the manager.
     */
    public software.amazon.awscdk.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.TagManager.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html
     */
    public static interface ParameterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnClusterParameterGroup.ParameterProperty.ParameterName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametername
         */
        java.lang.String getParameterName();
        /**
         * `CfnClusterParameterGroup.ParameterProperty.ParameterValue`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametervalue
         */
        java.lang.String getParameterValue();

        /**
         * @return a {@link Builder} of {@link ParameterProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ParameterProperty}
         */
        final class Builder {
            private java.lang.String _parameterName;
            private java.lang.String _parameterValue;

            /**
             * Sets the value of ParameterName
             * @param value `CfnClusterParameterGroup.ParameterProperty.ParameterName`.
             * @return {@code this}
             */
            public Builder withParameterName(final java.lang.String value) {
                this._parameterName = java.util.Objects.requireNonNull(value, "parameterName is required");
                return this;
            }
            /**
             * Sets the value of ParameterValue
             * @param value `CfnClusterParameterGroup.ParameterProperty.ParameterValue`.
             * @return {@code this}
             */
            public Builder withParameterValue(final java.lang.String value) {
                this._parameterValue = java.util.Objects.requireNonNull(value, "parameterValue is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ParameterProperty build() {
                return new ParameterProperty() {
                    private final java.lang.String $parameterName = java.util.Objects.requireNonNull(_parameterName, "parameterName is required");
                    private final java.lang.String $parameterValue = java.util.Objects.requireNonNull(_parameterValue, "parameterValue is required");

                    @Override
                    public java.lang.String getParameterName() {
                        return this.$parameterName;
                    }

                    @Override
                    public java.lang.String getParameterValue() {
                        return this.$parameterValue;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("parameterName", om.valueToTree(this.getParameterName()));
                        obj.set("parameterValue", om.valueToTree(this.getParameterValue()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.redshift.CfnClusterParameterGroup.ParameterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnClusterParameterGroup.ParameterProperty.ParameterName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametername
             */
            @Override
            public java.lang.String getParameterName() {
                return this.jsiiGet("parameterName", java.lang.String.class);
            }

            /**
             * `CfnClusterParameterGroup.ParameterProperty.ParameterValue`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-property-redshift-clusterparametergroup-parameter.html#cfn-redshift-clusterparametergroup-parameter-parametervalue
             */
            @Override
            public java.lang.String getParameterValue() {
                return this.jsiiGet("parameterValue", java.lang.String.class);
            }
        }
    }
}
