package software.amazon.awscdk.services.redshift.cloudformation;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.10 (build 35934ad)", date = "2018-11-12T19:54:41.524Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.redshift.$Module.class, fqn = "@aws-cdk/aws-redshift.cloudformation.ClusterResource")
public class ClusterResource extends software.amazon.awscdk.Resource {
    protected ClusterResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.redshift.cloudformation.ClusterResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::Redshift::Cluster``.
     * @param parent the ``cdk.Construct`` this ``ClusterResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``ClusterResource``
     */
    public ClusterResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.redshift.cloudformation.ClusterResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    /**
     * @cloudformation_attribute Endpoint.Address
     */
    public java.lang.String getClusterEndpointAddress() {
        return this.jsiiGet("clusterEndpointAddress", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute Endpoint.Port
     */
    public java.lang.String getClusterEndpointPort() {
        return this.jsiiGet("clusterEndpointPort", java.lang.String.class);
    }

    public java.lang.String getClusterName() {
        return this.jsiiGet("clusterName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.redshift.cloudformation.ClusterResourceProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.redshift.cloudformation.ClusterResourceProps.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html
     */
    public static interface LoggingPropertiesProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ClusterResource.LoggingPropertiesProperty.BucketName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-bucketname
         */
        java.lang.Object getBucketName();
        /**
         * ``ClusterResource.LoggingPropertiesProperty.BucketName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-bucketname
         */
        void setBucketName(final java.lang.String value);
        /**
         * ``ClusterResource.LoggingPropertiesProperty.BucketName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-bucketname
         */
        void setBucketName(final software.amazon.awscdk.Token value);
        /**
         * ``ClusterResource.LoggingPropertiesProperty.S3KeyPrefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-s3keyprefix
         */
        java.lang.Object getS3KeyPrefix();
        /**
         * ``ClusterResource.LoggingPropertiesProperty.S3KeyPrefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-s3keyprefix
         */
        void setS3KeyPrefix(final java.lang.String value);
        /**
         * ``ClusterResource.LoggingPropertiesProperty.S3KeyPrefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-s3keyprefix
         */
        void setS3KeyPrefix(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link LoggingPropertiesProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LoggingPropertiesProperty}
         */
        final class Builder {
            private java.lang.Object _bucketName;
            @javax.annotation.Nullable
            private java.lang.Object _s3KeyPrefix;

            /**
             * Sets the value of BucketName
             * @param value ``ClusterResource.LoggingPropertiesProperty.BucketName``
             * @return {@code this}
             */
            public Builder withBucketName(final java.lang.String value) {
                this._bucketName = java.util.Objects.requireNonNull(value, "bucketName is required");
                return this;
            }
            /**
             * Sets the value of BucketName
             * @param value ``ClusterResource.LoggingPropertiesProperty.BucketName``
             * @return {@code this}
             */
            public Builder withBucketName(final software.amazon.awscdk.Token value) {
                this._bucketName = java.util.Objects.requireNonNull(value, "bucketName is required");
                return this;
            }
            /**
             * Sets the value of S3KeyPrefix
             * @param value ``ClusterResource.LoggingPropertiesProperty.S3KeyPrefix``
             * @return {@code this}
             */
            public Builder withS3KeyPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._s3KeyPrefix = value;
                return this;
            }
            /**
             * Sets the value of S3KeyPrefix
             * @param value ``ClusterResource.LoggingPropertiesProperty.S3KeyPrefix``
             * @return {@code this}
             */
            public Builder withS3KeyPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._s3KeyPrefix = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LoggingPropertiesProperty build() {
                return new LoggingPropertiesProperty() {
                    private java.lang.Object $bucketName = java.util.Objects.requireNonNull(_bucketName, "bucketName is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $s3KeyPrefix = _s3KeyPrefix;

                    @Override
                    public java.lang.Object getBucketName() {
                        return this.$bucketName;
                    }

                    @Override
                    public void setBucketName(final java.lang.String value) {
                        this.$bucketName = java.util.Objects.requireNonNull(value, "bucketName is required");
                    }

                    @Override
                    public void setBucketName(final software.amazon.awscdk.Token value) {
                        this.$bucketName = java.util.Objects.requireNonNull(value, "bucketName is required");
                    }

                    @Override
                    public java.lang.Object getS3KeyPrefix() {
                        return this.$s3KeyPrefix;
                    }

                    @Override
                    public void setS3KeyPrefix(@javax.annotation.Nullable final java.lang.String value) {
                        this.$s3KeyPrefix = value;
                    }

                    @Override
                    public void setS3KeyPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$s3KeyPrefix = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.redshift.cloudformation.ClusterResource.LoggingPropertiesProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ClusterResource.LoggingPropertiesProperty.BucketName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-bucketname
             */
            @Override
            public java.lang.Object getBucketName() {
                return this.jsiiGet("bucketName", java.lang.Object.class);
            }

            /**
             * ``ClusterResource.LoggingPropertiesProperty.BucketName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-bucketname
             */
            @Override
            public void setBucketName(final java.lang.String value) {
                this.jsiiSet("bucketName", java.util.Objects.requireNonNull(value, "bucketName is required"));
            }

            /**
             * ``ClusterResource.LoggingPropertiesProperty.BucketName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-bucketname
             */
            @Override
            public void setBucketName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("bucketName", java.util.Objects.requireNonNull(value, "bucketName is required"));
            }

            /**
             * ``ClusterResource.LoggingPropertiesProperty.S3KeyPrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-s3keyprefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getS3KeyPrefix() {
                return this.jsiiGet("s3KeyPrefix", java.lang.Object.class);
            }

            /**
             * ``ClusterResource.LoggingPropertiesProperty.S3KeyPrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-s3keyprefix
             */
            @Override
            public void setS3KeyPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("s3KeyPrefix", value);
            }

            /**
             * ``ClusterResource.LoggingPropertiesProperty.S3KeyPrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-cluster-loggingproperties.html#cfn-redshift-cluster-loggingproperties-s3keyprefix
             */
            @Override
            public void setS3KeyPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("s3KeyPrefix", value);
            }
        }
    }
}
