/**
 * <h2>Amazon CloudWatch Logs Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This library supplies constructs for working with CloudWatch Logs.
 * <p>
 * <h3>Log Groups/Streams</h3>
 * <p>
 * The basic unit of CloudWatch is a <em>Log Group</em>. Every log group typically has the
 * same kind of data logged to it, in the same format. If there are multiple
 * applications or services logging into the Log Group, each of them creates a new
 * <em>Log Stream</em>.
 * <p>
 * Every log operation creates a "log event", which can consist of a simple string
 * or a single-line JSON object. JSON objects have the advantage that they afford
 * more filtering abilities (see below).
 * <p>
 * The only configurable attribute for log streams is the retention period, which
 * configures after how much time the events in the log stream expire and are
 * deleted.
 * <p>
 * The default retention period if not supplied is 2 years, but it can be set to
 * one of the values in the <code>RetentionDays</code> enum to configure a different
 * retention period (including infinite retention).
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * // Configure log group for short retention
 * LogGroup logGroup = new LogGroup(stack, "LogGroup", new LogGroupProps()
 *         .retention(RetentionDays.getONE_WEEK()));
 * // Configure log group for infinite retention
 * LogGroup logGroup = new LogGroup(stack, "LogGroup", new LogGroupProps()
 *         .retention(Infinity));
 * </pre></blockquote>
 * <p>
 * <h3>Subscriptions and Destinations</h3>
 * <p>
 * Log events matching a particular filter can be sent to either a Lambda function
 * or a Kinesis stream.
 * <p>
 * If the Kinesis stream lives in a different account, a <code>CrossAccountDestination</code>
 * object needs to be added in the destination account which will act as a proxy
 * for the remote Kinesis stream. This object is automatically created for you
 * if you use the CDK Kinesis library.
 * <p>
 * Create a <code>SubscriptionFilter</code>, initialize it with an appropriate <code>Pattern</code> (see
 * below) and supply the intended destination:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var fn = Function.Builder.create(this, "Lambda")....build();
 * var logGroup = LogGroup.Builder.create(this, "LogGroup")....build();
 * 
 * SubscriptionFilter.Builder.create(this, "Subscription")
 *         .logGroup(logGroup)
 *         .destination(new LambdaDestination(fn))
 *         .filterPattern(FilterPattern.allTerms("ERROR", "MainThread"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Metric Filters</h3>
 * <p>
 * CloudWatch Logs can extract and emit metrics based on a textual log stream.
 * Depending on your needs, this may be a more convenient way of generating metrics
 * for you application than making calls to CloudWatch Metrics yourself.
 * <p>
 * A <code>MetricFilter</code> either emits a fixed number every time it sees a log event
 * matching a particular pattern (see below), or extracts a number from the log
 * event and uses that as the metric value.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * new MetricFilter(this, "MetricFilter", new MetricFilterProps()
 *         .logGroup(logGroup)
 *         .metricNamespace("MyApp")
 *         .metricName("Latency")
 *         .filterPattern(FilterPattern.exists("$.latency"))
 *         .metricValue("$.latency"));
 * </pre></blockquote>
 * <p>
 * Remember that if you want to use a value from the log event as the metric value,
 * you must mention it in your pattern somewhere.
 * <p>
 * A very simple MetricFilter can be created by using the <code>logGroup.extractMetric()</code>
 * helper function:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * logGroup.extractMetric("$.jsonField", "Namespace", "MetricName");
 * </pre></blockquote>
 * <p>
 * Will extract the value of <code>jsonField</code> wherever it occurs in JSON-structed
 * log records in the LogGroup, and emit them to CloudWatch Metrics under
 * the name <code>Namespace/MetricName</code>.
 * <p>
 * <h4>Exposing Metric on a Metric Filter</h4>
 * <p>
 * You can expose a metric on a metric filter by calling the <code>MetricFilter.metric()</code> API.
 * This has a default of <code>statistic = 'avg'</code> if the statistic is not set in the <code>props</code>.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var mf = MetricFilter.Builder.create(this, "MetricFilter")
 *         .logGroup(logGroup)
 *         .metricNamespace("MyApp")
 *         .metricName("Latency")
 *         .filterPattern(FilterPattern.exists("$.latency"))
 *         .metricValue("$.latency")
 *         .build();
 * 
 * //expose a metric from the metric filter
 * var metric = mf.metric();
 * 
 * //you can use the metric to create a new alarm
 * //you can use the metric to create a new alarm
 * Alarm.Builder.create(this, "alarm from metric filter")
 *         .metric(metric)
 *         .threshold(100)
 *         .evaluationPeriods(2)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Patterns</h3>
 * <p>
 * Patterns describe which log events match a subscription or metric filter. There
 * are three types of patterns:
 * <p>
 * <ul>
 * <li>Text patterns</li>
 * <li>JSON patterns</li>
 * <li>Space-delimited table patterns</li>
 * </ul>
 * <p>
 * All patterns are constructed by using static functions on the <code>FilterPattern</code>
 * class.
 * <p>
 * In addition to the patterns above, the following special patterns exist:
 * <p>
 * <ul>
 * <li><code>FilterPattern.allEvents()</code>: matches all log events.</li>
 * <li><code>FilterPattern.literal(string)</code>: if you already know what pattern expression to
 * use, this function takes a string and will use that as the log pattern. For
 * more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and Pattern
 * Syntax</a>.</li>
 * </ul>
 * <p>
 * <h4>Text Patterns</h4>
 * <p>
 * Text patterns match if the literal strings appear in the text form of the log
 * line.
 * <p>
 * <ul>
 * <li><code>FilterPattern.allTerms(term, term, ...)</code>: matches if all of the given terms
 * (substrings) appear in the log event.</li>
 * <li><code>FilterPattern.anyTerm(term, term, ...)</code>: matches if all of the given terms
 * (substrings) appear in the log event.</li>
 * <li><code>FilterPattern.anyGroup([term, term, ...], [term, term, ...], ...)</code>: matches if
 * all of the terms in any of the groups (specified as arrays) matches. This is
 * an OR match.</li>
 * </ul>
 * <p>
 * Examples:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // Search for lines that contain both "ERROR" and "MainThread"
 * var pattern1 = FilterPattern.allTerms("ERROR", "MainThread");
 * 
 * // Search for lines that either contain both "ERROR" and "MainThread", or
 * // both "WARN" and "Deadlock".
 * var pattern2 = FilterPattern.anyGroup(asList("ERROR", "MainThread"), asList("WARN", "Deadlock"));
 * </pre></blockquote>
 * <p>
 * <h3>JSON Patterns</h3>
 * <p>
 * JSON patterns apply if the log event is the JSON representation of an object
 * (without any other characters, so it cannot include a prefix such as timestamp
 * or log level). JSON patterns can make comparisons on the values inside the
 * fields.
 * <p>
 * <ul>
 * <li><strong>Strings</strong>: the comparison operators allowed for strings are <code>=</code> and <code>!=</code>.
 * String values can start or end with a <code>*</code> wildcard.</li>
 * <li><strong>Numbers</strong>: the comparison operators allowed for numbers are <code>=</code>, <code>!=</code>,
 * <code>&lt;</code>, <code>&lt;=</code>, <code>&gt;</code>, <code>&gt;=</code>.</li>
 * </ul>
 * <p>
 * Fields in the JSON structure are identified by identifier the complete object as <code>$</code>
 * and then descending into it, such as <code>$.field</code> or <code>$.list[0].field</code>.
 * <p>
 * <ul>
 * <li><code>FilterPattern.stringValue(field, comparison, string)</code>: matches if the given
 * field compares as indicated with the given string value.</li>
 * <li><code>FilterPattern.numberValue(field, comparison, number)</code>: matches if the given
 * field compares as indicated with the given numerical value.</li>
 * <li><code>FilterPattern.isNull(field)</code>: matches if the given field exists and has the
 * value <code>null</code>.</li>
 * <li><code>FilterPattern.notExists(field)</code>: matches if the given field is not in the JSON
 * structure.</li>
 * <li><code>FilterPattern.exists(field)</code>: matches if the given field is in the JSON
 * structure.</li>
 * <li><code>FilterPattern.booleanValue(field, boolean)</code>: matches if the given field
 * is exactly the given boolean value.</li>
 * <li><code>FilterPattern.all(jsonPattern, jsonPattern, ...)</code>: matches if all of the
 * given JSON patterns match. This makes an AND combination of the given
 * patterns.</li>
 * <li><code>FilterPattern.any(jsonPattern, jsonPattern, ...)</code>: matches if any of the
 * given JSON patterns match. This makes an OR combination of the given
 * patterns.</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // Search for all events where the component field is equal to
 * // "HttpServer" and either error is true or the latency is higher
 * // than 1000.
 * var pattern = FilterPattern.all(FilterPattern.stringValue("$.component", "=", "HttpServer"), FilterPattern.any(FilterPattern.booleanValue("$.error", true), FilterPattern.numberValue("$.latency", "&gt;", 1000)));
 * </pre></blockquote>
 * <p>
 * <h3>Space-delimited table patterns</h3>
 * <p>
 * If the log events are rows of a space-delimited table, this pattern can be used
 * to identify the columns in that structure and add conditions on any of them. The
 * canonical example where you would apply this type of pattern is Apache server
 * logs.
 * <p>
 * Text that is surrounded by <code>"..."</code> quotes or <code>[...]</code> square brackets will
 * be treated as one column.
 * <p>
 * <ul>
 * <li><code>FilterPattern.spaceDelimited(column, column, ...)</code>: construct a
 * <code>SpaceDelimitedTextPattern</code> object with the indicated columns. The columns
 * map one-by-one the columns found in the log event. The string <code>"..."</code> may
 * be used to specify an arbitrary number of unnamed columns anywhere in the
 * name list (but may only be specified once).</li>
 * </ul>
 * <p>
 * After constructing a <code>SpaceDelimitedTextPattern</code>, you can use the following
 * two members to add restrictions:
 * <p>
 * <ul>
 * <li><code>pattern.whereString(field, comparison, string)</code>: add a string condition.
 * The rules are the same as for JSON patterns.</li>
 * <li><code>pattern.whereNumber(field, comparison, number)</code>: add a numerical condition.
 * The rules are the same as for JSON patterns.</li>
 * </ul>
 * <p>
 * Multiple restrictions can be added on the same column; they must all apply.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // Search for all events where the component is "HttpServer" and the
 * // result code is not equal to 200.
 * var pattern = FilterPattern.spaceDelimited('time', 'component', '...', 'result_code', 'latency')
 *     .whereString('component', '=', 'HttpServer').whereNumber("result_code", "!=", 200);
 * </pre></blockquote>
 * <p>
 * <h3>Notes</h3>
 * <p>
 * Be aware that Log Group ARNs will always have the string <code>:*</code> appended to
 * them, to match the behavior of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html#aws-resource-logs-loggroup-return-values">the CloudFormation <code>AWS::Logs::LogGroup</code>
 * resource</a>.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.logs;
