package software.amazon.awscdk.services.logs;

/**
 * Properties for a new SubscriptionFilter created from a LogGroup.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:06.543Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.logs.$Module.class, fqn = "@aws-cdk/aws-logs.SubscriptionFilterOptions")
@software.amazon.jsii.Jsii.Proxy(SubscriptionFilterOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SubscriptionFilterOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The destination to send the filtered events to.
     * <p>
     * For example, a Kinesis stream or a Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogSubscriptionDestination getDestination();

    /**
     * Log events matching this pattern will be sent to the destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.IFilterPattern getFilterPattern();

    /**
     * @return a {@link Builder} of {@link SubscriptionFilterOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SubscriptionFilterOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SubscriptionFilterOptions> {
        private software.amazon.awscdk.services.logs.ILogSubscriptionDestination destination;
        private software.amazon.awscdk.services.logs.IFilterPattern filterPattern;

        /**
         * Sets the value of {@link SubscriptionFilterOptions#getDestination}
         * @param destination The destination to send the filtered events to. This parameter is required.
         *                    For example, a Kinesis stream or a Lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(software.amazon.awscdk.services.logs.ILogSubscriptionDestination destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionFilterOptions#getFilterPattern}
         * @param filterPattern Log events matching this pattern will be sent to the destination. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPattern(software.amazon.awscdk.services.logs.IFilterPattern filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubscriptionFilterOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SubscriptionFilterOptions build() {
            return new Jsii$Proxy(destination, filterPattern);
        }
    }

    /**
     * An implementation for {@link SubscriptionFilterOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubscriptionFilterOptions {
        private final software.amazon.awscdk.services.logs.ILogSubscriptionDestination destination;
        private final software.amazon.awscdk.services.logs.IFilterPattern filterPattern;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destination = this.jsiiGet("destination", software.amazon.awscdk.services.logs.ILogSubscriptionDestination.class);
            this.filterPattern = this.jsiiGet("filterPattern", software.amazon.awscdk.services.logs.IFilterPattern.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.logs.ILogSubscriptionDestination destination, final software.amazon.awscdk.services.logs.IFilterPattern filterPattern) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destination = java.util.Objects.requireNonNull(destination, "destination is required");
            this.filterPattern = java.util.Objects.requireNonNull(filterPattern, "filterPattern is required");
        }

        @Override
        public software.amazon.awscdk.services.logs.ILogSubscriptionDestination getDestination() {
            return this.destination;
        }

        @Override
        public software.amazon.awscdk.services.logs.IFilterPattern getFilterPattern() {
            return this.filterPattern;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destination", om.valueToTree(this.getDestination()));
            data.set("filterPattern", om.valueToTree(this.getFilterPattern()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-logs.SubscriptionFilterOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubscriptionFilterOptions.Jsii$Proxy that = (SubscriptionFilterOptions.Jsii$Proxy) o;

            if (!destination.equals(that.destination)) return false;
            return this.filterPattern.equals(that.filterPattern);
        }

        @Override
        public int hashCode() {
            int result = this.destination.hashCode();
            result = 31 * result + (this.filterPattern.hashCode());
            return result;
        }
    }
}
