package software.amazon.awscdk.services.logs;

/**
 * Properties for a LogGroup.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:06.540Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.logs.$Module.class, fqn = "@aws-cdk/aws-logs.LogGroupProps")
@software.amazon.jsii.Jsii.Proxy(LogGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LogGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of the log group.
     * <p>
     * Default: Automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogGroupName() {
        return null;
    }

    /**
     * Determine the removal policy of this log group.
     * <p>
     * Normally you want to retain the log group so you can diagnose issues
     * from logs even after a deployment that no longer includes the log group.
     * In that case, use the normal date-based retention policy to age out your
     * logs.
     * <p>
     * Default: RemovalPolicy.Retain
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * How long, in days, the log contents will be retained.
     * <p>
     * To retain all logs, set this value to RetentionDays.INFINITE.
     * <p>
     * Default: RetentionDays.TWO_YEARS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getRetention() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LogGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LogGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LogGroupProps> {
        private java.lang.String logGroupName;
        private software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private software.amazon.awscdk.services.logs.RetentionDays retention;

        /**
         * Sets the value of {@link LogGroupProps#getLogGroupName}
         * @param logGroupName Name of the log group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupName(java.lang.String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        /**
         * Sets the value of {@link LogGroupProps#getRemovalPolicy}
         * @param removalPolicy Determine the removal policy of this log group.
         *                      Normally you want to retain the log group so you can diagnose issues
         *                      from logs even after a deployment that no longer includes the log group.
         *                      In that case, use the normal date-based retention policy to age out your
         *                      logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link LogGroupProps#getRetention}
         * @param retention How long, in days, the log contents will be retained.
         *                  To retain all logs, set this value to RetentionDays.INFINITE.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retention(software.amazon.awscdk.services.logs.RetentionDays retention) {
            this.retention = retention;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LogGroupProps build() {
            return new Jsii$Proxy(logGroupName, removalPolicy, retention);
        }
    }

    /**
     * An implementation for {@link LogGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogGroupProps {
        private final java.lang.String logGroupName;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.services.logs.RetentionDays retention;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logGroupName = this.jsiiGet("logGroupName", java.lang.String.class);
            this.removalPolicy = this.jsiiGet("removalPolicy", software.amazon.awscdk.core.RemovalPolicy.class);
            this.retention = this.jsiiGet("retention", software.amazon.awscdk.services.logs.RetentionDays.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String logGroupName, final software.amazon.awscdk.core.RemovalPolicy removalPolicy, final software.amazon.awscdk.services.logs.RetentionDays retention) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logGroupName = logGroupName;
            this.removalPolicy = removalPolicy;
            this.retention = retention;
        }

        @Override
        public java.lang.String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public software.amazon.awscdk.services.logs.RetentionDays getRetention() {
            return this.retention;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getLogGroupName() != null) {
                data.set("logGroupName", om.valueToTree(this.getLogGroupName()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getRetention() != null) {
                data.set("retention", om.valueToTree(this.getRetention()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-logs.LogGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LogGroupProps.Jsii$Proxy that = (LogGroupProps.Jsii$Proxy) o;

            if (this.logGroupName != null ? !this.logGroupName.equals(that.logGroupName) : that.logGroupName != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            return this.retention != null ? this.retention.equals(that.retention) : that.retention == null;
        }

        @Override
        public int hashCode() {
            int result = this.logGroupName != null ? this.logGroupName.hashCode() : 0;
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.retention != null ? this.retention.hashCode() : 0);
            return result;
        }
    }
}
