package software.amazon.awscdk.services.logs;

/**
 * Properties for a CrossAccountDestination.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:06.537Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.logs.$Module.class, fqn = "@aws-cdk/aws-logs.CrossAccountDestinationProps")
@software.amazon.jsii.Jsii.Proxy(CrossAccountDestinationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CrossAccountDestinationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The role to assume that grants permissions to write to 'target'.
     * <p>
     * The role must be assumable by 'logs.{REGION}.amazonaws.com'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole();

    /**
     * The log destination target's ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetArn();

    /**
     * The name of the log destination.
     * <p>
     * Default: Automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CrossAccountDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CrossAccountDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CrossAccountDestinationProps> {
        private software.amazon.awscdk.services.iam.IRole role;
        private java.lang.String targetArn;
        private java.lang.String destinationName;

        /**
         * Sets the value of {@link CrossAccountDestinationProps#getRole}
         * @param role The role to assume that grants permissions to write to 'target'. This parameter is required.
         *             The role must be assumable by 'logs.{REGION}.amazonaws.com'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CrossAccountDestinationProps#getTargetArn}
         * @param targetArn The log destination target's ARN. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetArn(java.lang.String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        /**
         * Sets the value of {@link CrossAccountDestinationProps#getDestinationName}
         * @param destinationName The name of the log destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationName(java.lang.String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CrossAccountDestinationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CrossAccountDestinationProps build() {
            return new Jsii$Proxy(role, targetArn, destinationName);
        }
    }

    /**
     * An implementation for {@link CrossAccountDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CrossAccountDestinationProps {
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String targetArn;
        private final java.lang.String destinationName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.role = this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
            this.targetArn = this.jsiiGet("targetArn", java.lang.String.class);
            this.destinationName = this.jsiiGet("destinationName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.iam.IRole role, final java.lang.String targetArn, final java.lang.String destinationName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.role = java.util.Objects.requireNonNull(role, "role is required");
            this.targetArn = java.util.Objects.requireNonNull(targetArn, "targetArn is required");
            this.destinationName = destinationName;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public java.lang.String getTargetArn() {
            return this.targetArn;
        }

        @Override
        public java.lang.String getDestinationName() {
            return this.destinationName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("role", om.valueToTree(this.getRole()));
            data.set("targetArn", om.valueToTree(this.getTargetArn()));
            if (this.getDestinationName() != null) {
                data.set("destinationName", om.valueToTree(this.getDestinationName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-logs.CrossAccountDestinationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CrossAccountDestinationProps.Jsii$Proxy that = (CrossAccountDestinationProps.Jsii$Proxy) o;

            if (!role.equals(that.role)) return false;
            if (!targetArn.equals(that.targetArn)) return false;
            return this.destinationName != null ? this.destinationName.equals(that.destinationName) : that.destinationName == null;
        }

        @Override
        public int hashCode() {
            int result = this.role.hashCode();
            result = 31 * result + (this.targetArn.hashCode());
            result = 31 * result + (this.destinationName != null ? this.destinationName.hashCode() : 0);
            return result;
        }
    }
}
