/**
 * <h2>AWS Key Management Service Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * Define a KMS key:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.kms.*;
 * 
 * new Key(this, "MyKey", new KeyProps()
 *         .enableKeyRotation(true));
 * </pre></blockquote>
 * <p>
 * Add a couple of aliases:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var key = new Key(this, "MyKey");
 * key.addAlias("alias/foo");
 * key.addAlias("alias/bar");
 * </pre></blockquote>
 * <p>
 * <h3>Sharing keys between stacks</h3>
 * <p>
 * <blockquote>
 * <p>
 * see Trust Account Identities for additional details
 * <p>
 * </blockquote>
 * <p>
 * To use a KMS key in a different stack in the same CDK application,
 * pass the construct to the other stack:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * /**
 *  * Stack that defines the key
 *  *{@literal /}
 * public class KeyStack extends Stack {
 *     public final Key key;
 * 
 *     public KeyStack(App scope, String id) {
 *         this(scope, id, null);
 *     }
 * 
 *     public KeyStack(App scope, String id, StackProps props) {
 *         super(scope, id, props);
 *         this.key = new Key(this, "MyKey", new KeyProps().removalPolicy(cdk.RemovalPolicy.getDESTROY()));
 *     }
 * }
 * 
 * public class UseStackProps extends StackProps {
 *     private IKey key;
 *     public IKey getKey() {
 *         return this.key;
 *     }
 *     public UseStackProps key(IKey key) {
 *         this.key = key;
 *         return this;
 *     }
 * }
 * 
 * /**
 *  * Stack that uses the key
 *  *{@literal /}
 * public class UseStack extends Stack {
 *     public UseStack(App scope, String id, UseStackProps props) {
 *         super(scope, id, props);
 * 
 *         // Use the IKey object here.
 *         // Use the IKey object here.
 *         new Alias(this, "Alias", new AliasProps()
 *                 .aliasName("alias/foo")
 *                 .targetKey(props.getKey()));
 *     }
 * }
 * 
 * KeyStack keyStack = new KeyStack(app, "KeyStack");
 * new UseStack(app, "UseStack", new UseStackProps().key(keyStack.getKey()));
 * </pre></blockquote>
 * <p>
 * <h3>Importing existing keys</h3>
 * <p>
 * <blockquote>
 * <p>
 * see Trust Account Identities for additional details
 * <p>
 * </blockquote>
 * <p>
 * To use a KMS key that is not defined in this CDK app, but is created through other means, use
 * <code>Key.fromKeyArn(parent, name, ref)</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var myKeyImported = kms.Key.fromKeyArn(this, "MyImportedKey", "arn:aws:...");
 * 
 * // you can do stuff with this imported key.
 * myKeyImported.addAlias("alias/foo");
 * </pre></blockquote>
 * <p>
 * Note that a call to <code>.addToPolicy(statement)</code> on <code>myKeyImported</code> will not have
 * an affect on the key's policy because it is not owned by your stack. The call
 * will be a no-op.
 * <p>
 * If a Key has an associated Alias, the Alias can be imported by name and used in place
 * of the Key as a reference. A common scenario for this is in referencing AWS managed keys.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var myKeyAlias = kms.Alias.fromAliasName(this, "myKey", "alias/aws/s3");
 * var trail = Trail.Builder.create(this, "myCloudTrail")
 *         .sendToCloudWatchLogs(true)
 *         .kmsKey(myKeyAlias)
 *         .build();
 * </pre></blockquote>
 * <p>
 * Note that calls to <code>addToResourcePolicy</code> and <code>grant*</code> methods on <code>myKeyAlias</code> will be
 * no-ops, and <code>addAlias</code> and <code>aliasTargetKey</code> will fail, as the imported alias does not
 * have a reference to the underlying KMS Key.
 * <p>
 * <h3>Trust Account Identities</h3>
 * <p>
 * KMS keys can be created to trust IAM policies. This is the default behavior in
 * the console and is described
 * <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">here</a>.
 * This same behavior can be enabled by:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Key.Builder.create(stack, "MyKey").trustAccountIdentities(true).build();
 * </pre></blockquote>
 * <p>
 * Using <code>trustAccountIdentities</code> solves many issues around cyclic dependencies
 * between stacks. The most common use case is creating an S3 Bucket with CMK
 * default encryption which is later accessed by IAM roles in other stacks.
 * <p>
 * stack-1 (bucket and key created)
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // ... snip
 * var myKmsKey = Key.Builder.create(this, "MyKey").trustAccountIdentities(true).build();
 * 
 * var bucket = Bucket.Builder.create(this, "MyEncryptedBucket")
 *         .bucketName("myEncryptedBucket")
 *         .encryption(BucketEncryption.getKMS())
 *         .encryptionKey(myKmsKey)
 *         .build();
 * </pre></blockquote>
 * <p>
 * stack-2 (lambda that operates on bucket and key)
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // ... snip
 * 
 * var fn = Function.Builder.create(this, "MyFunction")
 *         .runtime(lambda.Runtime.getNODEJS_10_X())
 *         .handler("index.handler")
 *         .code(lambda.Code.fromAsset(path.join(__dirname, "lambda-handler")))
 *         .build();
 * 
 * var bucket = s3.Bucket.fromBucketName(this, "BucketId", "myEncryptedBucket");
 * 
 * var key = kms.Key.fromKeyArn(this, "KeyId", "arn:aws:...");// key ARN passed via stack props
 * 
 * bucket.grantReadWrite(fn);
 * key.grantEncryptDecrypt(fn);
 * </pre></blockquote>
 * <p>
 * The challenge in this scenario is the KMS key policy behavior. The simple way to understand
 * this, is IAM policies for account entities can only grant the permissions granted to the
 * account root principle in the key policy. When <code>trustAccountIdentities</code> is true,
 * the following policy statement is added:
 * <p>
 * <blockquote><pre>
 * {
 *   "Sid": "Enable IAM User Permissions",
 *   "Effect": "Allow",
 *   "Principal": {"AWS": "arn:aws:iam::111122223333:root"},
 *   "Action": "kms:*",
 *   "Resource": "*"
 * }
 * </pre></blockquote>
 * <p>
 * As the name suggests this trusts IAM policies to control access to the key.
 * If account root does not have permissions to the specific actions, then the key
 * policy and the IAM policy for the entity (e.g. Lambda) both need to grant
 * permission.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.kms;
