package software.amazon.awscdk.services.kms;

/**
 * Construction properties for a KMS Key object.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:02.901Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kms.$Module.class, fqn = "@aws-cdk/aws-kms.KeyProps")
@software.amazon.jsii.Jsii.Proxy(KeyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KeyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Initial alias to add to the key.
     * <p>
     * More aliases can be added later by calling <code>addAlias</code>.
     * <p>
     * Default: - No alias is added for the key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlias() {
        return null;
    }

    /**
     * A description of the key.
     * <p>
     * Use a description that helps your users decide
     * whether the key is appropriate for a particular task.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Indicates whether the key is available for use.
     * <p>
     * Default: - Key is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * Indicates whether AWS KMS rotates the key.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableKeyRotation() {
        return null;
    }

    /**
     * Custom policy document to attach to the KMS key.
     * <p>
     * Default: - A policy document with permissions for the account root to
     * administer the key will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument getPolicy() {
        return null;
    }

    /**
     * Whether the encryption key should be retained when it is removed from the Stack.
     * <p>
     * This is useful when one wants to
     * retain access to data that was encrypted with a key that is being retired.
     * <p>
     * Default: RemovalPolicy.Retain
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * Whether the key usage can be granted by IAM policies.
     * <p>
     * Setting this to true adds a default statement which delegates key
     * access control completely to the identity's IAM policy (similar
     * to how it works for other AWS resources).
     * <p>
     * Default: false
     * <p>
     * @see https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getTrustAccountIdentities() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link KeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KeyProps> {
        private java.lang.String alias;
        private java.lang.String description;
        private java.lang.Boolean enabled;
        private java.lang.Boolean enableKeyRotation;
        private software.amazon.awscdk.services.iam.PolicyDocument policy;
        private software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private java.lang.Boolean trustAccountIdentities;

        /**
         * Sets the value of {@link KeyProps#getAlias}
         * @param alias Initial alias to add to the key.
         *              More aliases can be added later by calling <code>addAlias</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alias(java.lang.String alias) {
            this.alias = alias;
            return this;
        }

        /**
         * Sets the value of {@link KeyProps#getDescription}
         * @param description A description of the key.
         *                    Use a description that helps your users decide
         *                    whether the key is appropriate for a particular task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link KeyProps#getEnabled}
         * @param enabled Indicates whether the key is available for use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link KeyProps#getEnableKeyRotation}
         * @param enableKeyRotation Indicates whether AWS KMS rotates the key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableKeyRotation(java.lang.Boolean enableKeyRotation) {
            this.enableKeyRotation = enableKeyRotation;
            return this;
        }

        /**
         * Sets the value of {@link KeyProps#getPolicy}
         * @param policy Custom policy document to attach to the KMS key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(software.amazon.awscdk.services.iam.PolicyDocument policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link KeyProps#getRemovalPolicy}
         * @param removalPolicy Whether the encryption key should be retained when it is removed from the Stack.
         *                      This is useful when one wants to
         *                      retain access to data that was encrypted with a key that is being retired.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link KeyProps#getTrustAccountIdentities}
         * @param trustAccountIdentities Whether the key usage can be granted by IAM policies.
         *                               Setting this to true adds a default statement which delegates key
         *                               access control completely to the identity's IAM policy (similar
         *                               to how it works for other AWS resources).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trustAccountIdentities(java.lang.Boolean trustAccountIdentities) {
            this.trustAccountIdentities = trustAccountIdentities;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KeyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KeyProps build() {
            return new Jsii$Proxy(alias, description, enabled, enableKeyRotation, policy, removalPolicy, trustAccountIdentities);
        }
    }

    /**
     * An implementation for {@link KeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyProps {
        private final java.lang.String alias;
        private final java.lang.String description;
        private final java.lang.Boolean enabled;
        private final java.lang.Boolean enableKeyRotation;
        private final software.amazon.awscdk.services.iam.PolicyDocument policy;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final java.lang.Boolean trustAccountIdentities;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alias = this.jsiiGet("alias", java.lang.String.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.enabled = this.jsiiGet("enabled", java.lang.Boolean.class);
            this.enableKeyRotation = this.jsiiGet("enableKeyRotation", java.lang.Boolean.class);
            this.policy = this.jsiiGet("policy", software.amazon.awscdk.services.iam.PolicyDocument.class);
            this.removalPolicy = this.jsiiGet("removalPolicy", software.amazon.awscdk.core.RemovalPolicy.class);
            this.trustAccountIdentities = this.jsiiGet("trustAccountIdentities", java.lang.Boolean.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String alias, final java.lang.String description, final java.lang.Boolean enabled, final java.lang.Boolean enableKeyRotation, final software.amazon.awscdk.services.iam.PolicyDocument policy, final software.amazon.awscdk.core.RemovalPolicy removalPolicy, final java.lang.Boolean trustAccountIdentities) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alias = alias;
            this.description = description;
            this.enabled = enabled;
            this.enableKeyRotation = enableKeyRotation;
            this.policy = policy;
            this.removalPolicy = removalPolicy;
            this.trustAccountIdentities = trustAccountIdentities;
        }

        @Override
        public java.lang.String getAlias() {
            return this.alias;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public java.lang.Boolean getEnableKeyRotation() {
            return this.enableKeyRotation;
        }

        @Override
        public software.amazon.awscdk.services.iam.PolicyDocument getPolicy() {
            return this.policy;
        }

        @Override
        public software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public java.lang.Boolean getTrustAccountIdentities() {
            return this.trustAccountIdentities;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAlias() != null) {
                data.set("alias", om.valueToTree(this.getAlias()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getEnableKeyRotation() != null) {
                data.set("enableKeyRotation", om.valueToTree(this.getEnableKeyRotation()));
            }
            if (this.getPolicy() != null) {
                data.set("policy", om.valueToTree(this.getPolicy()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getTrustAccountIdentities() != null) {
                data.set("trustAccountIdentities", om.valueToTree(this.getTrustAccountIdentities()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-kms.KeyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KeyProps.Jsii$Proxy that = (KeyProps.Jsii$Proxy) o;

            if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.enableKeyRotation != null ? !this.enableKeyRotation.equals(that.enableKeyRotation) : that.enableKeyRotation != null) return false;
            if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            return this.trustAccountIdentities != null ? this.trustAccountIdentities.equals(that.trustAccountIdentities) : that.trustAccountIdentities == null;
        }

        @Override
        public int hashCode() {
            int result = this.alias != null ? this.alias.hashCode() : 0;
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.enableKeyRotation != null ? this.enableKeyRotation.hashCode() : 0);
            result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.trustAccountIdentities != null ? this.trustAccountIdentities.hashCode() : 0);
            return result;
        }
    }
}
