package software.amazon.awscdk.services.kms;

/**
 * Defines a display name for a customer master key (CMK) in AWS Key Management Service (AWS KMS).
 * <p>
 * Using an alias to refer to a key can help you simplify key
 * management. For example, when rotating keys, you can just update the alias
 * mapping instead of tracking and changing key IDs. For more information, see
 * Working with Aliases in the AWS Key Management Service Developer Guide.
 * <p>
 * You can also add an alias for a key by calling <code>key.addAlias(alias)</code>.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:02.897Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kms.$Module.class, fqn = "@aws-cdk/aws-kms.Alias")
public class Alias extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.kms.IAlias {

    protected Alias(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Alias(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Alias(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.AliasProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing KMS Alias defined outside the CDK app.
     * <p>
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param attrs the properties of the referenced KMS Alias. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.IAlias fromAliasAttributes(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.AliasAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kms.Alias.class, "fromAliasAttributes", software.amazon.awscdk.services.kms.IAlias.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Import an existing KMS Alias defined outside the CDK app, by the alias name.
     * <p>
     * This method should be used
     * instead of 'fromAliasAttributes' when the underlying KMS Key ARN is not available.
     * This Alias will not have a direct reference to the KMS Key, so addAlias and grant* methods are not supported.
     * <p>
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param aliasName The full name of the KMS Alias (e.g., 'alias/aws/s3', 'alias/myKeyAlias'). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.IAlias fromAliasName(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String aliasName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kms.Alias.class, "fromAliasName", software.amazon.awscdk.services.kms.IAlias.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(aliasName, "aliasName is required") });
    }

    /**
     * Defines a new alias for the key.
     * <p>
     * @param alias This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.Alias addAlias(final @org.jetbrains.annotations.NotNull java.lang.String alias) {
        return this.jsiiCall("addAlias", software.amazon.awscdk.services.kms.Alias.class, new Object[] { java.util.Objects.requireNonNull(alias, "alias is required") });
    }

    /**
     * Adds a statement to the KMS key resource policy.
     * <p>
     * @param statement This parameter is required.
     * @param allowNoOp
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement, final @org.jetbrains.annotations.Nullable java.lang.Boolean allowNoOp) {
        return this.jsiiCall("addToResourcePolicy", software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required"), allowNoOp });
    }

    /**
     * Adds a statement to the KMS key resource policy.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return this.jsiiCall("addToResourcePolicy", software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.lang.String generatePhysicalName() {
        return this.jsiiCall("generatePhysicalName", java.lang.String.class);
    }

    /**
     * Grant the indicated permissions on this key to the given principal.
     * <p>
     * @param grantee This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return this.jsiiCall("grant", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Grant decryption permisisons using this key to the given principal.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDecrypt(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantDecrypt", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant encryption permisisons using this key to the given principal.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantEncrypt(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantEncrypt", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant encryption and decryption permisisons using this key to the given principal.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantEncryptDecrypt(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantEncryptDecrypt", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * The name of the alias.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAliasName() {
        return this.jsiiGet("aliasName", java.lang.String.class);
    }

    /**
     * The Key to which the Alias refers.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.IKey getAliasTargetKey() {
        return this.jsiiGet("aliasTargetKey", software.amazon.awscdk.services.kms.IKey.class);
    }

    /**
     * The ARN of the key.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyArn() {
        return this.jsiiGet("keyArn", java.lang.String.class);
    }

    /**
     * The ID of the key (the part that looks something like: 1234abcd-12ab-34cd-56ef-1234567890ab).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyId() {
        return this.jsiiGet("keyId", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kms.Alias}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kms.Alias> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.kms.AliasProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.kms.AliasProps.Builder();
        }

        /**
         * The name of the alias.
         * <p>
         * The name must start with alias followed by a
         * forward slash, such as alias/. You can't specify aliases that begin with
         * alias/AWS. These aliases are reserved.
         * <p>
         * @return {@code this}
         * @param aliasName The name of the alias. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliasName(final java.lang.String aliasName) {
            this.props.aliasName(aliasName);
            return this;
        }

        /**
         * The ID of the key for which you are creating the alias.
         * <p>
         * Specify the key's
         * globally unique identifier or Amazon Resource Name (ARN). You can't
         * specify another alias.
         * <p>
         * @return {@code this}
         * @param targetKey The ID of the key for which you are creating the alias. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetKey(final software.amazon.awscdk.services.kms.IKey targetKey) {
            this.props.targetKey(targetKey);
            return this;
        }

        /**
         * Policy to apply when the alias is removed from this stack.
         * <p>
         * Default: - The alias will be deleted
         * <p>
         * @return {@code this}
         * @param removalPolicy Policy to apply when the alias is removed from this stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.kms.Alias}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kms.Alias build() {
            return new software.amazon.awscdk.services.kms.Alias(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
