package software.amazon.awscdk.services.events;

/**
 * Interface with properties necessary to import a reusable EventBus.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.27.0 (build 07d848a)", date = "2021-04-12T10:04:27.696Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.$Module.class, fqn = "@aws-cdk/aws-events.EventBusAttributes")
@software.amazon.jsii.Jsii.Proxy(EventBusAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EventBusAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of this event bus resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEventBusArn();

    /**
     * The physical ID of this event bus resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEventBusName();

    /**
     * The JSON policy of this event bus resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEventBusPolicy();

    /**
     * The partner event source to associate with this event bus resource.
     * <p>
     * Default: - no partner event source
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEventSourceName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EventBusAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EventBusAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EventBusAttributes> {
        private java.lang.String eventBusArn;
        private java.lang.String eventBusName;
        private java.lang.String eventBusPolicy;
        private java.lang.String eventSourceName;

        /**
         * Sets the value of {@link EventBusAttributes#getEventBusArn}
         * @param eventBusArn The ARN of this event bus resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBusArn(java.lang.String eventBusArn) {
            this.eventBusArn = eventBusArn;
            return this;
        }

        /**
         * Sets the value of {@link EventBusAttributes#getEventBusName}
         * @param eventBusName The physical ID of this event bus resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBusName(java.lang.String eventBusName) {
            this.eventBusName = eventBusName;
            return this;
        }

        /**
         * Sets the value of {@link EventBusAttributes#getEventBusPolicy}
         * @param eventBusPolicy The JSON policy of this event bus resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBusPolicy(java.lang.String eventBusPolicy) {
            this.eventBusPolicy = eventBusPolicy;
            return this;
        }

        /**
         * Sets the value of {@link EventBusAttributes#getEventSourceName}
         * @param eventSourceName The partner event source to associate with this event bus resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSourceName(java.lang.String eventSourceName) {
            this.eventSourceName = eventSourceName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventBusAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EventBusAttributes build() {
            return new Jsii$Proxy(eventBusArn, eventBusName, eventBusPolicy, eventSourceName);
        }
    }

    /**
     * An implementation for {@link EventBusAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventBusAttributes {
        private final java.lang.String eventBusArn;
        private final java.lang.String eventBusName;
        private final java.lang.String eventBusPolicy;
        private final java.lang.String eventSourceName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventBusArn = software.amazon.jsii.Kernel.get(this, "eventBusArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventBusName = software.amazon.jsii.Kernel.get(this, "eventBusName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventBusPolicy = software.amazon.jsii.Kernel.get(this, "eventBusPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventSourceName = software.amazon.jsii.Kernel.get(this, "eventSourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String eventBusArn, final java.lang.String eventBusName, final java.lang.String eventBusPolicy, final java.lang.String eventSourceName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventBusArn = java.util.Objects.requireNonNull(eventBusArn, "eventBusArn is required");
            this.eventBusName = java.util.Objects.requireNonNull(eventBusName, "eventBusName is required");
            this.eventBusPolicy = java.util.Objects.requireNonNull(eventBusPolicy, "eventBusPolicy is required");
            this.eventSourceName = eventSourceName;
        }

        @Override
        public final java.lang.String getEventBusArn() {
            return this.eventBusArn;
        }

        @Override
        public final java.lang.String getEventBusName() {
            return this.eventBusName;
        }

        @Override
        public final java.lang.String getEventBusPolicy() {
            return this.eventBusPolicy;
        }

        @Override
        public final java.lang.String getEventSourceName() {
            return this.eventSourceName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventBusArn", om.valueToTree(this.getEventBusArn()));
            data.set("eventBusName", om.valueToTree(this.getEventBusName()));
            data.set("eventBusPolicy", om.valueToTree(this.getEventBusPolicy()));
            if (this.getEventSourceName() != null) {
                data.set("eventSourceName", om.valueToTree(this.getEventSourceName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-events.EventBusAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EventBusAttributes.Jsii$Proxy that = (EventBusAttributes.Jsii$Proxy) o;

            if (!eventBusArn.equals(that.eventBusArn)) return false;
            if (!eventBusName.equals(that.eventBusName)) return false;
            if (!eventBusPolicy.equals(that.eventBusPolicy)) return false;
            return this.eventSourceName != null ? this.eventSourceName.equals(that.eventSourceName) : that.eventSourceName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.eventBusArn.hashCode();
            result = 31 * result + (this.eventBusName.hashCode());
            result = 31 * result + (this.eventBusPolicy.hashCode());
            result = 31 * result + (this.eventSourceName != null ? this.eventSourceName.hashCode() : 0);
            return result;
        }
    }
}
