package software.amazon.awscdk.services.events;

/**
 * The event archive properties.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.26.0 (build 7d76e02)", date = "2021-04-01T14:11:42.270Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.$Module.class, fqn = "@aws-cdk/aws-events.ArchiveProps")
@software.amazon.jsii.Jsii.Proxy(ArchiveProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ArchiveProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.events.BaseArchiveProps {

    /**
     * The event source associated with the archive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IEventBus getSourceEventBus();

    /**
     * @return a {@link Builder} of {@link ArchiveProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ArchiveProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ArchiveProps> {
        private software.amazon.awscdk.services.events.IEventBus sourceEventBus;
        private software.amazon.awscdk.services.events.EventPattern eventPattern;
        private java.lang.String archiveName;
        private java.lang.String description;
        private software.amazon.awscdk.core.Duration retention;

        /**
         * Sets the value of {@link ArchiveProps#getSourceEventBus}
         * @param sourceEventBus The event source associated with the archive. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceEventBus(software.amazon.awscdk.services.events.IEventBus sourceEventBus) {
            this.sourceEventBus = sourceEventBus;
            return this;
        }

        /**
         * Sets the value of {@link ArchiveProps#getEventPattern}
         * @param eventPattern An event pattern to use to filter events sent to the archive. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventPattern(software.amazon.awscdk.services.events.EventPattern eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        /**
         * Sets the value of {@link ArchiveProps#getArchiveName}
         * @param archiveName The name of the archive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder archiveName(java.lang.String archiveName) {
            this.archiveName = archiveName;
            return this;
        }

        /**
         * Sets the value of {@link ArchiveProps#getDescription}
         * @param description A description for the archive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ArchiveProps#getRetention}
         * @param retention The number of days to retain events for.
         *                  Default value is 0. If set to 0, events are retained indefinitely.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retention(software.amazon.awscdk.core.Duration retention) {
            this.retention = retention;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ArchiveProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ArchiveProps build() {
            return new Jsii$Proxy(sourceEventBus, eventPattern, archiveName, description, retention);
        }
    }

    /**
     * An implementation for {@link ArchiveProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArchiveProps {
        private final software.amazon.awscdk.services.events.IEventBus sourceEventBus;
        private final software.amazon.awscdk.services.events.EventPattern eventPattern;
        private final java.lang.String archiveName;
        private final java.lang.String description;
        private final software.amazon.awscdk.core.Duration retention;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sourceEventBus = software.amazon.jsii.Kernel.get(this, "sourceEventBus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.IEventBus.class));
            this.eventPattern = software.amazon.jsii.Kernel.get(this, "eventPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.EventPattern.class));
            this.archiveName = software.amazon.jsii.Kernel.get(this, "archiveName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.retention = software.amazon.jsii.Kernel.get(this, "retention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.events.IEventBus sourceEventBus, final software.amazon.awscdk.services.events.EventPattern eventPattern, final java.lang.String archiveName, final java.lang.String description, final software.amazon.awscdk.core.Duration retention) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sourceEventBus = java.util.Objects.requireNonNull(sourceEventBus, "sourceEventBus is required");
            this.eventPattern = java.util.Objects.requireNonNull(eventPattern, "eventPattern is required");
            this.archiveName = archiveName;
            this.description = description;
            this.retention = retention;
        }

        @Override
        public final software.amazon.awscdk.services.events.IEventBus getSourceEventBus() {
            return this.sourceEventBus;
        }

        @Override
        public final software.amazon.awscdk.services.events.EventPattern getEventPattern() {
            return this.eventPattern;
        }

        @Override
        public final java.lang.String getArchiveName() {
            return this.archiveName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getRetention() {
            return this.retention;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sourceEventBus", om.valueToTree(this.getSourceEventBus()));
            data.set("eventPattern", om.valueToTree(this.getEventPattern()));
            if (this.getArchiveName() != null) {
                data.set("archiveName", om.valueToTree(this.getArchiveName()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getRetention() != null) {
                data.set("retention", om.valueToTree(this.getRetention()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-events.ArchiveProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ArchiveProps.Jsii$Proxy that = (ArchiveProps.Jsii$Proxy) o;

            if (!sourceEventBus.equals(that.sourceEventBus)) return false;
            if (!eventPattern.equals(that.eventPattern)) return false;
            if (this.archiveName != null ? !this.archiveName.equals(that.archiveName) : that.archiveName != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.retention != null ? this.retention.equals(that.retention) : that.retention == null;
        }

        @Override
        public final int hashCode() {
            int result = this.sourceEventBus.hashCode();
            result = 31 * result + (this.eventPattern.hashCode());
            result = 31 * result + (this.archiveName != null ? this.archiveName.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.retention != null ? this.retention.hashCode() : 0);
            return result;
        }
    }
}
