package software.amazon.awscdk.services.events;

/**
 * Define an EventBridge EventBus.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2021-01-12T21:07:50.219Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.$Module.class, fqn = "@aws-cdk/aws-events.EventBus")
public class EventBus extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.events.IEventBus {

    protected EventBus(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EventBus(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EventBus(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.EventBusProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EventBus(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing event bus resource.
     * <p>
     * @param scope Parent construct. This parameter is required.
     * @param id Construct ID. This parameter is required.
     * @param eventBusArn ARN of imported event bus. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IEventBus fromEventBusArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String eventBusArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.EventBus.class, "fromEventBusArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.IEventBus.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(eventBusArn, "eventBusArn is required") });
    }

    /**
     * Import an existing event bus resource.
     * <p>
     * @param scope Parent construct. This parameter is required.
     * @param id Construct ID. This parameter is required.
     * @param attrs Imported event bus properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IEventBus fromEventBusAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.EventBusAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.EventBus.class, "fromEventBusAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.IEventBus.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Permits an IAM Principal to send custom events to EventBridge so that they can be matched to rules.
     * <p>
     * @param grantee The principal (no-op if undefined). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPutEvents(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.EventBus.class, "grantPutEvents", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * The ARN of the event bus, such as: arn:aws:events:us-east-2:123456789012:event-bus/aws.partner/PartnerName/acct1/repo1.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEventBusArn() {
        return software.amazon.jsii.Kernel.get(this, "eventBusArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The physical ID of this event bus resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEventBusName() {
        return software.amazon.jsii.Kernel.get(this, "eventBusName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The policy for the event bus in JSON form.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEventBusPolicy() {
        return software.amazon.jsii.Kernel.get(this, "eventBusPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the partner event source.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEventSourceName() {
        return software.amazon.jsii.Kernel.get(this, "eventSourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.EventBus}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.EventBus> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.events.EventBusProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The name of the event bus you are creating Note: If 'eventSourceName' is passed in, you cannot set this.
         * <p>
         * Default: - automatically generated name
         * <p>
         * @return {@code this}
         * @param eventBusName The name of the event bus you are creating Note: If 'eventSourceName' is passed in, you cannot set this. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBusName(final java.lang.String eventBusName) {
            this.props().eventBusName(eventBusName);
            return this;
        }

        /**
         * The partner event source to associate with this event bus resource Note: If 'eventBusName' is passed in, you cannot set this.
         * <p>
         * Default: - no partner event source
         * <p>
         * @return {@code this}
         * @param eventSourceName The partner event source to associate with this event bus resource Note: If 'eventBusName' is passed in, you cannot set this. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSourceName(final java.lang.String eventSourceName) {
            this.props().eventSourceName(eventSourceName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.events.EventBus}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.events.EventBus build() {
            return new software.amazon.awscdk.services.events.EventBus(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.events.EventBusProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.events.EventBusProps.Builder();
            }
            return this.props;
        }
    }
}
