package software.amazon.awscdk.services.events;

/**
 * Events in Amazon CloudWatch Events are represented as JSON objects. For more information about JSON objects, see RFC 7159.
 * <p>
 * Rules use event patterns to select events and route them to targets. A
 * pattern either matches an event or it doesn't. Event patterns are represented
 * as JSON objects with a structure that is similar to that of events, for
 * example:
 * <p>
 * It is important to remember the following about event pattern matching:
 * <p>
 * <ul>
 * <li>For a pattern to match an event, the event must contain all the field names
 * listed in the pattern. The field names must appear in the event with the
 * same nesting structure.</li>
 * <li>Other fields of the event not mentioned in the pattern are ignored;
 * effectively, there is a <code>"*": "*"</code> wildcard for fields not mentioned.</li>
 * <li>The matching is exact (character-by-character), without case-folding or any
 * other string normalization.</li>
 * <li>The values being matched follow JSON rules: Strings enclosed in quotes,
 * numbers, and the unquoted keywords true, false, and null.</li>
 * <li>Number matching is at the string representation level. For example, 300,
 * 300.0, and 3.0e2 are not considered equal.</li>
 * </ul>
 * <p>
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-28T21:12:16.554Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.$Module.class, fqn = "@aws-cdk/aws-events.EventPattern")
@software.amazon.jsii.Jsii.Proxy(EventPattern.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EventPattern extends software.amazon.jsii.JsiiSerializable {

    /**
     * The 12-digit number identifying an AWS account.
     * <p>
     * Default: - No filtering on account
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAccount() {
        return null;
    }

    /**
     * A JSON object, whose content is at the discretion of the service originating the event.
     * <p>
     * Default: - No filtering on detail
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getDetail() {
        return null;
    }

    /**
     * Identifies, in combination with the source field, the fields and values that appear in the detail field.
     * <p>
     * Represents the "detail-type" event field.
     * <p>
     * Default: - No filtering on detail type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDetailType() {
        return null;
    }

    /**
     * A unique value is generated for every event.
     * <p>
     * This can be helpful in
     * tracing events as they move through rules to targets, and are processed.
     * <p>
     * Default: - No filtering on id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getId() {
        return null;
    }

    /**
     * Identifies the AWS region where the event originated.
     * <p>
     * Default: - No filtering on region
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRegion() {
        return null;
    }

    /**
     * This JSON array contains ARNs that identify resources that are involved in the event.
     * <p>
     * Inclusion of these ARNs is at the discretion of the
     * service.
     * <p>
     * For example, Amazon EC2 instance state-changes include Amazon EC2
     * instance ARNs, Auto Scaling events include ARNs for both instances and
     * Auto Scaling groups, but API calls with AWS CloudTrail do not include
     * resource ARNs.
     * <p>
     * Default: - No filtering on resource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResources() {
        return null;
    }

    /**
     * Identifies the service that sourced the event.
     * <p>
     * All events sourced from
     * within AWS begin with "aws." Customer-generated events can have any value
     * here, as long as it doesn't begin with "aws." We recommend the use of
     * Java package-name style reverse domain-name strings.
     * <p>
     * To find the correct value for source for an AWS service, see the table in
     * AWS Service Namespaces. For example, the source value for Amazon
     * CloudFront is aws.cloudfront.
     * <p>
     * Default: - No filtering on source
     * <p>
     * @see http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSource() {
        return null;
    }

    /**
     * The event timestamp, which can be specified by the service originating the event.
     * <p>
     * If the event spans a time interval, the service might choose
     * to report the start time, so this value can be noticeably before the time
     * the event is actually received.
     * <p>
     * Default: - No filtering on time
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTime() {
        return null;
    }

    /**
     * By default, this is set to 0 (zero) in all events.
     * <p>
     * Default: - No filtering on version
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EventPattern}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EventPattern}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EventPattern> {
        private java.util.List<java.lang.String> account;
        private java.util.Map<java.lang.String, java.lang.Object> detail;
        private java.util.List<java.lang.String> detailType;
        private java.util.List<java.lang.String> id;
        private java.util.List<java.lang.String> region;
        private java.util.List<java.lang.String> resources;
        private java.util.List<java.lang.String> source;
        private java.util.List<java.lang.String> time;
        private java.util.List<java.lang.String> version;

        /**
         * Sets the value of {@link EventPattern#getAccount}
         * @param account The 12-digit number identifying an AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(java.util.List<java.lang.String> account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link EventPattern#getDetail}
         * @param detail A JSON object, whose content is at the discretion of the service originating the event.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detail(java.util.Map<java.lang.String, java.lang.Object> detail) {
            this.detail = detail;
            return this;
        }

        /**
         * Sets the value of {@link EventPattern#getDetailType}
         * @param detailType Identifies, in combination with the source field, the fields and values that appear in the detail field.
         *                   Represents the "detail-type" event field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detailType(java.util.List<java.lang.String> detailType) {
            this.detailType = detailType;
            return this;
        }

        /**
         * Sets the value of {@link EventPattern#getId}
         * @param id A unique value is generated for every event.
         *           This can be helpful in
         *           tracing events as they move through rules to targets, and are processed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.util.List<java.lang.String> id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link EventPattern#getRegion}
         * @param region Identifies the AWS region where the event originated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.util.List<java.lang.String> region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link EventPattern#getResources}
         * @param resources This JSON array contains ARNs that identify resources that are involved in the event.
         *                  Inclusion of these ARNs is at the discretion of the
         *                  service.
         *                  <p>
         *                  For example, Amazon EC2 instance state-changes include Amazon EC2
         *                  instance ARNs, Auto Scaling events include ARNs for both instances and
         *                  Auto Scaling groups, but API calls with AWS CloudTrail do not include
         *                  resource ARNs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(java.util.List<java.lang.String> resources) {
            this.resources = resources;
            return this;
        }

        /**
         * Sets the value of {@link EventPattern#getSource}
         * @param source Identifies the service that sourced the event.
         *               All events sourced from
         *               within AWS begin with "aws." Customer-generated events can have any value
         *               here, as long as it doesn't begin with "aws." We recommend the use of
         *               Java package-name style reverse domain-name strings.
         *               <p>
         *               To find the correct value for source for an AWS service, see the table in
         *               AWS Service Namespaces. For example, the source value for Amazon
         *               CloudFront is aws.cloudfront.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(java.util.List<java.lang.String> source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link EventPattern#getTime}
         * @param time The event timestamp, which can be specified by the service originating the event.
         *             If the event spans a time interval, the service might choose
         *             to report the start time, so this value can be noticeably before the time
         *             the event is actually received.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder time(java.util.List<java.lang.String> time) {
            this.time = time;
            return this;
        }

        /**
         * Sets the value of {@link EventPattern#getVersion}
         * @param version By default, this is set to 0 (zero) in all events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.util.List<java.lang.String> version) {
            this.version = version;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventPattern}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EventPattern build() {
            return new Jsii$Proxy(account, detail, detailType, id, region, resources, source, time, version);
        }
    }

    /**
     * An implementation for {@link EventPattern}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventPattern {
        private final java.util.List<java.lang.String> account;
        private final java.util.Map<java.lang.String, java.lang.Object> detail;
        private final java.util.List<java.lang.String> detailType;
        private final java.util.List<java.lang.String> id;
        private final java.util.List<java.lang.String> region;
        private final java.util.List<java.lang.String> resources;
        private final java.util.List<java.lang.String> source;
        private final java.util.List<java.lang.String> time;
        private final java.util.List<java.lang.String> version;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.account = this.jsiiGet("account", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.detail = this.jsiiGet("detail", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.detailType = this.jsiiGet("detailType", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.id = this.jsiiGet("id", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.region = this.jsiiGet("region", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.resources = this.jsiiGet("resources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.source = this.jsiiGet("source", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.time = this.jsiiGet("time", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.version = this.jsiiGet("version", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<java.lang.String> account, final java.util.Map<java.lang.String, java.lang.Object> detail, final java.util.List<java.lang.String> detailType, final java.util.List<java.lang.String> id, final java.util.List<java.lang.String> region, final java.util.List<java.lang.String> resources, final java.util.List<java.lang.String> source, final java.util.List<java.lang.String> time, final java.util.List<java.lang.String> version) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.account = account;
            this.detail = detail;
            this.detailType = detailType;
            this.id = id;
            this.region = region;
            this.resources = resources;
            this.source = source;
            this.time = time;
            this.version = version;
        }

        @Override
        public java.util.List<java.lang.String> getAccount() {
            return this.account;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.Object> getDetail() {
            return this.detail;
        }

        @Override
        public java.util.List<java.lang.String> getDetailType() {
            return this.detailType;
        }

        @Override
        public java.util.List<java.lang.String> getId() {
            return this.id;
        }

        @Override
        public java.util.List<java.lang.String> getRegion() {
            return this.region;
        }

        @Override
        public java.util.List<java.lang.String> getResources() {
            return this.resources;
        }

        @Override
        public java.util.List<java.lang.String> getSource() {
            return this.source;
        }

        @Override
        public java.util.List<java.lang.String> getTime() {
            return this.time;
        }

        @Override
        public java.util.List<java.lang.String> getVersion() {
            return this.version;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccount() != null) {
                data.set("account", om.valueToTree(this.getAccount()));
            }
            if (this.getDetail() != null) {
                data.set("detail", om.valueToTree(this.getDetail()));
            }
            if (this.getDetailType() != null) {
                data.set("detailType", om.valueToTree(this.getDetailType()));
            }
            if (this.getId() != null) {
                data.set("id", om.valueToTree(this.getId()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getResources() != null) {
                data.set("resources", om.valueToTree(this.getResources()));
            }
            if (this.getSource() != null) {
                data.set("source", om.valueToTree(this.getSource()));
            }
            if (this.getTime() != null) {
                data.set("time", om.valueToTree(this.getTime()));
            }
            if (this.getVersion() != null) {
                data.set("version", om.valueToTree(this.getVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-events.EventPattern"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EventPattern.Jsii$Proxy that = (EventPattern.Jsii$Proxy) o;

            if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
            if (this.detail != null ? !this.detail.equals(that.detail) : that.detail != null) return false;
            if (this.detailType != null ? !this.detailType.equals(that.detailType) : that.detailType != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) return false;
            if (this.source != null ? !this.source.equals(that.source) : that.source != null) return false;
            if (this.time != null ? !this.time.equals(that.time) : that.time != null) return false;
            return this.version != null ? this.version.equals(that.version) : that.version == null;
        }

        @Override
        public int hashCode() {
            int result = this.account != null ? this.account.hashCode() : 0;
            result = 31 * result + (this.detail != null ? this.detail.hashCode() : 0);
            result = 31 * result + (this.detailType != null ? this.detailType.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
            result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
            result = 31 * result + (this.time != null ? this.time.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }
    }
}
