/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.events.;
import software.amazon.awscdk.services.events.CfnRule;
import software.amazon.awscdk.services.events.CfnRuleProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-events.CfnRule")
public class CfnRule
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnRule.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnRule(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRule(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnRule(@NotNull Construct scope, @NotNull String id, @Nullable CfnRuleProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnRule(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)this.jsiiGet("attrArn", String.class);
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getEventPattern() {
        return this.jsiiGet("eventPattern", Object.class);
    }

    public void setEventPattern(@NotNull Object value) {
        this.jsiiSet("eventPattern", Objects.requireNonNull(value, "eventPattern is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(@Nullable String value) {
        this.jsiiSet("description", value);
    }

    @Nullable
    public String getEventBusName() {
        return (String)this.jsiiGet("eventBusName", String.class);
    }

    public void setEventBusName(@Nullable String value) {
        this.jsiiSet("eventBusName", value);
    }

    @Nullable
    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public void setName(@Nullable String value) {
        this.jsiiSet("name", value);
    }

    @Nullable
    public String getRoleArn() {
        return (String)this.jsiiGet("roleArn", String.class);
    }

    public void setRoleArn(@Nullable String value) {
        this.jsiiSet("roleArn", value);
    }

    @Nullable
    public String getScheduleExpression() {
        return (String)this.jsiiGet("scheduleExpression", String.class);
    }

    public void setScheduleExpression(@Nullable String value) {
        this.jsiiSet("scheduleExpression", value);
    }

    @Nullable
    public String getState() {
        return (String)this.jsiiGet("state", String.class);
    }

    public void setState(@Nullable String value) {
        this.jsiiSet("state", value);
    }

    @Nullable
    public Object getTargets() {
        return this.jsiiGet("targets", Object.class);
    }

    public void setTargets(@Nullable IResolvable value) {
        this.jsiiSet("targets", value);
    }

    public void setTargets(@Nullable List<Object> value) {
        this.jsiiSet("targets", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private CfnRuleProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder eventBusName(String eventBusName) {
            this.props().eventBusName(eventBusName);
            return this;
        }

        public Builder eventPattern(Object eventPattern) {
            this.props().eventPattern(eventPattern);
            return this;
        }

        public Builder name(String name) {
            this.props().name(name);
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.props().roleArn(roleArn);
            return this;
        }

        public Builder scheduleExpression(String scheduleExpression) {
            this.props().scheduleExpression(scheduleExpression);
            return this;
        }

        public Builder state(String state) {
            this.props().state(state);
            return this;
        }

        public Builder targets(IResolvable targets) {
            this.props().targets(targets);
            return this;
        }

        public Builder targets(List<Object> targets) {
            this.props().targets(targets);
            return this;
        }

        public CfnRule build() {
            return new CfnRule(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnRuleProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnRuleProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-events.CfnRule.TargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TargetProperty
    extends JsiiSerializable {
        @NotNull
        public String getArn();

        @NotNull
        public String getId();

        @Nullable
        default public Object getBatchParameters() {
            return null;
        }

        @Nullable
        default public Object getEcsParameters() {
            return null;
        }

        @Nullable
        default public String getInput() {
            return null;
        }

        @Nullable
        default public String getInputPath() {
            return null;
        }

        @Nullable
        default public Object getInputTransformer() {
            return null;
        }

        @Nullable
        default public Object getKinesisParameters() {
            return null;
        }

        @Nullable
        default public String getRoleArn() {
            return null;
        }

        @Nullable
        default public Object getRunCommandParameters() {
            return null;
        }

        @Nullable
        default public Object getSqsParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String arn;
            private String id;
            private Object batchParameters;
            private Object ecsParameters;
            private String input;
            private String inputPath;
            private Object inputTransformer;
            private Object kinesisParameters;
            private String roleArn;
            private Object runCommandParameters;
            private Object sqsParameters;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder batchParameters(IResolvable batchParameters) {
                this.batchParameters = batchParameters;
                return this;
            }

            public Builder batchParameters(BatchParametersProperty batchParameters) {
                this.batchParameters = batchParameters;
                return this;
            }

            public Builder ecsParameters(IResolvable ecsParameters) {
                this.ecsParameters = ecsParameters;
                return this;
            }

            public Builder ecsParameters(EcsParametersProperty ecsParameters) {
                this.ecsParameters = ecsParameters;
                return this;
            }

            public Builder input(String input) {
                this.input = input;
                return this;
            }

            public Builder inputPath(String inputPath) {
                this.inputPath = inputPath;
                return this;
            }

            public Builder inputTransformer(IResolvable inputTransformer) {
                this.inputTransformer = inputTransformer;
                return this;
            }

            public Builder inputTransformer(InputTransformerProperty inputTransformer) {
                this.inputTransformer = inputTransformer;
                return this;
            }

            public Builder kinesisParameters(IResolvable kinesisParameters) {
                this.kinesisParameters = kinesisParameters;
                return this;
            }

            public Builder kinesisParameters(KinesisParametersProperty kinesisParameters) {
                this.kinesisParameters = kinesisParameters;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder runCommandParameters(IResolvable runCommandParameters) {
                this.runCommandParameters = runCommandParameters;
                return this;
            }

            public Builder runCommandParameters(RunCommandParametersProperty runCommandParameters) {
                this.runCommandParameters = runCommandParameters;
                return this;
            }

            public Builder sqsParameters(IResolvable sqsParameters) {
                this.sqsParameters = sqsParameters;
                return this;
            }

            public Builder sqsParameters(SqsParametersProperty sqsParameters) {
                this.sqsParameters = sqsParameters;
                return this;
            }

            public TargetProperty build() {
                return new Jsii.Proxy(this.arn, this.id, this.batchParameters, this.ecsParameters, this.input, this.inputPath, this.inputTransformer, this.kinesisParameters, this.roleArn, this.runCommandParameters, this.sqsParameters, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-events.CfnRule.SqsParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SqsParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getMessageGroupId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String messageGroupId;

            public Builder messageGroupId(String messageGroupId) {
                this.messageGroupId = messageGroupId;
                return this;
            }

            public SqsParametersProperty build() {
                return new Jsii.Proxy(this.messageGroupId, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-events.CfnRule.RunCommandTargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RunCommandTargetProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public List<String> getValues();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String key;
            private List<String> values;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public RunCommandTargetProperty build() {
                return new Jsii.Proxy(this.key, this.values, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-events.CfnRule.RunCommandParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RunCommandParametersProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRunCommandTargets();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object runCommandTargets;

            public Builder runCommandTargets(IResolvable runCommandTargets) {
                this.runCommandTargets = runCommandTargets;
                return this;
            }

            public Builder runCommandTargets(List<Object> runCommandTargets) {
                this.runCommandTargets = runCommandTargets;
                return this;
            }

            public RunCommandParametersProperty build() {
                return new Jsii.Proxy(this.runCommandTargets, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-events.CfnRule.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAwsVpcConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object awsVpcConfiguration;

            public Builder awsVpcConfiguration(IResolvable awsVpcConfiguration) {
                this.awsVpcConfiguration = awsVpcConfiguration;
                return this;
            }

            public Builder awsVpcConfiguration(AwsVpcConfigurationProperty awsVpcConfiguration) {
                this.awsVpcConfiguration = awsVpcConfiguration;
                return this;
            }

            public NetworkConfigurationProperty build() {
                return new Jsii.Proxy(this.awsVpcConfiguration, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-events.CfnRule.KinesisParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KinesisParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getPartitionKeyPath();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String partitionKeyPath;

            public Builder partitionKeyPath(String partitionKeyPath) {
                this.partitionKeyPath = partitionKeyPath;
                return this;
            }

            public KinesisParametersProperty build() {
                return new Jsii.Proxy(this.partitionKeyPath, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-events.CfnRule.InputTransformerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputTransformerProperty
    extends JsiiSerializable {
        @NotNull
        public String getInputTemplate();

        @Nullable
        default public Object getInputPathsMap() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String inputTemplate;
            private Object inputPathsMap;

            public Builder inputTemplate(String inputTemplate) {
                this.inputTemplate = inputTemplate;
                return this;
            }

            public Builder inputPathsMap(IResolvable inputPathsMap) {
                this.inputPathsMap = inputPathsMap;
                return this;
            }

            public Builder inputPathsMap(Map<String, String> inputPathsMap) {
                this.inputPathsMap = inputPathsMap;
                return this;
            }

            public InputTransformerProperty build() {
                return new Jsii.Proxy(this.inputTemplate, this.inputPathsMap, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-events.CfnRule.EcsParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EcsParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getTaskDefinitionArn();

        @Nullable
        default public String getGroup() {
            return null;
        }

        @Nullable
        default public String getLaunchType() {
            return null;
        }

        @Nullable
        default public Object getNetworkConfiguration() {
            return null;
        }

        @Nullable
        default public String getPlatformVersion() {
            return null;
        }

        @Nullable
        default public Number getTaskCount() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String taskDefinitionArn;
            private String group;
            private String launchType;
            private Object networkConfiguration;
            private String platformVersion;
            private Number taskCount;

            public Builder taskDefinitionArn(String taskDefinitionArn) {
                this.taskDefinitionArn = taskDefinitionArn;
                return this;
            }

            public Builder group(String group) {
                this.group = group;
                return this;
            }

            public Builder launchType(String launchType) {
                this.launchType = launchType;
                return this;
            }

            public Builder networkConfiguration(IResolvable networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            public Builder networkConfiguration(NetworkConfigurationProperty networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            public Builder platformVersion(String platformVersion) {
                this.platformVersion = platformVersion;
                return this;
            }

            public Builder taskCount(Number taskCount) {
                this.taskCount = taskCount;
                return this;
            }

            public EcsParametersProperty build() {
                return new Jsii.Proxy(this.taskDefinitionArn, this.group, this.launchType, this.networkConfiguration, this.platformVersion, this.taskCount, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-events.CfnRule.BatchRetryStrategyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BatchRetryStrategyProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getAttempts() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Number attempts;

            public Builder attempts(Number attempts) {
                this.attempts = attempts;
                return this;
            }

            public BatchRetryStrategyProperty build() {
                return new Jsii.Proxy(this.attempts, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-events.CfnRule.BatchParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BatchParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getJobDefinition();

        @NotNull
        public String getJobName();

        @Nullable
        default public Object getArrayProperties() {
            return null;
        }

        @Nullable
        default public Object getRetryStrategy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String jobDefinition;
            private String jobName;
            private Object arrayProperties;
            private Object retryStrategy;

            public Builder jobDefinition(String jobDefinition) {
                this.jobDefinition = jobDefinition;
                return this;
            }

            public Builder jobName(String jobName) {
                this.jobName = jobName;
                return this;
            }

            public Builder arrayProperties(IResolvable arrayProperties) {
                this.arrayProperties = arrayProperties;
                return this;
            }

            public Builder arrayProperties(BatchArrayPropertiesProperty arrayProperties) {
                this.arrayProperties = arrayProperties;
                return this;
            }

            public Builder retryStrategy(IResolvable retryStrategy) {
                this.retryStrategy = retryStrategy;
                return this;
            }

            public Builder retryStrategy(BatchRetryStrategyProperty retryStrategy) {
                this.retryStrategy = retryStrategy;
                return this;
            }

            public BatchParametersProperty build() {
                return new Jsii.Proxy(this.jobDefinition, this.jobName, this.arrayProperties, this.retryStrategy, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-events.CfnRule.BatchArrayPropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BatchArrayPropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getSize() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Number size;

            public Builder size(Number size) {
                this.size = size;
                return this;
            }

            public BatchArrayPropertiesProperty build() {
                return new Jsii.Proxy(this.size, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-events.CfnRule.AwsVpcConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AwsVpcConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSubnets();

        @Nullable
        default public String getAssignPublicIp() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroups() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<String> subnets;
            private String assignPublicIp;
            private List<String> securityGroups;

            public Builder subnets(List<String> subnets) {
                this.subnets = subnets;
                return this;
            }

            public Builder assignPublicIp(String assignPublicIp) {
                this.assignPublicIp = assignPublicIp;
                return this;
            }

            public Builder securityGroups(List<String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            public AwsVpcConfigurationProperty build() {
                return new Jsii.Proxy(this.subnets, this.assignPublicIp, this.securityGroups, null);
            }
        }
    }
}

