package software.amazon.awscdk.services.events;

/**
 * Properties for an event rule target.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.1 (build 9ff44cb)", date = "2020-01-16T18:33:58.798Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.$Module.class, fqn = "@aws-cdk/aws-events.RuleTargetConfig")
@software.amazon.jsii.Jsii.Proxy(RuleTargetConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RuleTargetConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getArn();

    /**
     * A unique, user-defined identifier for the target.
     * <p>
     * Acceptable values
     * include alphanumeric characters, periods (.), hyphens (-), and
     * underscores (_).
     * <p>
     * @deprecated prefer auto-generated id by specifying an empty string
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    java.lang.String getId();

    /**
     * The Amazon ECS task definition and task count to use, if the event target is an Amazon ECS task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty getEcsParameters() {
        return null;
    }

    /**
     * What input to send to the event target.
     * <p>
     * Default: the entire event
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.events.RuleTargetInput getInput() {
        return null;
    }

    /**
     * Settings that control shard assignment, when the target is a Kinesis stream.
     * <p>
     * If you don't include this parameter, eventId is used as the
     * partition key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty getKinesisParameters() {
        return null;
    }

    /**
     * Role to use to invoke this event target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * Parameters used when the rule invokes Amazon EC2 Systems Manager Run Command.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty getRunCommandParameters() {
        return null;
    }

    /**
     * Parameters used when the FIFO sqs queue is used an event target by the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty getSqsParameters() {
        return null;
    }

    /**
     * The resource that is backing this target.
     * <p>
     * This is the resource that will actually have some action performed on it when used as a target
     * (for example, start a build for a CodeBuild project).
     * We need it to determine whether the rule belongs to a different account than the target -
     * if so, we generate a more complex setup,
     * including an additional stack containing the EventBusPolicy.
     * <p>
     * Default: the target is not backed by any resource
     * <p>
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEvents-CrossAccountEventDelivery.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.core.IConstruct getTargetResource() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RuleTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RuleTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String arn;
        private java.lang.String id;
        private software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty ecsParameters;
        private software.amazon.awscdk.services.events.RuleTargetInput input;
        private software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty kinesisParameters;
        private software.amazon.awscdk.services.iam.IRole role;
        private software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty runCommandParameters;
        private software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty sqsParameters;
        private software.amazon.awscdk.core.IConstruct targetResource;

        /**
         * Sets the value of {@link RuleTargetConfig#getArn}
         * @param arn The Amazon Resource Name (ARN) of the target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder arn(java.lang.String arn) {
            this.arn = arn;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getId}
         * @param id A unique, user-defined identifier for the target. This parameter is required.
         *           Acceptable values
         *           include alphanumeric characters, periods (.), hyphens (-), and
         *           underscores (_).
         * @return {@code this}
         * @deprecated prefer auto-generated id by specifying an empty string
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getEcsParameters}
         * @param ecsParameters The Amazon ECS task definition and task count to use, if the event target is an Amazon ECS task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecsParameters(software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty ecsParameters) {
            this.ecsParameters = ecsParameters;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getInput}
         * @param input What input to send to the event target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(software.amazon.awscdk.services.events.RuleTargetInput input) {
            this.input = input;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getKinesisParameters}
         * @param kinesisParameters Settings that control shard assignment, when the target is a Kinesis stream.
         *                          If you don't include this parameter, eventId is used as the
         *                          partition key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisParameters(software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty kinesisParameters) {
            this.kinesisParameters = kinesisParameters;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getRole}
         * @param role Role to use to invoke this event target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getRunCommandParameters}
         * @param runCommandParameters Parameters used when the rule invokes Amazon EC2 Systems Manager Run Command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runCommandParameters(software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty runCommandParameters) {
            this.runCommandParameters = runCommandParameters;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getSqsParameters}
         * @param sqsParameters Parameters used when the FIFO sqs queue is used an event target by the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sqsParameters(software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty sqsParameters) {
            this.sqsParameters = sqsParameters;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getTargetResource}
         * @param targetResource The resource that is backing this target.
         *                       This is the resource that will actually have some action performed on it when used as a target
         *                       (for example, start a build for a CodeBuild project).
         *                       We need it to determine whether the rule belongs to a different account than the target -
         *                       if so, we generate a more complex setup,
         *                       including an additional stack containing the EventBusPolicy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetResource(software.amazon.awscdk.core.IConstruct targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RuleTargetConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public RuleTargetConfig build() {
            return new Jsii$Proxy(arn, id, ecsParameters, input, kinesisParameters, role, runCommandParameters, sqsParameters, targetResource);
        }
    }

    /**
     * An implementation for {@link RuleTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleTargetConfig {
        private final java.lang.String arn;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty ecsParameters;
        private final software.amazon.awscdk.services.events.RuleTargetInput input;
        private final software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty kinesisParameters;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty runCommandParameters;
        private final software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty sqsParameters;
        private final software.amazon.awscdk.core.IConstruct targetResource;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.arn = this.jsiiGet("arn", java.lang.String.class);
            this.id = this.jsiiGet("id", java.lang.String.class);
            this.ecsParameters = this.jsiiGet("ecsParameters", software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty.class);
            this.input = this.jsiiGet("input", software.amazon.awscdk.services.events.RuleTargetInput.class);
            this.kinesisParameters = this.jsiiGet("kinesisParameters", software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty.class);
            this.role = this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
            this.runCommandParameters = this.jsiiGet("runCommandParameters", software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty.class);
            this.sqsParameters = this.jsiiGet("sqsParameters", software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty.class);
            this.targetResource = this.jsiiGet("targetResource", software.amazon.awscdk.core.IConstruct.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String arn, final java.lang.String id, final software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty ecsParameters, final software.amazon.awscdk.services.events.RuleTargetInput input, final software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty kinesisParameters, final software.amazon.awscdk.services.iam.IRole role, final software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty runCommandParameters, final software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty sqsParameters, final software.amazon.awscdk.core.IConstruct targetResource) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.arn = java.util.Objects.requireNonNull(arn, "arn is required");
            this.id = java.util.Objects.requireNonNull(id, "id is required");
            this.ecsParameters = ecsParameters;
            this.input = input;
            this.kinesisParameters = kinesisParameters;
            this.role = role;
            this.runCommandParameters = runCommandParameters;
            this.sqsParameters = sqsParameters;
            this.targetResource = targetResource;
        }

        @Override
        public java.lang.String getArn() {
            return this.arn;
        }

        @Override
        public java.lang.String getId() {
            return this.id;
        }

        @Override
        public software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty getEcsParameters() {
            return this.ecsParameters;
        }

        @Override
        public software.amazon.awscdk.services.events.RuleTargetInput getInput() {
            return this.input;
        }

        @Override
        public software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty getKinesisParameters() {
            return this.kinesisParameters;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty getRunCommandParameters() {
            return this.runCommandParameters;
        }

        @Override
        public software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty getSqsParameters() {
            return this.sqsParameters;
        }

        @Override
        public software.amazon.awscdk.core.IConstruct getTargetResource() {
            return this.targetResource;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("arn", om.valueToTree(this.getArn()));
            data.set("id", om.valueToTree(this.getId()));
            if (this.getEcsParameters() != null) {
                data.set("ecsParameters", om.valueToTree(this.getEcsParameters()));
            }
            if (this.getInput() != null) {
                data.set("input", om.valueToTree(this.getInput()));
            }
            if (this.getKinesisParameters() != null) {
                data.set("kinesisParameters", om.valueToTree(this.getKinesisParameters()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getRunCommandParameters() != null) {
                data.set("runCommandParameters", om.valueToTree(this.getRunCommandParameters()));
            }
            if (this.getSqsParameters() != null) {
                data.set("sqsParameters", om.valueToTree(this.getSqsParameters()));
            }
            if (this.getTargetResource() != null) {
                data.set("targetResource", om.valueToTree(this.getTargetResource()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-events.RuleTargetConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RuleTargetConfig.Jsii$Proxy that = (RuleTargetConfig.Jsii$Proxy) o;

            if (!arn.equals(that.arn)) return false;
            if (!id.equals(that.id)) return false;
            if (this.ecsParameters != null ? !this.ecsParameters.equals(that.ecsParameters) : that.ecsParameters != null) return false;
            if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
            if (this.kinesisParameters != null ? !this.kinesisParameters.equals(that.kinesisParameters) : that.kinesisParameters != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.runCommandParameters != null ? !this.runCommandParameters.equals(that.runCommandParameters) : that.runCommandParameters != null) return false;
            if (this.sqsParameters != null ? !this.sqsParameters.equals(that.sqsParameters) : that.sqsParameters != null) return false;
            return this.targetResource != null ? this.targetResource.equals(that.targetResource) : that.targetResource == null;
        }

        @Override
        public int hashCode() {
            int result = this.arn.hashCode();
            result = 31 * result + (this.id.hashCode());
            result = 31 * result + (this.ecsParameters != null ? this.ecsParameters.hashCode() : 0);
            result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
            result = 31 * result + (this.kinesisParameters != null ? this.kinesisParameters.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.runCommandParameters != null ? this.runCommandParameters.hashCode() : 0);
            result = 31 * result + (this.sqsParameters != null ? this.sqsParameters.hashCode() : 0);
            result = 31 * result + (this.targetResource != null ? this.targetResource.hashCode() : 0);
            return result;
        }
    }
}
