/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.events.$Module;
import software.amazon.awscdk.services.events.CfnConnection;
import software.amazon.awscdk.services.events.CfnConnectionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-events.CfnConnection")
public class CfnConnection
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnConnection.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnConnection(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConnection(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnConnection(@NotNull Construct scope, @NotNull String id, @NotNull CfnConnectionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrSecretArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrSecretArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getAuthorizationType() {
        return (String)Kernel.get((Object)((Object)this), (String)"authorizationType", (NativeType)NativeType.forClass(String.class));
    }

    public void setAuthorizationType(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"authorizationType", (Object)Objects.requireNonNull(value, "authorizationType is required"));
    }

    @NotNull
    public Object getAuthParameters() {
        return Kernel.get((Object)((Object)this), (String)"authParameters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAuthParameters(@NotNull IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"authParameters", (Object)Objects.requireNonNull(value, "authParameters is required"));
    }

    public void setAuthParameters(@NotNull AuthParametersProperty value) {
        Kernel.set((Object)((Object)this), (String)"authParameters", (Object)Objects.requireNonNull(value, "authParameters is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)((Object)this), (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"description", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)((Object)this), (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"name", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnConnection> {
        private final Construct scope;
        private final String id;
        private final CfnConnectionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnConnectionProps.Builder();
        }

        public Builder authorizationType(String authorizationType) {
            this.props.authorizationType(authorizationType);
            return this;
        }

        public Builder authParameters(IResolvable authParameters) {
            this.props.authParameters(authParameters);
            return this;
        }

        public Builder authParameters(AuthParametersProperty authParameters) {
            this.props.authParameters(authParameters);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public CfnConnection build() {
            return new CfnConnection(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-events.CfnConnection.ParameterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParameterProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        @Nullable
        default public Object getIsValueSecret() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ParameterProperty> {
            String key;
            String value;
            Object isValueSecret;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Builder isValueSecret(Boolean isValueSecret) {
                this.isValueSecret = isValueSecret;
                return this;
            }

            public Builder isValueSecret(IResolvable isValueSecret) {
                this.isValueSecret = isValueSecret;
                return this;
            }

            public ParameterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-events.CfnConnection.OAuthParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OAuthParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getAuthorizationEndpoint();

        @NotNull
        public Object getClientParameters();

        @NotNull
        public String getHttpMethod();

        @Nullable
        default public Object getOAuthHttpParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OAuthParametersProperty> {
            String authorizationEndpoint;
            Object clientParameters;
            String httpMethod;
            Object oAuthHttpParameters;

            public Builder authorizationEndpoint(String authorizationEndpoint) {
                this.authorizationEndpoint = authorizationEndpoint;
                return this;
            }

            public Builder clientParameters(IResolvable clientParameters) {
                this.clientParameters = clientParameters;
                return this;
            }

            public Builder clientParameters(ClientParametersProperty clientParameters) {
                this.clientParameters = clientParameters;
                return this;
            }

            public Builder httpMethod(String httpMethod) {
                this.httpMethod = httpMethod;
                return this;
            }

            public Builder oAuthHttpParameters(IResolvable oAuthHttpParameters) {
                this.oAuthHttpParameters = oAuthHttpParameters;
                return this;
            }

            public Builder oAuthHttpParameters(ConnectionHttpParametersProperty oAuthHttpParameters) {
                this.oAuthHttpParameters = oAuthHttpParameters;
                return this;
            }

            public OAuthParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-events.CfnConnection.ConnectionHttpParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConnectionHttpParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBodyParameters() {
            return null;
        }

        @Nullable
        default public Object getHeaderParameters() {
            return null;
        }

        @Nullable
        default public Object getQueryStringParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConnectionHttpParametersProperty> {
            Object bodyParameters;
            Object headerParameters;
            Object queryStringParameters;

            public Builder bodyParameters(IResolvable bodyParameters) {
                this.bodyParameters = bodyParameters;
                return this;
            }

            public Builder bodyParameters(List<? extends Object> bodyParameters) {
                this.bodyParameters = bodyParameters;
                return this;
            }

            public Builder headerParameters(IResolvable headerParameters) {
                this.headerParameters = headerParameters;
                return this;
            }

            public Builder headerParameters(List<? extends Object> headerParameters) {
                this.headerParameters = headerParameters;
                return this;
            }

            public Builder queryStringParameters(IResolvable queryStringParameters) {
                this.queryStringParameters = queryStringParameters;
                return this;
            }

            public Builder queryStringParameters(List<? extends Object> queryStringParameters) {
                this.queryStringParameters = queryStringParameters;
                return this;
            }

            public ConnectionHttpParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-events.CfnConnection.ClientParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClientParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getClientId();

        @NotNull
        public String getClientSecret();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClientParametersProperty> {
            String clientId;
            String clientSecret;

            public Builder clientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            public Builder clientSecret(String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            public ClientParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-events.CfnConnection.BasicAuthParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BasicAuthParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getPassword();

        @NotNull
        public String getUsername();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BasicAuthParametersProperty> {
            String password;
            String username;

            public Builder password(String password) {
                this.password = password;
                return this;
            }

            public Builder username(String username) {
                this.username = username;
                return this;
            }

            public BasicAuthParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-events.CfnConnection.AuthParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getApiKeyAuthParameters() {
            return null;
        }

        @Nullable
        default public Object getBasicAuthParameters() {
            return null;
        }

        @Nullable
        default public Object getInvocationHttpParameters() {
            return null;
        }

        @Nullable
        default public Object getOAuthParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuthParametersProperty> {
            Object apiKeyAuthParameters;
            Object basicAuthParameters;
            Object invocationHttpParameters;
            Object oAuthParameters;

            public Builder apiKeyAuthParameters(IResolvable apiKeyAuthParameters) {
                this.apiKeyAuthParameters = apiKeyAuthParameters;
                return this;
            }

            public Builder apiKeyAuthParameters(ApiKeyAuthParametersProperty apiKeyAuthParameters) {
                this.apiKeyAuthParameters = apiKeyAuthParameters;
                return this;
            }

            public Builder basicAuthParameters(IResolvable basicAuthParameters) {
                this.basicAuthParameters = basicAuthParameters;
                return this;
            }

            public Builder basicAuthParameters(BasicAuthParametersProperty basicAuthParameters) {
                this.basicAuthParameters = basicAuthParameters;
                return this;
            }

            public Builder invocationHttpParameters(IResolvable invocationHttpParameters) {
                this.invocationHttpParameters = invocationHttpParameters;
                return this;
            }

            public Builder invocationHttpParameters(ConnectionHttpParametersProperty invocationHttpParameters) {
                this.invocationHttpParameters = invocationHttpParameters;
                return this;
            }

            public Builder oAuthParameters(IResolvable oAuthParameters) {
                this.oAuthParameters = oAuthParameters;
                return this;
            }

            public Builder oAuthParameters(OAuthParametersProperty oAuthParameters) {
                this.oAuthParameters = oAuthParameters;
                return this;
            }

            public AuthParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-events.CfnConnection.ApiKeyAuthParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApiKeyAuthParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getApiKeyName();

        @NotNull
        public String getApiKeyValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ApiKeyAuthParametersProperty> {
            String apiKeyName;
            String apiKeyValue;

            public Builder apiKeyName(String apiKeyName) {
                this.apiKeyName = apiKeyName;
                return this;
            }

            public Builder apiKeyValue(String apiKeyValue) {
                this.apiKeyValue = apiKeyValue;
                return this;
            }

            public ApiKeyAuthParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

