package software.amazon.awscdk.services.events;

/**
 * Properties for defining a `CfnEventBusPolicy`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.*;
 * Object statement;
 * CfnEventBusPolicyProps cfnEventBusPolicyProps = CfnEventBusPolicyProps.builder()
 *         .statementId("statementId")
 *         // the properties below are optional
 *         .action("action")
 *         .condition(ConditionProperty.builder()
 *                 .key("key")
 *                 .type("type")
 *                 .value("value")
 *                 .build())
 *         .eventBusName("eventBusName")
 *         .principal("principal")
 *         .statement(statement)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:27.325Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.$Module.class, fqn = "@aws-cdk/aws-events.CfnEventBusPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnEventBusPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEventBusPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An identifier string for the external account that you are granting permissions to.
     * <p>
     * If you later want to revoke the permission for this external account, specify this <code>StatementId</code> when you run <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html">RemovePermission</a> .
     * <p>
     * <blockquote>
     * <p>
     * Each <code>StatementId</code> must be unique.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStatementId();

    /**
     * The action that you are enabling the other account to perform.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAction() {
        return null;
    }

    /**
     * This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as being a member of a certain AWS organization.
     * <p>
     * For more information about AWS Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is AWS Organizations</a> in the <em>AWS Organizations User Guide</em> .
     * <p>
     * If you specify <code>Condition</code> with an AWS organization ID, and specify "*" as the value for <code>Principal</code> , you grant permission to all the accounts in the named organization.
     * <p>
     * The <code>Condition</code> is a JSON string which must contain <code>Type</code> , <code>Key</code> , and <code>Value</code> fields.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCondition() {
        return null;
    }

    /**
     * The name of the event bus associated with the rule.
     * <p>
     * If you omit this, the default event bus is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEventBusName() {
        return null;
    }

    /**
     * The 12-digit AWS account ID that you are permitting to put events to your default event bus.
     * <p>
     * Specify "*" to permit any account to put events to your default event bus.
     * <p>
     * If you specify "*" without specifying <code>Condition</code> , avoid creating rules that may match undesirable events. To create more secure rules, make sure that the event pattern for each rule contains an <code>account</code> field with a specific account ID from which to receive events. Rules with an account field do not match any events sent from other accounts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrincipal() {
        return null;
    }

    /**
     * A JSON string that describes the permission policy statement.
     * <p>
     * You can include a <code>Policy</code> parameter in the request instead of using the <code>StatementId</code> , <code>Action</code> , <code>Principal</code> , or <code>Condition</code> parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStatement() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEventBusPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEventBusPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEventBusPolicyProps> {
        java.lang.String statementId;
        java.lang.String action;
        java.lang.Object condition;
        java.lang.String eventBusName;
        java.lang.String principal;
        java.lang.Object statement;

        /**
         * Sets the value of {@link CfnEventBusPolicyProps#getStatementId}
         * @param statementId An identifier string for the external account that you are granting permissions to. This parameter is required.
         *                    If you later want to revoke the permission for this external account, specify this <code>StatementId</code> when you run <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html">RemovePermission</a> .
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    Each <code>StatementId</code> must be unique.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statementId(java.lang.String statementId) {
            this.statementId = statementId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventBusPolicyProps#getAction}
         * @param action The action that you are enabling the other account to perform.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventBusPolicyProps#getCondition}
         * @param condition This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as being a member of a certain AWS organization.
         *                  For more information about AWS Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is AWS Organizations</a> in the <em>AWS Organizations User Guide</em> .
         *                  <p>
         *                  If you specify <code>Condition</code> with an AWS organization ID, and specify "*" as the value for <code>Principal</code> , you grant permission to all the accounts in the named organization.
         *                  <p>
         *                  The <code>Condition</code> is a JSON string which must contain <code>Type</code> , <code>Key</code> , and <code>Value</code> fields.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder condition(software.amazon.awscdk.core.IResolvable condition) {
            this.condition = condition;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventBusPolicyProps#getCondition}
         * @param condition This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as being a member of a certain AWS organization.
         *                  For more information about AWS Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is AWS Organizations</a> in the <em>AWS Organizations User Guide</em> .
         *                  <p>
         *                  If you specify <code>Condition</code> with an AWS organization ID, and specify "*" as the value for <code>Principal</code> , you grant permission to all the accounts in the named organization.
         *                  <p>
         *                  The <code>Condition</code> is a JSON string which must contain <code>Type</code> , <code>Key</code> , and <code>Value</code> fields.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder condition(software.amazon.awscdk.services.events.CfnEventBusPolicy.ConditionProperty condition) {
            this.condition = condition;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventBusPolicyProps#getEventBusName}
         * @param eventBusName The name of the event bus associated with the rule.
         *                     If you omit this, the default event bus is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBusName(java.lang.String eventBusName) {
            this.eventBusName = eventBusName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventBusPolicyProps#getPrincipal}
         * @param principal The 12-digit AWS account ID that you are permitting to put events to your default event bus.
         *                  Specify "*" to permit any account to put events to your default event bus.
         *                  <p>
         *                  If you specify "*" without specifying <code>Condition</code> , avoid creating rules that may match undesirable events. To create more secure rules, make sure that the event pattern for each rule contains an <code>account</code> field with a specific account ID from which to receive events. Rules with an account field do not match any events sent from other accounts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(java.lang.String principal) {
            this.principal = principal;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventBusPolicyProps#getStatement}
         * @param statement A JSON string that describes the permission policy statement.
         *                  You can include a <code>Policy</code> parameter in the request instead of using the <code>StatementId</code> , <code>Action</code> , <code>Principal</code> , or <code>Condition</code> parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statement(java.lang.Object statement) {
            this.statement = statement;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEventBusPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEventBusPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEventBusPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEventBusPolicyProps {
        private final java.lang.String statementId;
        private final java.lang.String action;
        private final java.lang.Object condition;
        private final java.lang.String eventBusName;
        private final java.lang.String principal;
        private final java.lang.Object statement;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.statementId = software.amazon.jsii.Kernel.get(this, "statementId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.eventBusName = software.amazon.jsii.Kernel.get(this, "eventBusName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.statement = software.amazon.jsii.Kernel.get(this, "statement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.statementId = java.util.Objects.requireNonNull(builder.statementId, "statementId is required");
            this.action = builder.action;
            this.condition = builder.condition;
            this.eventBusName = builder.eventBusName;
            this.principal = builder.principal;
            this.statement = builder.statement;
        }

        @Override
        public final java.lang.String getStatementId() {
            return this.statementId;
        }

        @Override
        public final java.lang.String getAction() {
            return this.action;
        }

        @Override
        public final java.lang.Object getCondition() {
            return this.condition;
        }

        @Override
        public final java.lang.String getEventBusName() {
            return this.eventBusName;
        }

        @Override
        public final java.lang.String getPrincipal() {
            return this.principal;
        }

        @Override
        public final java.lang.Object getStatement() {
            return this.statement;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("statementId", om.valueToTree(this.getStatementId()));
            if (this.getAction() != null) {
                data.set("action", om.valueToTree(this.getAction()));
            }
            if (this.getCondition() != null) {
                data.set("condition", om.valueToTree(this.getCondition()));
            }
            if (this.getEventBusName() != null) {
                data.set("eventBusName", om.valueToTree(this.getEventBusName()));
            }
            if (this.getPrincipal() != null) {
                data.set("principal", om.valueToTree(this.getPrincipal()));
            }
            if (this.getStatement() != null) {
                data.set("statement", om.valueToTree(this.getStatement()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-events.CfnEventBusPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEventBusPolicyProps.Jsii$Proxy that = (CfnEventBusPolicyProps.Jsii$Proxy) o;

            if (!statementId.equals(that.statementId)) return false;
            if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
            if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) return false;
            if (this.eventBusName != null ? !this.eventBusName.equals(that.eventBusName) : that.eventBusName != null) return false;
            if (this.principal != null ? !this.principal.equals(that.principal) : that.principal != null) return false;
            return this.statement != null ? this.statement.equals(that.statement) : that.statement == null;
        }

        @Override
        public final int hashCode() {
            int result = this.statementId.hashCode();
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
            result = 31 * result + (this.eventBusName != null ? this.eventBusName.hashCode() : 0);
            result = 31 * result + (this.principal != null ? this.principal.hashCode() : 0);
            result = 31 * result + (this.statement != null ? this.statement.hashCode() : 0);
            return result;
        }
    }
}
