package software.amazon.awscdk.services.events;

/**
 * Properties for defining a `AWS::Events::EventBusPolicy`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.*;
 * Object statement;
 * CfnEventBusPolicyProps cfnEventBusPolicyProps = CfnEventBusPolicyProps.builder()
 *         .statementId("statementId")
 *         // the properties below are optional
 *         .action("action")
 *         .condition(ConditionProperty.builder()
 *                 .key("key")
 *                 .type("type")
 *                 .value("value")
 *                 .build())
 *         .eventBusName("eventBusName")
 *         .principal("principal")
 *         .statement(statement)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-15T10:03:42.450Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.$Module.class, fqn = "@aws-cdk/aws-events.CfnEventBusPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnEventBusPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEventBusPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::Events::EventBusPolicy.Action`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAction() {
        return null;
    }

    /**
     * `AWS::Events::EventBusPolicy.Condition`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCondition() {
        return null;
    }

    /**
     * `AWS::Events::EventBusPolicy.EventBusName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEventBusName() {
        return null;
    }

    /**
     * `AWS::Events::EventBusPolicy.Principal`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrincipal() {
        return null;
    }

    /**
     * `AWS::Events::EventBusPolicy.Statement`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStatement() {
        return null;
    }

    /**
     * `AWS::Events::EventBusPolicy.StatementId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStatementId();

    /**
     * @return a {@link Builder} of {@link CfnEventBusPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEventBusPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEventBusPolicyProps> {
        java.lang.String action;
        java.lang.Object condition;
        java.lang.String eventBusName;
        java.lang.String principal;
        java.lang.Object statement;
        java.lang.String statementId;

        /**
         * Sets the value of {@link CfnEventBusPolicyProps#getAction}
         * @param action `AWS::Events::EventBusPolicy.Action`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventBusPolicyProps#getCondition}
         * @param condition `AWS::Events::EventBusPolicy.Condition`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder condition(software.amazon.awscdk.core.IResolvable condition) {
            this.condition = condition;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventBusPolicyProps#getCondition}
         * @param condition `AWS::Events::EventBusPolicy.Condition`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder condition(software.amazon.awscdk.services.events.CfnEventBusPolicy.ConditionProperty condition) {
            this.condition = condition;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventBusPolicyProps#getEventBusName}
         * @param eventBusName `AWS::Events::EventBusPolicy.EventBusName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBusName(java.lang.String eventBusName) {
            this.eventBusName = eventBusName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventBusPolicyProps#getPrincipal}
         * @param principal `AWS::Events::EventBusPolicy.Principal`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(java.lang.String principal) {
            this.principal = principal;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventBusPolicyProps#getStatement}
         * @param statement `AWS::Events::EventBusPolicy.Statement`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statement(java.lang.Object statement) {
            this.statement = statement;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventBusPolicyProps#getStatementId}
         * @param statementId `AWS::Events::EventBusPolicy.StatementId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statementId(java.lang.String statementId) {
            this.statementId = statementId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEventBusPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEventBusPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEventBusPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEventBusPolicyProps {
        private final java.lang.String action;
        private final java.lang.Object condition;
        private final java.lang.String eventBusName;
        private final java.lang.String principal;
        private final java.lang.Object statement;
        private final java.lang.String statementId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.eventBusName = software.amazon.jsii.Kernel.get(this, "eventBusName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.statement = software.amazon.jsii.Kernel.get(this, "statement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.statementId = software.amazon.jsii.Kernel.get(this, "statementId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.action = builder.action;
            this.condition = builder.condition;
            this.eventBusName = builder.eventBusName;
            this.principal = builder.principal;
            this.statement = builder.statement;
            this.statementId = java.util.Objects.requireNonNull(builder.statementId, "statementId is required");
        }

        @Override
        public final java.lang.String getAction() {
            return this.action;
        }

        @Override
        public final java.lang.Object getCondition() {
            return this.condition;
        }

        @Override
        public final java.lang.String getEventBusName() {
            return this.eventBusName;
        }

        @Override
        public final java.lang.String getPrincipal() {
            return this.principal;
        }

        @Override
        public final java.lang.Object getStatement() {
            return this.statement;
        }

        @Override
        public final java.lang.String getStatementId() {
            return this.statementId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAction() != null) {
                data.set("action", om.valueToTree(this.getAction()));
            }
            if (this.getCondition() != null) {
                data.set("condition", om.valueToTree(this.getCondition()));
            }
            if (this.getEventBusName() != null) {
                data.set("eventBusName", om.valueToTree(this.getEventBusName()));
            }
            if (this.getPrincipal() != null) {
                data.set("principal", om.valueToTree(this.getPrincipal()));
            }
            if (this.getStatement() != null) {
                data.set("statement", om.valueToTree(this.getStatement()));
            }
            data.set("statementId", om.valueToTree(this.getStatementId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-events.CfnEventBusPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEventBusPolicyProps.Jsii$Proxy that = (CfnEventBusPolicyProps.Jsii$Proxy) o;

            if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
            if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) return false;
            if (this.eventBusName != null ? !this.eventBusName.equals(that.eventBusName) : that.eventBusName != null) return false;
            if (this.principal != null ? !this.principal.equals(that.principal) : that.principal != null) return false;
            if (this.statement != null ? !this.statement.equals(that.statement) : that.statement != null) return false;
            return this.statementId.equals(that.statementId);
        }

        @Override
        public final int hashCode() {
            int result = this.action != null ? this.action.hashCode() : 0;
            result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
            result = 31 * result + (this.eventBusName != null ? this.eventBusName.hashCode() : 0);
            result = 31 * result + (this.principal != null ? this.principal.hashCode() : 0);
            result = 31 * result + (this.statement != null ? this.statement.hashCode() : 0);
            result = 31 * result + (this.statementId.hashCode());
            return result;
        }
    }
}
