/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.events.$Module;
import software.amazon.awscdk.services.events.EventPattern;
import software.amazon.awscdk.services.events.IEventBus;
import software.amazon.awscdk.services.events.IRule;
import software.amazon.awscdk.services.events.IRuleTarget;
import software.amazon.awscdk.services.events.RuleProps;
import software.amazon.awscdk.services.events.Schedule;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-events.Rule")
public class Rule
extends Resource
implements IRule {
    protected Rule(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Rule(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Rule(@NotNull Construct scope, @NotNull String id, @Nullable RuleProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Rule(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IRule fromEventRuleArn(@NotNull Construct scope, @NotNull String id, @NotNull String eventRuleArn) {
        return (IRule)JsiiObject.jsiiStaticCall(Rule.class, (String)"fromEventRuleArn", (NativeType)NativeType.forClass(IRule.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(eventRuleArn, "eventRuleArn is required")});
    }

    public void addEventPattern(@Nullable EventPattern eventPattern) {
        Kernel.call((Object)this, (String)"addEventPattern", (NativeType)NativeType.VOID, (Object[])new Object[]{eventPattern});
    }

    public void addEventPattern() {
        Kernel.call((Object)this, (String)"addEventPattern", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    public void addTarget(@Nullable IRuleTarget target) {
        Kernel.call((Object)this, (String)"addTarget", (NativeType)NativeType.VOID, (Object[])new Object[]{target});
    }

    public void addTarget() {
        Kernel.call((Object)this, (String)"addTarget", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @NotNull
    protected List<String> validate() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"validate", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)), (Object[])new Object[0]));
    }

    @Override
    @NotNull
    public String getRuleArn() {
        return (String)Kernel.get((Object)this, (String)"ruleArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getRuleName() {
        return (String)Kernel.get((Object)this, (String)"ruleName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Rule> {
        private final Construct scope;
        private final String id;
        private RuleProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.props().enabled(enabled);
            return this;
        }

        public Builder eventBus(IEventBus eventBus) {
            this.props().eventBus(eventBus);
            return this;
        }

        public Builder eventPattern(EventPattern eventPattern) {
            this.props().eventPattern(eventPattern);
            return this;
        }

        public Builder ruleName(String ruleName) {
            this.props().ruleName(ruleName);
            return this;
        }

        public Builder schedule(Schedule schedule) {
            this.props().schedule(schedule);
            return this;
        }

        public Builder targets(List<? extends IRuleTarget> targets) {
            this.props().targets(targets);
            return this;
        }

        public Rule build() {
            return new Rule(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private RuleProps.Builder props() {
            if (this.props == null) {
                this.props = new RuleProps.Builder();
            }
            return this.props;
        }
    }
}

