package software.amazon.awscdk.services.events;

/**
 * Properties for defining an EventBridge Rule.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.34.0 (build 9b72778)", date = "2021-09-08T20:43:49.155Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.$Module.class, fqn = "@aws-cdk/aws-events.RuleProps")
@software.amazon.jsii.Jsii.Proxy(RuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A description of the rule's purpose.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Indicates whether the rule is enabled.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * The event bus to associate with this rule.
     * <p>
     * Default: - The default event bus.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.IEventBus getEventBus() {
        return null;
    }

    /**
     * Describes which events EventBridge routes to the specified target.
     * <p>
     * These routed events are matched events. For more information, see Events
     * and Event Patterns in the Amazon EventBridge User Guide.
     * <p>
     * Default: - None.
     * <p>
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html
     * You must specify this property (either via props or via
     * `addEventPattern`), the `scheduleExpression` property, or both. The
     * method `addEventPattern` can be used to add filter values to the event
     * pattern.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.EventPattern getEventPattern() {
        return null;
    }

    /**
     * A name for the rule.
     * <p>
     * Default: - AWS CloudFormation generates a unique physical ID and uses that ID
     * for the rule name. For more information, see Name Type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRuleName() {
        return null;
    }

    /**
     * The schedule or rate (frequency) that determines when EventBridge runs the rule.
     * <p>
     * For more information, see Schedule Expression Syntax for
     * Rules in the Amazon EventBridge User Guide.
     * <p>
     * Default: - None.
     * <p>
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/scheduled-events.html
     * You must specify this property, the `eventPattern` property, or both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.Schedule getSchedule() {
        return null;
    }

    /**
     * Targets to invoke when this rule matches an event.
     * <p>
     * Input will be the full matched event. If you wish to specify custom
     * target input, use <code>addTarget(target[, inputOptions])</code>.
     * <p>
     * Default: - No targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.events.IRuleTarget> getTargets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RuleProps> {
        private java.lang.String description;
        private java.lang.Boolean enabled;
        private software.amazon.awscdk.services.events.IEventBus eventBus;
        private software.amazon.awscdk.services.events.EventPattern eventPattern;
        private java.lang.String ruleName;
        private software.amazon.awscdk.services.events.Schedule schedule;
        private java.util.List<software.amazon.awscdk.services.events.IRuleTarget> targets;

        /**
         * Sets the value of {@link RuleProps#getDescription}
         * @param description A description of the rule's purpose.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link RuleProps#getEnabled}
         * @param enabled Indicates whether the rule is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link RuleProps#getEventBus}
         * @param eventBus The event bus to associate with this rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBus(software.amazon.awscdk.services.events.IEventBus eventBus) {
            this.eventBus = eventBus;
            return this;
        }

        /**
         * Sets the value of {@link RuleProps#getEventPattern}
         * @param eventPattern Describes which events EventBridge routes to the specified target.
         *                     These routed events are matched events. For more information, see Events
         *                     and Event Patterns in the Amazon EventBridge User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventPattern(software.amazon.awscdk.services.events.EventPattern eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        /**
         * Sets the value of {@link RuleProps#getRuleName}
         * @param ruleName A name for the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(java.lang.String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        /**
         * Sets the value of {@link RuleProps#getSchedule}
         * @param schedule The schedule or rate (frequency) that determines when EventBridge runs the rule.
         *                 For more information, see Schedule Expression Syntax for
         *                 Rules in the Amazon EventBridge User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.services.events.Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link RuleProps#getTargets}
         * @param targets Targets to invoke when this rule matches an event.
         *                Input will be the full matched event. If you wish to specify custom
         *                target input, use <code>addTarget(target[, inputOptions])</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder targets(java.util.List<? extends software.amazon.awscdk.services.events.IRuleTarget> targets) {
            this.targets = (java.util.List<software.amazon.awscdk.services.events.IRuleTarget>)targets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RuleProps build() {
            return new Jsii$Proxy(description, enabled, eventBus, eventPattern, ruleName, schedule, targets);
        }
    }

    /**
     * An implementation for {@link RuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleProps {
        private final java.lang.String description;
        private final java.lang.Boolean enabled;
        private final software.amazon.awscdk.services.events.IEventBus eventBus;
        private final software.amazon.awscdk.services.events.EventPattern eventPattern;
        private final java.lang.String ruleName;
        private final software.amazon.awscdk.services.events.Schedule schedule;
        private final java.util.List<software.amazon.awscdk.services.events.IRuleTarget> targets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.eventBus = software.amazon.jsii.Kernel.get(this, "eventBus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.IEventBus.class));
            this.eventPattern = software.amazon.jsii.Kernel.get(this, "eventPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.EventPattern.class));
            this.ruleName = software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Schedule.class));
            this.targets = software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.IRuleTarget.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.String description, final java.lang.Boolean enabled, final software.amazon.awscdk.services.events.IEventBus eventBus, final software.amazon.awscdk.services.events.EventPattern eventPattern, final java.lang.String ruleName, final software.amazon.awscdk.services.events.Schedule schedule, final java.util.List<? extends software.amazon.awscdk.services.events.IRuleTarget> targets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = description;
            this.enabled = enabled;
            this.eventBus = eventBus;
            this.eventPattern = eventPattern;
            this.ruleName = ruleName;
            this.schedule = schedule;
            this.targets = (java.util.List<software.amazon.awscdk.services.events.IRuleTarget>)targets;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final software.amazon.awscdk.services.events.IEventBus getEventBus() {
            return this.eventBus;
        }

        @Override
        public final software.amazon.awscdk.services.events.EventPattern getEventPattern() {
            return this.eventPattern;
        }

        @Override
        public final java.lang.String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final software.amazon.awscdk.services.events.Schedule getSchedule() {
            return this.schedule;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.events.IRuleTarget> getTargets() {
            return this.targets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getEventBus() != null) {
                data.set("eventBus", om.valueToTree(this.getEventBus()));
            }
            if (this.getEventPattern() != null) {
                data.set("eventPattern", om.valueToTree(this.getEventPattern()));
            }
            if (this.getRuleName() != null) {
                data.set("ruleName", om.valueToTree(this.getRuleName()));
            }
            if (this.getSchedule() != null) {
                data.set("schedule", om.valueToTree(this.getSchedule()));
            }
            if (this.getTargets() != null) {
                data.set("targets", om.valueToTree(this.getTargets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-events.RuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RuleProps.Jsii$Proxy that = (RuleProps.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.eventBus != null ? !this.eventBus.equals(that.eventBus) : that.eventBus != null) return false;
            if (this.eventPattern != null ? !this.eventPattern.equals(that.eventPattern) : that.eventPattern != null) return false;
            if (this.ruleName != null ? !this.ruleName.equals(that.ruleName) : that.ruleName != null) return false;
            if (this.schedule != null ? !this.schedule.equals(that.schedule) : that.schedule != null) return false;
            return this.targets != null ? this.targets.equals(that.targets) : that.targets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.eventBus != null ? this.eventBus.hashCode() : 0);
            result = 31 * result + (this.eventPattern != null ? this.eventPattern.hashCode() : 0);
            result = 31 * result + (this.ruleName != null ? this.ruleName.hashCode() : 0);
            result = 31 * result + (this.schedule != null ? this.schedule.hashCode() : 0);
            result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
            return result;
        }
    }
}
