package software.amazon.awscdk.services.events;

/**
 * Properties for an event rule target.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-08-17T20:03:59.742Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.$Module.class, fqn = "@aws-cdk/aws-events.RuleTargetConfig")
@software.amazon.jsii.Jsii.Proxy(RuleTargetConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RuleTargetConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getArn();

    /**
     * Parameters used when the rule invokes Amazon AWS Batch Job/Queue.
     * <p>
     * Default: no parameters set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.CfnRule.BatchParametersProperty getBatchParameters() {
        return null;
    }

    /**
     * Contains information about a dead-letter queue configuration.
     * <p>
     * Default: no dead-letter queue set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.CfnRule.DeadLetterConfigProperty getDeadLetterConfig() {
        return null;
    }

    /**
     * The Amazon ECS task definition and task count to use, if the event target is an Amazon ECS task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty getEcsParameters() {
        return null;
    }

    /**
     * Parameters used when the rule invoke api gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.CfnRule.HttpParametersProperty getHttpParameters() {
        return null;
    }

    /**
     * (deprecated) A unique, user-defined identifier for the target.
     * <p>
     * Acceptable values
     * include alphanumeric characters, periods (.), hyphens (-), and
     * underscores (_).
     * <p>
     * Default: - an auto-generated id
     * <p>
     * @deprecated no replacement. we will always use an autogenerated id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getId() {
        return null;
    }

    /**
     * What input to send to the event target.
     * <p>
     * Default: the entire event
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.RuleTargetInput getInput() {
        return null;
    }

    /**
     * Settings that control shard assignment, when the target is a Kinesis stream.
     * <p>
     * If you don't include this parameter, eventId is used as the
     * partition key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty getKinesisParameters() {
        return null;
    }

    /**
     * A RetryPolicy object that includes information about the retry policy settings.
     * <p>
     * Default: EventBridge default retry policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.CfnRule.RetryPolicyProperty getRetryPolicy() {
        return null;
    }

    /**
     * Role to use to invoke this event target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * Parameters used when the rule invokes Amazon EC2 Systems Manager Run Command.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty getRunCommandParameters() {
        return null;
    }

    /**
     * Parameters used when the FIFO sqs queue is used an event target by the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty getSqsParameters() {
        return null;
    }

    /**
     * The resource that is backing this target.
     * <p>
     * This is the resource that will actually have some action performed on it when used as a target
     * (for example, start a build for a CodeBuild project).
     * We need it to determine whether the rule belongs to a different account than the target -
     * if so, we generate a more complex setup,
     * including an additional stack containing the EventBusPolicy.
     * <p>
     * Default: the target is not backed by any resource
     * <p>
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IConstruct getTargetResource() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RuleTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RuleTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RuleTargetConfig> {
        private java.lang.String arn;
        private software.amazon.awscdk.services.events.CfnRule.BatchParametersProperty batchParameters;
        private software.amazon.awscdk.services.events.CfnRule.DeadLetterConfigProperty deadLetterConfig;
        private software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty ecsParameters;
        private software.amazon.awscdk.services.events.CfnRule.HttpParametersProperty httpParameters;
        private java.lang.String id;
        private software.amazon.awscdk.services.events.RuleTargetInput input;
        private software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty kinesisParameters;
        private software.amazon.awscdk.services.events.CfnRule.RetryPolicyProperty retryPolicy;
        private software.amazon.awscdk.services.iam.IRole role;
        private software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty runCommandParameters;
        private software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty sqsParameters;
        private software.amazon.awscdk.core.IConstruct targetResource;

        /**
         * Sets the value of {@link RuleTargetConfig#getArn}
         * @param arn The Amazon Resource Name (ARN) of the target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder arn(java.lang.String arn) {
            this.arn = arn;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getBatchParameters}
         * @param batchParameters Parameters used when the rule invokes Amazon AWS Batch Job/Queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchParameters(software.amazon.awscdk.services.events.CfnRule.BatchParametersProperty batchParameters) {
            this.batchParameters = batchParameters;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getDeadLetterConfig}
         * @param deadLetterConfig Contains information about a dead-letter queue configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterConfig(software.amazon.awscdk.services.events.CfnRule.DeadLetterConfigProperty deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getEcsParameters}
         * @param ecsParameters The Amazon ECS task definition and task count to use, if the event target is an Amazon ECS task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecsParameters(software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty ecsParameters) {
            this.ecsParameters = ecsParameters;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getHttpParameters}
         * @param httpParameters Parameters used when the rule invoke api gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpParameters(software.amazon.awscdk.services.events.CfnRule.HttpParametersProperty httpParameters) {
            this.httpParameters = httpParameters;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getId}
         * @param id A unique, user-defined identifier for the target.
         *           Acceptable values
         *           include alphanumeric characters, periods (.), hyphens (-), and
         *           underscores (_).
         * @return {@code this}
         * @deprecated no replacement. we will always use an autogenerated id.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getInput}
         * @param input What input to send to the event target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(software.amazon.awscdk.services.events.RuleTargetInput input) {
            this.input = input;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getKinesisParameters}
         * @param kinesisParameters Settings that control shard assignment, when the target is a Kinesis stream.
         *                          If you don't include this parameter, eventId is used as the
         *                          partition key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisParameters(software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty kinesisParameters) {
            this.kinesisParameters = kinesisParameters;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getRetryPolicy}
         * @param retryPolicy A RetryPolicy object that includes information about the retry policy settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryPolicy(software.amazon.awscdk.services.events.CfnRule.RetryPolicyProperty retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getRole}
         * @param role Role to use to invoke this event target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getRunCommandParameters}
         * @param runCommandParameters Parameters used when the rule invokes Amazon EC2 Systems Manager Run Command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runCommandParameters(software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty runCommandParameters) {
            this.runCommandParameters = runCommandParameters;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getSqsParameters}
         * @param sqsParameters Parameters used when the FIFO sqs queue is used an event target by the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sqsParameters(software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty sqsParameters) {
            this.sqsParameters = sqsParameters;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetConfig#getTargetResource}
         * @param targetResource The resource that is backing this target.
         *                       This is the resource that will actually have some action performed on it when used as a target
         *                       (for example, start a build for a CodeBuild project).
         *                       We need it to determine whether the rule belongs to a different account than the target -
         *                       if so, we generate a more complex setup,
         *                       including an additional stack containing the EventBusPolicy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetResource(software.amazon.awscdk.core.IConstruct targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RuleTargetConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RuleTargetConfig build() {
            return new Jsii$Proxy(arn, batchParameters, deadLetterConfig, ecsParameters, httpParameters, id, input, kinesisParameters, retryPolicy, role, runCommandParameters, sqsParameters, targetResource);
        }
    }

    /**
     * An implementation for {@link RuleTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleTargetConfig {
        private final java.lang.String arn;
        private final software.amazon.awscdk.services.events.CfnRule.BatchParametersProperty batchParameters;
        private final software.amazon.awscdk.services.events.CfnRule.DeadLetterConfigProperty deadLetterConfig;
        private final software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty ecsParameters;
        private final software.amazon.awscdk.services.events.CfnRule.HttpParametersProperty httpParameters;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.events.RuleTargetInput input;
        private final software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty kinesisParameters;
        private final software.amazon.awscdk.services.events.CfnRule.RetryPolicyProperty retryPolicy;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty runCommandParameters;
        private final software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty sqsParameters;
        private final software.amazon.awscdk.core.IConstruct targetResource;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.batchParameters = software.amazon.jsii.Kernel.get(this, "batchParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.CfnRule.BatchParametersProperty.class));
            this.deadLetterConfig = software.amazon.jsii.Kernel.get(this, "deadLetterConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.CfnRule.DeadLetterConfigProperty.class));
            this.ecsParameters = software.amazon.jsii.Kernel.get(this, "ecsParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty.class));
            this.httpParameters = software.amazon.jsii.Kernel.get(this, "httpParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.CfnRule.HttpParametersProperty.class));
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetInput.class));
            this.kinesisParameters = software.amazon.jsii.Kernel.get(this, "kinesisParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty.class));
            this.retryPolicy = software.amazon.jsii.Kernel.get(this, "retryPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.CfnRule.RetryPolicyProperty.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.runCommandParameters = software.amazon.jsii.Kernel.get(this, "runCommandParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty.class));
            this.sqsParameters = software.amazon.jsii.Kernel.get(this, "sqsParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty.class));
            this.targetResource = software.amazon.jsii.Kernel.get(this, "targetResource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IConstruct.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String arn, final software.amazon.awscdk.services.events.CfnRule.BatchParametersProperty batchParameters, final software.amazon.awscdk.services.events.CfnRule.DeadLetterConfigProperty deadLetterConfig, final software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty ecsParameters, final software.amazon.awscdk.services.events.CfnRule.HttpParametersProperty httpParameters, final java.lang.String id, final software.amazon.awscdk.services.events.RuleTargetInput input, final software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty kinesisParameters, final software.amazon.awscdk.services.events.CfnRule.RetryPolicyProperty retryPolicy, final software.amazon.awscdk.services.iam.IRole role, final software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty runCommandParameters, final software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty sqsParameters, final software.amazon.awscdk.core.IConstruct targetResource) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.arn = java.util.Objects.requireNonNull(arn, "arn is required");
            this.batchParameters = batchParameters;
            this.deadLetterConfig = deadLetterConfig;
            this.ecsParameters = ecsParameters;
            this.httpParameters = httpParameters;
            this.id = id;
            this.input = input;
            this.kinesisParameters = kinesisParameters;
            this.retryPolicy = retryPolicy;
            this.role = role;
            this.runCommandParameters = runCommandParameters;
            this.sqsParameters = sqsParameters;
            this.targetResource = targetResource;
        }

        @Override
        public final java.lang.String getArn() {
            return this.arn;
        }

        @Override
        public final software.amazon.awscdk.services.events.CfnRule.BatchParametersProperty getBatchParameters() {
            return this.batchParameters;
        }

        @Override
        public final software.amazon.awscdk.services.events.CfnRule.DeadLetterConfigProperty getDeadLetterConfig() {
            return this.deadLetterConfig;
        }

        @Override
        public final software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty getEcsParameters() {
            return this.ecsParameters;
        }

        @Override
        public final software.amazon.awscdk.services.events.CfnRule.HttpParametersProperty getHttpParameters() {
            return this.httpParameters;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final software.amazon.awscdk.services.events.RuleTargetInput getInput() {
            return this.input;
        }

        @Override
        public final software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty getKinesisParameters() {
            return this.kinesisParameters;
        }

        @Override
        public final software.amazon.awscdk.services.events.CfnRule.RetryPolicyProperty getRetryPolicy() {
            return this.retryPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty getRunCommandParameters() {
            return this.runCommandParameters;
        }

        @Override
        public final software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty getSqsParameters() {
            return this.sqsParameters;
        }

        @Override
        public final software.amazon.awscdk.core.IConstruct getTargetResource() {
            return this.targetResource;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("arn", om.valueToTree(this.getArn()));
            if (this.getBatchParameters() != null) {
                data.set("batchParameters", om.valueToTree(this.getBatchParameters()));
            }
            if (this.getDeadLetterConfig() != null) {
                data.set("deadLetterConfig", om.valueToTree(this.getDeadLetterConfig()));
            }
            if (this.getEcsParameters() != null) {
                data.set("ecsParameters", om.valueToTree(this.getEcsParameters()));
            }
            if (this.getHttpParameters() != null) {
                data.set("httpParameters", om.valueToTree(this.getHttpParameters()));
            }
            if (this.getId() != null) {
                data.set("id", om.valueToTree(this.getId()));
            }
            if (this.getInput() != null) {
                data.set("input", om.valueToTree(this.getInput()));
            }
            if (this.getKinesisParameters() != null) {
                data.set("kinesisParameters", om.valueToTree(this.getKinesisParameters()));
            }
            if (this.getRetryPolicy() != null) {
                data.set("retryPolicy", om.valueToTree(this.getRetryPolicy()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getRunCommandParameters() != null) {
                data.set("runCommandParameters", om.valueToTree(this.getRunCommandParameters()));
            }
            if (this.getSqsParameters() != null) {
                data.set("sqsParameters", om.valueToTree(this.getSqsParameters()));
            }
            if (this.getTargetResource() != null) {
                data.set("targetResource", om.valueToTree(this.getTargetResource()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-events.RuleTargetConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RuleTargetConfig.Jsii$Proxy that = (RuleTargetConfig.Jsii$Proxy) o;

            if (!arn.equals(that.arn)) return false;
            if (this.batchParameters != null ? !this.batchParameters.equals(that.batchParameters) : that.batchParameters != null) return false;
            if (this.deadLetterConfig != null ? !this.deadLetterConfig.equals(that.deadLetterConfig) : that.deadLetterConfig != null) return false;
            if (this.ecsParameters != null ? !this.ecsParameters.equals(that.ecsParameters) : that.ecsParameters != null) return false;
            if (this.httpParameters != null ? !this.httpParameters.equals(that.httpParameters) : that.httpParameters != null) return false;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
            if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
            if (this.kinesisParameters != null ? !this.kinesisParameters.equals(that.kinesisParameters) : that.kinesisParameters != null) return false;
            if (this.retryPolicy != null ? !this.retryPolicy.equals(that.retryPolicy) : that.retryPolicy != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.runCommandParameters != null ? !this.runCommandParameters.equals(that.runCommandParameters) : that.runCommandParameters != null) return false;
            if (this.sqsParameters != null ? !this.sqsParameters.equals(that.sqsParameters) : that.sqsParameters != null) return false;
            return this.targetResource != null ? this.targetResource.equals(that.targetResource) : that.targetResource == null;
        }

        @Override
        public final int hashCode() {
            int result = this.arn.hashCode();
            result = 31 * result + (this.batchParameters != null ? this.batchParameters.hashCode() : 0);
            result = 31 * result + (this.deadLetterConfig != null ? this.deadLetterConfig.hashCode() : 0);
            result = 31 * result + (this.ecsParameters != null ? this.ecsParameters.hashCode() : 0);
            result = 31 * result + (this.httpParameters != null ? this.httpParameters.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
            result = 31 * result + (this.kinesisParameters != null ? this.kinesisParameters.hashCode() : 0);
            result = 31 * result + (this.retryPolicy != null ? this.retryPolicy.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.runCommandParameters != null ? this.runCommandParameters.hashCode() : 0);
            result = 31 * result + (this.sqsParameters != null ? this.sqsParameters.hashCode() : 0);
            result = 31 * result + (this.targetResource != null ? this.targetResource.hashCode() : 0);
            return result;
        }
    }
}
