package software.amazon.awscdk.services.events;

/**
 * Properties to define an event bus.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T15:55:57.951Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.$Module.class, fqn = "@aws-cdk/aws-events.EventBusProps")
@software.amazon.jsii.Jsii.Proxy(EventBusProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EventBusProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the event bus you are creating Note: If 'eventSourceName' is passed in, you cannot set this.
     * <p>
     * Default: - automatically generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEventBusName() {
        return null;
    }

    /**
     * The partner event source to associate with this event bus resource Note: If 'eventBusName' is passed in, you cannot set this.
     * <p>
     * Default: - no partner event source
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEventSourceName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EventBusProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EventBusProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EventBusProps> {
        private java.lang.String eventBusName;
        private java.lang.String eventSourceName;

        /**
         * Sets the value of {@link EventBusProps#getEventBusName}
         * @param eventBusName The name of the event bus you are creating Note: If 'eventSourceName' is passed in, you cannot set this.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBusName(java.lang.String eventBusName) {
            this.eventBusName = eventBusName;
            return this;
        }

        /**
         * Sets the value of {@link EventBusProps#getEventSourceName}
         * @param eventSourceName The partner event source to associate with this event bus resource Note: If 'eventBusName' is passed in, you cannot set this.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSourceName(java.lang.String eventSourceName) {
            this.eventSourceName = eventSourceName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventBusProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EventBusProps build() {
            return new Jsii$Proxy(eventBusName, eventSourceName);
        }
    }

    /**
     * An implementation for {@link EventBusProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventBusProps {
        private final java.lang.String eventBusName;
        private final java.lang.String eventSourceName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventBusName = software.amazon.jsii.Kernel.get(this, "eventBusName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventSourceName = software.amazon.jsii.Kernel.get(this, "eventSourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String eventBusName, final java.lang.String eventSourceName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventBusName = eventBusName;
            this.eventSourceName = eventSourceName;
        }

        @Override
        public final java.lang.String getEventBusName() {
            return this.eventBusName;
        }

        @Override
        public final java.lang.String getEventSourceName() {
            return this.eventSourceName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEventBusName() != null) {
                data.set("eventBusName", om.valueToTree(this.getEventBusName()));
            }
            if (this.getEventSourceName() != null) {
                data.set("eventSourceName", om.valueToTree(this.getEventSourceName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-events.EventBusProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EventBusProps.Jsii$Proxy that = (EventBusProps.Jsii$Proxy) o;

            if (this.eventBusName != null ? !this.eventBusName.equals(that.eventBusName) : that.eventBusName != null) return false;
            return this.eventSourceName != null ? this.eventSourceName.equals(that.eventSourceName) : that.eventSourceName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.eventBusName != null ? this.eventBusName.hashCode() : 0;
            result = 31 * result + (this.eventSourceName != null ? this.eventSourceName.hashCode() : 0);
            return result;
        }
    }
}
