package software.amazon.awscdk.services.events;

/**
 * Interface which all EventBus based classes MUST implement.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-07-09T19:17:35.375Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.$Module.class, fqn = "@aws-cdk/aws-events.IEventBus")
@software.amazon.jsii.Jsii.Proxy(IEventBus.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IEventBus extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResource {

    /**
     * The ARN of this event bus resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEventBusArn();

    /**
     * The physical ID of this event bus resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEventBusName();

    /**
     * The JSON policy of this event bus resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEventBusPolicy();

    /**
     * The partner event source to associate with this event bus resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEventSourceName() {
        return null;
    }

    /**
     * Create an EventBridge archive to send events to.
     * <p>
     * When you create an archive, incoming events might not immediately start being sent to the archive.
     * Allow a short period of time for changes to take effect.
     * <p>
     * @param id This parameter is required.
     * @param props Properties of the archive. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Archive archive(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.BaseArchiveProps props);

    /**
     * Grants an IAM Principal to send custom events to the eventBus so that they can be matched to rules.
     * <p>
     * @param grantee The principal (no-op if undefined). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPutEventsTo(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IEventBus.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
        }

        /**
         * The ARN of this event bus resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getEventBusArn() {
            return software.amazon.jsii.Kernel.get(this, "eventBusArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The physical ID of this event bus resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getEventBusName() {
            return software.amazon.jsii.Kernel.get(this, "eventBusName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The JSON policy of this event bus resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getEventBusPolicy() {
            return software.amazon.jsii.Kernel.get(this, "eventBusPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The partner event source to associate with this event bus resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getEventSourceName() {
            return software.amazon.jsii.Kernel.get(this, "eventSourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Create an EventBridge archive to send events to.
         * <p>
         * When you create an archive, incoming events might not immediately start being sent to the archive.
         * Allow a short period of time for changes to take effect.
         * <p>
         * @param id This parameter is required.
         * @param props Properties of the archive. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Archive archive(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.BaseArchiveProps props) {
            return software.amazon.jsii.Kernel.call(this, "archive", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Archive.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
        }

        /**
         * Grants an IAM Principal to send custom events to the eventBus so that they can be matched to rules.
         * <p>
         * @param grantee The principal (no-op if undefined). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPutEventsTo(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantPutEventsTo", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }
    }

    /**
     * Internal default implementation for {@link IEventBus}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IEventBus, software.amazon.awscdk.core.IResource.Jsii$Default {

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
        }

        /**
         * The ARN of this event bus resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getEventBusArn() {
            return software.amazon.jsii.Kernel.get(this, "eventBusArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The physical ID of this event bus resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getEventBusName() {
            return software.amazon.jsii.Kernel.get(this, "eventBusName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The JSON policy of this event bus resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getEventBusPolicy() {
            return software.amazon.jsii.Kernel.get(this, "eventBusPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The partner event source to associate with this event bus resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventSourceName() {
            return software.amazon.jsii.Kernel.get(this, "eventSourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Create an EventBridge archive to send events to.
         * <p>
         * When you create an archive, incoming events might not immediately start being sent to the archive.
         * Allow a short period of time for changes to take effect.
         * <p>
         * @param id This parameter is required.
         * @param props Properties of the archive. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Archive archive(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.BaseArchiveProps props) {
            return software.amazon.jsii.Kernel.call(this, "archive", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Archive.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
        }

        /**
         * Grants an IAM Principal to send custom events to the eventBus so that they can be matched to rules.
         * <p>
         * @param grantee The principal (no-op if undefined). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPutEventsTo(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantPutEventsTo", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }
    }
}
