package software.amazon.awscdk.services.events;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.6 (build 04cb6bb)", date = "2018-09-20T13:04:04.142Z")
public interface EventRuleProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * A description of the rule's purpose.
     */
    java.lang.String getDescription();
    /**
     * A description of the rule's purpose.
     */
    void setDescription(final java.lang.String value);
    /**
     * Indicates whether the rule is enabled.
     * @default Rule is enabled
     */
    java.lang.Boolean getEnabled();
    /**
     * Indicates whether the rule is enabled.
     * @default Rule is enabled
     */
    void setEnabled(final java.lang.Boolean value);
    /**
     * Describes which events CloudWatch Events routes to the specified target.
     * These routed events are matched events. For more information, see Events
     * and Event Patterns in the Amazon CloudWatch User Guide.
     * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CloudWatchEventsandEventPatterns.html  You must specify this property (either via props or via `addEventPattern`), the `scheduleExpression` property, or both. The method `addEventPattern` can be used to add filter values to the event pattern.
     */
    software.amazon.awscdk.services.events.EventPattern getEventPattern();
    /**
     * Describes which events CloudWatch Events routes to the specified target.
     * These routed events are matched events. For more information, see Events
     * and Event Patterns in the Amazon CloudWatch User Guide.
     * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CloudWatchEventsandEventPatterns.html  You must specify this property (either via props or via `addEventPattern`), the `scheduleExpression` property, or both. The method `addEventPattern` can be used to add filter values to the event pattern.
     */
    void setEventPattern(final software.amazon.awscdk.services.events.EventPattern value);
    /**
     * A name for the rule. If you don't specify a name, AWS CloudFormation
     * generates a unique physical ID and uses that ID for the rule name. For
     * more information, see Name Type.
     */
    java.lang.String getRuleName();
    /**
     * A name for the rule. If you don't specify a name, AWS CloudFormation
     * generates a unique physical ID and uses that ID for the rule name. For
     * more information, see Name Type.
     */
    void setRuleName(final java.lang.String value);
    /**
     * The schedule or rate (frequency) that determines when CloudWatch Events
     * runs the rule. For more information, see Schedule Expression Syntax for
     * Rules in the Amazon CloudWatch User Guide.
     * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html  You must specify this property, the `eventPattern` property, or both.
     */
    java.lang.String getScheduleExpression();
    /**
     * The schedule or rate (frequency) that determines when CloudWatch Events
     * runs the rule. For more information, see Schedule Expression Syntax for
     * Rules in the Amazon CloudWatch User Guide.
     * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html  You must specify this property, the `eventPattern` property, or both.
     */
    void setScheduleExpression(final java.lang.String value);
    /**
     * Targets to invoke when this rule matches an event.
     * 
     * Input will be the full matched event. If you wish to specify custom
     * target input, use `addTarget(target[, inputOptions])`.
     */
    java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> getTargets();
    /**
     * Targets to invoke when this rule matches an event.
     * 
     * Input will be the full matched event. If you wish to specify custom
     * target input, use `addTarget(target[, inputOptions])`.
     */
    void setTargets(final java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> value);

    /**
     * @return a {@link Builder} of {@link EventRuleProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link EventRuleProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.lang.Boolean _enabled;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.events.EventPattern _eventPattern;
        @javax.annotation.Nullable
        private java.lang.String _ruleName;
        @javax.annotation.Nullable
        private java.lang.String _scheduleExpression;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> _targets;

        /**
         * Sets the value of Description
         * @param value A description of the rule's purpose.
         * @return {@code this}
         */
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of Enabled
         * @param value Indicates whether the rule is enabled.
         * @return {@code this}
         */
        public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._enabled = value;
            return this;
        }
        /**
         * Sets the value of EventPattern
         * @param value Describes which events CloudWatch Events routes to the specified target.
These routed events are matched events. For more information, see Events
and Event Patterns in the Amazon CloudWatch User Guide.
         * @return {@code this}
         */
        public Builder withEventPattern(@javax.annotation.Nullable final software.amazon.awscdk.services.events.EventPattern value) {
            this._eventPattern = value;
            return this;
        }
        /**
         * Sets the value of RuleName
         * @param value A name for the rule. If you don't specify a name, AWS CloudFormation
generates a unique physical ID and uses that ID for the rule name. For
more information, see Name Type.
         * @return {@code this}
         */
        public Builder withRuleName(@javax.annotation.Nullable final java.lang.String value) {
            this._ruleName = value;
            return this;
        }
        /**
         * Sets the value of ScheduleExpression
         * @param value The schedule or rate (frequency) that determines when CloudWatch Events
runs the rule. For more information, see Schedule Expression Syntax for
Rules in the Amazon CloudWatch User Guide.
         * @return {@code this}
         */
        public Builder withScheduleExpression(@javax.annotation.Nullable final java.lang.String value) {
            this._scheduleExpression = value;
            return this;
        }
        /**
         * Sets the value of Targets
         * @param value Targets to invoke when this rule matches an event.

Input will be the full matched event. If you wish to specify custom
target input, use `addTarget(target[, inputOptions])`.
         * @return {@code this}
         */
        public Builder withTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> value) {
            this._targets = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public EventRuleProps build() {
            return new EventRuleProps() {
                @javax.annotation.Nullable
                private java.lang.String $description = _description;
                @javax.annotation.Nullable
                private java.lang.Boolean $enabled = _enabled;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.events.EventPattern $eventPattern = _eventPattern;
                @javax.annotation.Nullable
                private java.lang.String $ruleName = _ruleName;
                @javax.annotation.Nullable
                private java.lang.String $scheduleExpression = _scheduleExpression;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> $targets = _targets;

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                    this.$description = value;
                }

                @Override
                public java.lang.Boolean getEnabled() {
                    return this.$enabled;
                }

                @Override
                public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$enabled = value;
                }

                @Override
                public software.amazon.awscdk.services.events.EventPattern getEventPattern() {
                    return this.$eventPattern;
                }

                @Override
                public void setEventPattern(@javax.annotation.Nullable final software.amazon.awscdk.services.events.EventPattern value) {
                    this.$eventPattern = value;
                }

                @Override
                public java.lang.String getRuleName() {
                    return this.$ruleName;
                }

                @Override
                public void setRuleName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$ruleName = value;
                }

                @Override
                public java.lang.String getScheduleExpression() {
                    return this.$scheduleExpression;
                }

                @Override
                public void setScheduleExpression(@javax.annotation.Nullable final java.lang.String value) {
                    this.$scheduleExpression = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> getTargets() {
                    return this.$targets;
                }

                @Override
                public void setTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> value) {
                    this.$targets = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.EventRuleProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * A description of the rule's purpose.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * A description of the rule's purpose.
         */
        @Override
        public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("description", value);
        }

        /**
         * Indicates whether the rule is enabled.
         * @default Rule is enabled
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getEnabled() {
            return this.jsiiGet("enabled", java.lang.Boolean.class);
        }

        /**
         * Indicates whether the rule is enabled.
         * @default Rule is enabled
         */
        @Override
        public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("enabled", value);
        }

        /**
         * Describes which events CloudWatch Events routes to the specified target.
         * These routed events are matched events. For more information, see Events
         * and Event Patterns in the Amazon CloudWatch User Guide.
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CloudWatchEventsandEventPatterns.html  You must specify this property (either via props or via `addEventPattern`), the `scheduleExpression` property, or both. The method `addEventPattern` can be used to add filter values to the event pattern.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.EventPattern getEventPattern() {
            return this.jsiiGet("eventPattern", software.amazon.awscdk.services.events.EventPattern.class);
        }

        /**
         * Describes which events CloudWatch Events routes to the specified target.
         * These routed events are matched events. For more information, see Events
         * and Event Patterns in the Amazon CloudWatch User Guide.
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CloudWatchEventsandEventPatterns.html  You must specify this property (either via props or via `addEventPattern`), the `scheduleExpression` property, or both. The method `addEventPattern` can be used to add filter values to the event pattern.
         */
        @Override
        public void setEventPattern(@javax.annotation.Nullable final software.amazon.awscdk.services.events.EventPattern value) {
            this.jsiiSet("eventPattern", value);
        }

        /**
         * A name for the rule. If you don't specify a name, AWS CloudFormation
         * generates a unique physical ID and uses that ID for the rule name. For
         * more information, see Name Type.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getRuleName() {
            return this.jsiiGet("ruleName", java.lang.String.class);
        }

        /**
         * A name for the rule. If you don't specify a name, AWS CloudFormation
         * generates a unique physical ID and uses that ID for the rule name. For
         * more information, see Name Type.
         */
        @Override
        public void setRuleName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("ruleName", value);
        }

        /**
         * The schedule or rate (frequency) that determines when CloudWatch Events
         * runs the rule. For more information, see Schedule Expression Syntax for
         * Rules in the Amazon CloudWatch User Guide.
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html  You must specify this property, the `eventPattern` property, or both.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getScheduleExpression() {
            return this.jsiiGet("scheduleExpression", java.lang.String.class);
        }

        /**
         * The schedule or rate (frequency) that determines when CloudWatch Events
         * runs the rule. For more information, see Schedule Expression Syntax for
         * Rules in the Amazon CloudWatch User Guide.
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html  You must specify this property, the `eventPattern` property, or both.
         */
        @Override
        public void setScheduleExpression(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("scheduleExpression", value);
        }

        /**
         * Targets to invoke when this rule matches an event.
         * 
         * Input will be the full matched event. If you wish to specify custom
         * target input, use `addTarget(target[, inputOptions])`.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> getTargets() {
            return this.jsiiGet("targets", java.util.List.class);
        }

        /**
         * Targets to invoke when this rule matches an event.
         * 
         * Input will be the full matched event. If you wish to specify custom
         * target input, use `addTarget(target[, inputOptions])`.
         */
        @Override
        public void setTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> value) {
            this.jsiiSet("targets", value);
        }
    }
}
