package software.amazon.awscdk.services.events.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.$Module.class, fqn = "@aws-cdk/aws-events.cloudformation.RuleResource")
public class RuleResource extends software.amazon.awscdk.Resource {
    protected RuleResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.events.cloudformation.RuleResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::Events::Rule``.
     * @param parent the ``cdk.Construct`` this ``RuleResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``RuleResource``
     */
    public RuleResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.cloudformation.RuleResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(properties)).toArray());
    }
    /**
     * Creates a new ``AWS::Events::Rule``.
     * @param parent the ``cdk.Construct`` this ``RuleResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     */
    public RuleResource(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @cloudformation_attribute Arn
     */
    public software.amazon.awscdk.services.events.RuleArn getRuleArn() {
        return this.jsiiGet("ruleArn", software.amazon.awscdk.services.events.RuleArn.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html
     */
    public static interface EcsParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``RuleResource.EcsParametersProperty.TaskCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
         */
        java.lang.Object getTaskCount();
        /**
         * ``RuleResource.EcsParametersProperty.TaskCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
         */
        void setTaskCount(final java.lang.Number value);
        /**
         * ``RuleResource.EcsParametersProperty.TaskCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
         */
        void setTaskCount(final software.amazon.awscdk.Token value);
        /**
         * ``RuleResource.EcsParametersProperty.TaskDefinitionArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn
         */
        java.lang.Object getTaskDefinitionArn();
        /**
         * ``RuleResource.EcsParametersProperty.TaskDefinitionArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn
         */
        void setTaskDefinitionArn(final java.lang.String value);
        /**
         * ``RuleResource.EcsParametersProperty.TaskDefinitionArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn
         */
        void setTaskDefinitionArn(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link EcsParametersProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``RuleResource.EcsParametersProperty.TaskDefinitionArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn
             */
            public Build withTaskDefinitionArn(final java.lang.String value) {
                return new FullBuilder().withTaskDefinitionArn(value);
            }
            /**
             * ``RuleResource.EcsParametersProperty.TaskDefinitionArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn
             */
            public Build withTaskDefinitionArn(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withTaskDefinitionArn(value);
            }

            public interface Build {
                /**
                 * @return a new {@link EcsParametersProperty} object, initialized with the values set on this builder.
                 */
                EcsParametersProperty build();
                /**
                 * ``RuleResource.EcsParametersProperty.TaskCount``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
                 */
                Build withTaskCount(final java.lang.Number value);
                /**
                 * ``RuleResource.EcsParametersProperty.TaskCount``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
                 */
                Build withTaskCount(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``RuleResource.EcsParametersProperty.TaskCount``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
                 */
                public Build withTaskCount(final java.lang.Number value) {
                    this.instance._taskCount = value;
                    return this;
                }
                /**
                 * ``RuleResource.EcsParametersProperty.TaskCount``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
                 */
                public Build withTaskCount(final software.amazon.awscdk.Token value) {
                    this.instance._taskCount = value;
                    return this;
                }
                /**
                 * ``RuleResource.EcsParametersProperty.TaskDefinitionArn``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn
                 */
                public Build withTaskDefinitionArn(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "EcsParametersProperty#taskDefinitionArn is required");
                    this.instance._taskDefinitionArn = value;
                    return this;
                }
                /**
                 * ``RuleResource.EcsParametersProperty.TaskDefinitionArn``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn
                 */
                public Build withTaskDefinitionArn(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "EcsParametersProperty#taskDefinitionArn is required");
                    this.instance._taskDefinitionArn = value;
                    return this;
                }
                public EcsParametersProperty build() {
                    EcsParametersProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link EcsParametersProperty}.
         */
        final class Jsii$Pojo implements EcsParametersProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _taskCount;

            public java.lang.Object getTaskCount() {
                return this._taskCount;
            }
            public void setTaskCount(final java.lang.Number value) {
                this._taskCount = value;
            }
            public void setTaskCount(final software.amazon.awscdk.Token value) {
                this._taskCount = value;
            }

            protected java.lang.Object _taskDefinitionArn;

            public java.lang.Object getTaskDefinitionArn() {
                return this._taskDefinitionArn;
            }
            public void setTaskDefinitionArn(final java.lang.String value) {
                this._taskDefinitionArn = value;
            }
            public void setTaskDefinitionArn(final software.amazon.awscdk.Token value) {
                this._taskDefinitionArn = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``RuleResource.EcsParametersProperty.TaskCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
             */
            @javax.annotation.Nullable
            public java.lang.Object getTaskCount() {
                return this.jsiiGet("taskCount", java.lang.Object.class);
            }
            /**
             * ``RuleResource.EcsParametersProperty.TaskCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
             */
            public void setTaskCount(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("taskCount", value);
            }
            /**
             * ``RuleResource.EcsParametersProperty.TaskCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
             */
            public void setTaskCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("taskCount", value);
            }
            /**
             * ``RuleResource.EcsParametersProperty.TaskDefinitionArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn
             */
            public java.lang.Object getTaskDefinitionArn() {
                return this.jsiiGet("taskDefinitionArn", java.lang.Object.class);
            }
            /**
             * ``RuleResource.EcsParametersProperty.TaskDefinitionArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn
             */
            public void setTaskDefinitionArn(final java.lang.String value) {
                this.jsiiSet("taskDefinitionArn", java.util.Objects.requireNonNull(value, "taskDefinitionArn is required"));
            }
            /**
             * ``RuleResource.EcsParametersProperty.TaskDefinitionArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn
             */
            public void setTaskDefinitionArn(final software.amazon.awscdk.Token value) {
                this.jsiiSet("taskDefinitionArn", java.util.Objects.requireNonNull(value, "taskDefinitionArn is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html
     */
    public static interface InputTransformerProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``RuleResource.InputTransformerProperty.InputPathsMap``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
         */
        java.lang.Object getInputPathsMap();
        /**
         * ``RuleResource.InputTransformerProperty.InputPathsMap``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
         */
        void setInputPathsMap(final software.amazon.awscdk.Token value);
        /**
         * ``RuleResource.InputTransformerProperty.InputPathsMap``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
         */
        void setInputPathsMap(final java.util.Map<java.lang.String, java.lang.Object> value);
        /**
         * ``RuleResource.InputTransformerProperty.InputTemplate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate
         */
        java.lang.Object getInputTemplate();
        /**
         * ``RuleResource.InputTransformerProperty.InputTemplate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate
         */
        void setInputTemplate(final java.lang.String value);
        /**
         * ``RuleResource.InputTransformerProperty.InputTemplate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate
         */
        void setInputTemplate(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link InputTransformerProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``RuleResource.InputTransformerProperty.InputTemplate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate
             */
            public Build withInputTemplate(final java.lang.String value) {
                return new FullBuilder().withInputTemplate(value);
            }
            /**
             * ``RuleResource.InputTransformerProperty.InputTemplate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate
             */
            public Build withInputTemplate(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withInputTemplate(value);
            }

            public interface Build {
                /**
                 * @return a new {@link InputTransformerProperty} object, initialized with the values set on this builder.
                 */
                InputTransformerProperty build();
                /**
                 * ``RuleResource.InputTransformerProperty.InputPathsMap``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
                 */
                Build withInputPathsMap(final software.amazon.awscdk.Token value);
                /**
                 * ``RuleResource.InputTransformerProperty.InputPathsMap``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
                 */
                Build withInputPathsMap(final java.util.Map<java.lang.String, java.lang.Object> value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``RuleResource.InputTransformerProperty.InputPathsMap``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
                 */
                public Build withInputPathsMap(final software.amazon.awscdk.Token value) {
                    this.instance._inputPathsMap = value;
                    return this;
                }
                /**
                 * ``RuleResource.InputTransformerProperty.InputPathsMap``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
                 */
                public Build withInputPathsMap(final java.util.Map<java.lang.String, java.lang.Object> value) {
                    this.instance._inputPathsMap = value;
                    return this;
                }
                /**
                 * ``RuleResource.InputTransformerProperty.InputTemplate``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate
                 */
                public Build withInputTemplate(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "InputTransformerProperty#inputTemplate is required");
                    this.instance._inputTemplate = value;
                    return this;
                }
                /**
                 * ``RuleResource.InputTransformerProperty.InputTemplate``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate
                 */
                public Build withInputTemplate(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "InputTransformerProperty#inputTemplate is required");
                    this.instance._inputTemplate = value;
                    return this;
                }
                public InputTransformerProperty build() {
                    InputTransformerProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link InputTransformerProperty}.
         */
        final class Jsii$Pojo implements InputTransformerProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _inputPathsMap;

            public java.lang.Object getInputPathsMap() {
                return this._inputPathsMap;
            }
            public void setInputPathsMap(final software.amazon.awscdk.Token value) {
                this._inputPathsMap = value;
            }
            public void setInputPathsMap(final java.util.Map<java.lang.String, java.lang.Object> value) {
                this._inputPathsMap = value;
            }

            protected java.lang.Object _inputTemplate;

            public java.lang.Object getInputTemplate() {
                return this._inputTemplate;
            }
            public void setInputTemplate(final java.lang.String value) {
                this._inputTemplate = value;
            }
            public void setInputTemplate(final software.amazon.awscdk.Token value) {
                this._inputTemplate = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.cloudformation.RuleResource.InputTransformerProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``RuleResource.InputTransformerProperty.InputPathsMap``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
             */
            @javax.annotation.Nullable
            public java.lang.Object getInputPathsMap() {
                return this.jsiiGet("inputPathsMap", java.lang.Object.class);
            }
            /**
             * ``RuleResource.InputTransformerProperty.InputPathsMap``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
             */
            public void setInputPathsMap(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("inputPathsMap", value);
            }
            /**
             * ``RuleResource.InputTransformerProperty.InputPathsMap``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
             */
            public void setInputPathsMap(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.jsiiSet("inputPathsMap", value);
            }
            /**
             * ``RuleResource.InputTransformerProperty.InputTemplate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate
             */
            public java.lang.Object getInputTemplate() {
                return this.jsiiGet("inputTemplate", java.lang.Object.class);
            }
            /**
             * ``RuleResource.InputTransformerProperty.InputTemplate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate
             */
            public void setInputTemplate(final java.lang.String value) {
                this.jsiiSet("inputTemplate", java.util.Objects.requireNonNull(value, "inputTemplate is required"));
            }
            /**
             * ``RuleResource.InputTransformerProperty.InputTemplate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate
             */
            public void setInputTemplate(final software.amazon.awscdk.Token value) {
                this.jsiiSet("inputTemplate", java.util.Objects.requireNonNull(value, "inputTemplate is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html
     */
    public static interface KinesisParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``RuleResource.KinesisParametersProperty.PartitionKeyPath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath
         */
        java.lang.Object getPartitionKeyPath();
        /**
         * ``RuleResource.KinesisParametersProperty.PartitionKeyPath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath
         */
        void setPartitionKeyPath(final java.lang.String value);
        /**
         * ``RuleResource.KinesisParametersProperty.PartitionKeyPath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath
         */
        void setPartitionKeyPath(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link KinesisParametersProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``RuleResource.KinesisParametersProperty.PartitionKeyPath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath
             */
            public Build withPartitionKeyPath(final java.lang.String value) {
                return new FullBuilder().withPartitionKeyPath(value);
            }
            /**
             * ``RuleResource.KinesisParametersProperty.PartitionKeyPath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath
             */
            public Build withPartitionKeyPath(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withPartitionKeyPath(value);
            }

            public interface Build {
                /**
                 * @return a new {@link KinesisParametersProperty} object, initialized with the values set on this builder.
                 */
                KinesisParametersProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``RuleResource.KinesisParametersProperty.PartitionKeyPath``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath
                 */
                public Build withPartitionKeyPath(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "KinesisParametersProperty#partitionKeyPath is required");
                    this.instance._partitionKeyPath = value;
                    return this;
                }
                /**
                 * ``RuleResource.KinesisParametersProperty.PartitionKeyPath``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath
                 */
                public Build withPartitionKeyPath(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "KinesisParametersProperty#partitionKeyPath is required");
                    this.instance._partitionKeyPath = value;
                    return this;
                }
                public KinesisParametersProperty build() {
                    KinesisParametersProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link KinesisParametersProperty}.
         */
        final class Jsii$Pojo implements KinesisParametersProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _partitionKeyPath;

            public java.lang.Object getPartitionKeyPath() {
                return this._partitionKeyPath;
            }
            public void setPartitionKeyPath(final java.lang.String value) {
                this._partitionKeyPath = value;
            }
            public void setPartitionKeyPath(final software.amazon.awscdk.Token value) {
                this._partitionKeyPath = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``RuleResource.KinesisParametersProperty.PartitionKeyPath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath
             */
            public java.lang.Object getPartitionKeyPath() {
                return this.jsiiGet("partitionKeyPath", java.lang.Object.class);
            }
            /**
             * ``RuleResource.KinesisParametersProperty.PartitionKeyPath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath
             */
            public void setPartitionKeyPath(final java.lang.String value) {
                this.jsiiSet("partitionKeyPath", java.util.Objects.requireNonNull(value, "partitionKeyPath is required"));
            }
            /**
             * ``RuleResource.KinesisParametersProperty.PartitionKeyPath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath
             */
            public void setPartitionKeyPath(final software.amazon.awscdk.Token value) {
                this.jsiiSet("partitionKeyPath", java.util.Objects.requireNonNull(value, "partitionKeyPath is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html
     */
    public static interface RunCommandParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``RuleResource.RunCommandParametersProperty.RunCommandTargets``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
         */
        java.lang.Object getRunCommandTargets();
        /**
         * ``RuleResource.RunCommandParametersProperty.RunCommandTargets``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
         */
        void setRunCommandTargets(final software.amazon.awscdk.Token value);
        /**
         * ``RuleResource.RunCommandParametersProperty.RunCommandTargets``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
         */
        void setRunCommandTargets(final java.util.List<java.lang.Object> value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link RunCommandParametersProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``RuleResource.RunCommandParametersProperty.RunCommandTargets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
             */
            public Build withRunCommandTargets(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withRunCommandTargets(value);
            }
            /**
             * ``RuleResource.RunCommandParametersProperty.RunCommandTargets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
             */
            public Build withRunCommandTargets(final java.util.List<java.lang.Object> value) {
                return new FullBuilder().withRunCommandTargets(value);
            }

            public interface Build {
                /**
                 * @return a new {@link RunCommandParametersProperty} object, initialized with the values set on this builder.
                 */
                RunCommandParametersProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``RuleResource.RunCommandParametersProperty.RunCommandTargets``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
                 */
                public Build withRunCommandTargets(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "RunCommandParametersProperty#runCommandTargets is required");
                    this.instance._runCommandTargets = value;
                    return this;
                }
                /**
                 * ``RuleResource.RunCommandParametersProperty.RunCommandTargets``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
                 */
                public Build withRunCommandTargets(final java.util.List<java.lang.Object> value) {
                    java.util.Objects.requireNonNull(value, "RunCommandParametersProperty#runCommandTargets is required");
                    this.instance._runCommandTargets = value;
                    return this;
                }
                public RunCommandParametersProperty build() {
                    RunCommandParametersProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link RunCommandParametersProperty}.
         */
        final class Jsii$Pojo implements RunCommandParametersProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _runCommandTargets;

            public java.lang.Object getRunCommandTargets() {
                return this._runCommandTargets;
            }
            public void setRunCommandTargets(final software.amazon.awscdk.Token value) {
                this._runCommandTargets = value;
            }
            public void setRunCommandTargets(final java.util.List<java.lang.Object> value) {
                this._runCommandTargets = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``RuleResource.RunCommandParametersProperty.RunCommandTargets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
             */
            public java.lang.Object getRunCommandTargets() {
                return this.jsiiGet("runCommandTargets", java.lang.Object.class);
            }
            /**
             * ``RuleResource.RunCommandParametersProperty.RunCommandTargets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
             */
            public void setRunCommandTargets(final software.amazon.awscdk.Token value) {
                this.jsiiSet("runCommandTargets", java.util.Objects.requireNonNull(value, "runCommandTargets is required"));
            }
            /**
             * ``RuleResource.RunCommandParametersProperty.RunCommandTargets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
             */
            public void setRunCommandTargets(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("runCommandTargets", java.util.Objects.requireNonNull(value, "runCommandTargets is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html
     */
    public static interface RunCommandTargetProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``RuleResource.RunCommandTargetProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key
         */
        java.lang.Object getKey();
        /**
         * ``RuleResource.RunCommandTargetProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``RuleResource.RunCommandTargetProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key
         */
        void setKey(final software.amazon.awscdk.Token value);
        /**
         * ``RuleResource.RunCommandTargetProperty.Values``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
         */
        java.lang.Object getValues();
        /**
         * ``RuleResource.RunCommandTargetProperty.Values``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
         */
        void setValues(final software.amazon.awscdk.Token value);
        /**
         * ``RuleResource.RunCommandTargetProperty.Values``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
         */
        void setValues(final java.util.List<java.lang.Object> value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link RunCommandTargetProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``RuleResource.RunCommandTargetProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key
             */
            public ValuesStep withKey(final java.lang.String value) {
                return new FullBuilder().withKey(value);
            }
            /**
             * ``RuleResource.RunCommandTargetProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key
             */
            public ValuesStep withKey(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withKey(value);
            }

            public interface ValuesStep {
                /**
                 * ``RuleResource.RunCommandTargetProperty.Values``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
                 */
                Build withValues(final software.amazon.awscdk.Token value);
                /**
                 * ``RuleResource.RunCommandTargetProperty.Values``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
                 */
                Build withValues(final java.util.List<java.lang.Object> value);
            }

            public interface Build {
                /**
                 * @return a new {@link RunCommandTargetProperty} object, initialized with the values set on this builder.
                 */
                RunCommandTargetProperty build();
            }

            final class FullBuilder implements ValuesStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``RuleResource.RunCommandTargetProperty.Key``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key
                 */
                public ValuesStep withKey(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "RunCommandTargetProperty#key is required");
                    this.instance._key = value;
                    return this;
                }
                /**
                 * ``RuleResource.RunCommandTargetProperty.Key``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key
                 */
                public ValuesStep withKey(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "RunCommandTargetProperty#key is required");
                    this.instance._key = value;
                    return this;
                }
                /**
                 * ``RuleResource.RunCommandTargetProperty.Values``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
                 */
                public Build withValues(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "RunCommandTargetProperty#values is required");
                    this.instance._values = value;
                    return this;
                }
                /**
                 * ``RuleResource.RunCommandTargetProperty.Values``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
                 */
                public Build withValues(final java.util.List<java.lang.Object> value) {
                    java.util.Objects.requireNonNull(value, "RunCommandTargetProperty#values is required");
                    this.instance._values = value;
                    return this;
                }
                public RunCommandTargetProperty build() {
                    RunCommandTargetProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link RunCommandTargetProperty}.
         */
        final class Jsii$Pojo implements RunCommandTargetProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _key;

            public java.lang.Object getKey() {
                return this._key;
            }
            public void setKey(final java.lang.String value) {
                this._key = value;
            }
            public void setKey(final software.amazon.awscdk.Token value) {
                this._key = value;
            }

            protected java.lang.Object _values;

            public java.lang.Object getValues() {
                return this._values;
            }
            public void setValues(final software.amazon.awscdk.Token value) {
                this._values = value;
            }
            public void setValues(final java.util.List<java.lang.Object> value) {
                this._values = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandTargetProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``RuleResource.RunCommandTargetProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key
             */
            public java.lang.Object getKey() {
                return this.jsiiGet("key", java.lang.Object.class);
            }
            /**
             * ``RuleResource.RunCommandTargetProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key
             */
            public void setKey(final java.lang.String value) {
                this.jsiiSet("key", java.util.Objects.requireNonNull(value, "key is required"));
            }
            /**
             * ``RuleResource.RunCommandTargetProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key
             */
            public void setKey(final software.amazon.awscdk.Token value) {
                this.jsiiSet("key", java.util.Objects.requireNonNull(value, "key is required"));
            }
            /**
             * ``RuleResource.RunCommandTargetProperty.Values``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
             */
            public java.lang.Object getValues() {
                return this.jsiiGet("values", java.lang.Object.class);
            }
            /**
             * ``RuleResource.RunCommandTargetProperty.Values``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
             */
            public void setValues(final software.amazon.awscdk.Token value) {
                this.jsiiSet("values", java.util.Objects.requireNonNull(value, "values is required"));
            }
            /**
             * ``RuleResource.RunCommandTargetProperty.Values``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
             */
            public void setValues(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("values", java.util.Objects.requireNonNull(value, "values is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html
     */
    public static interface TargetProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``RuleResource.TargetProperty.Arn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn
         */
        java.lang.Object getArn();
        /**
         * ``RuleResource.TargetProperty.Arn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn
         */
        void setArn(final java.lang.String value);
        /**
         * ``RuleResource.TargetProperty.Arn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn
         */
        void setArn(final software.amazon.awscdk.Token value);
        /**
         * ``RuleResource.TargetProperty.EcsParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
         */
        java.lang.Object getEcsParameters();
        /**
         * ``RuleResource.TargetProperty.EcsParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
         */
        void setEcsParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty value);
        /**
         * ``RuleResource.TargetProperty.EcsParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
         */
        void setEcsParameters(final software.amazon.awscdk.Token value);
        /**
         * ``RuleResource.TargetProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id
         */
        java.lang.Object getId();
        /**
         * ``RuleResource.TargetProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id
         */
        void setId(final java.lang.String value);
        /**
         * ``RuleResource.TargetProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id
         */
        void setId(final software.amazon.awscdk.Token value);
        /**
         * ``RuleResource.TargetProperty.Input``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input
         */
        java.lang.Object getInput();
        /**
         * ``RuleResource.TargetProperty.Input``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input
         */
        void setInput(final java.lang.String value);
        /**
         * ``RuleResource.TargetProperty.Input``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input
         */
        void setInput(final software.amazon.awscdk.Token value);
        /**
         * ``RuleResource.TargetProperty.InputPath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath
         */
        java.lang.Object getInputPath();
        /**
         * ``RuleResource.TargetProperty.InputPath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath
         */
        void setInputPath(final java.lang.String value);
        /**
         * ``RuleResource.TargetProperty.InputPath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath
         */
        void setInputPath(final software.amazon.awscdk.Token value);
        /**
         * ``RuleResource.TargetProperty.InputTransformer``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
         */
        java.lang.Object getInputTransformer();
        /**
         * ``RuleResource.TargetProperty.InputTransformer``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
         */
        void setInputTransformer(final software.amazon.awscdk.Token value);
        /**
         * ``RuleResource.TargetProperty.InputTransformer``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
         */
        void setInputTransformer(final software.amazon.awscdk.services.events.cloudformation.RuleResource.InputTransformerProperty value);
        /**
         * ``RuleResource.TargetProperty.KinesisParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
         */
        java.lang.Object getKinesisParameters();
        /**
         * ``RuleResource.TargetProperty.KinesisParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
         */
        void setKinesisParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty value);
        /**
         * ``RuleResource.TargetProperty.KinesisParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
         */
        void setKinesisParameters(final software.amazon.awscdk.Token value);
        /**
         * ``RuleResource.TargetProperty.RoleArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn
         */
        java.lang.Object getRoleArn();
        /**
         * ``RuleResource.TargetProperty.RoleArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn
         */
        void setRoleArn(final java.lang.String value);
        /**
         * ``RuleResource.TargetProperty.RoleArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn
         */
        void setRoleArn(final software.amazon.awscdk.Token value);
        /**
         * ``RuleResource.TargetProperty.RunCommandParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
         */
        java.lang.Object getRunCommandParameters();
        /**
         * ``RuleResource.TargetProperty.RunCommandParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
         */
        void setRunCommandParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty value);
        /**
         * ``RuleResource.TargetProperty.RunCommandParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
         */
        void setRunCommandParameters(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link TargetProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``RuleResource.TargetProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn
             */
            public IdStep withArn(final java.lang.String value) {
                return new FullBuilder().withArn(value);
            }
            /**
             * ``RuleResource.TargetProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn
             */
            public IdStep withArn(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withArn(value);
            }

            public interface IdStep {
                /**
                 * ``RuleResource.TargetProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id
                 */
                Build withId(final java.lang.String value);
                /**
                 * ``RuleResource.TargetProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id
                 */
                Build withId(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link TargetProperty} object, initialized with the values set on this builder.
                 */
                TargetProperty build();
                /**
                 * ``RuleResource.TargetProperty.EcsParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
                 */
                Build withEcsParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty value);
                /**
                 * ``RuleResource.TargetProperty.EcsParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
                 */
                Build withEcsParameters(final software.amazon.awscdk.Token value);
                /**
                 * ``RuleResource.TargetProperty.Input``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input
                 */
                Build withInput(final java.lang.String value);
                /**
                 * ``RuleResource.TargetProperty.Input``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input
                 */
                Build withInput(final software.amazon.awscdk.Token value);
                /**
                 * ``RuleResource.TargetProperty.InputPath``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath
                 */
                Build withInputPath(final java.lang.String value);
                /**
                 * ``RuleResource.TargetProperty.InputPath``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath
                 */
                Build withInputPath(final software.amazon.awscdk.Token value);
                /**
                 * ``RuleResource.TargetProperty.InputTransformer``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
                 */
                Build withInputTransformer(final software.amazon.awscdk.Token value);
                /**
                 * ``RuleResource.TargetProperty.InputTransformer``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
                 */
                Build withInputTransformer(final software.amazon.awscdk.services.events.cloudformation.RuleResource.InputTransformerProperty value);
                /**
                 * ``RuleResource.TargetProperty.KinesisParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
                 */
                Build withKinesisParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty value);
                /**
                 * ``RuleResource.TargetProperty.KinesisParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
                 */
                Build withKinesisParameters(final software.amazon.awscdk.Token value);
                /**
                 * ``RuleResource.TargetProperty.RoleArn``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn
                 */
                Build withRoleArn(final java.lang.String value);
                /**
                 * ``RuleResource.TargetProperty.RoleArn``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn
                 */
                Build withRoleArn(final software.amazon.awscdk.Token value);
                /**
                 * ``RuleResource.TargetProperty.RunCommandParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
                 */
                Build withRunCommandParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty value);
                /**
                 * ``RuleResource.TargetProperty.RunCommandParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
                 */
                Build withRunCommandParameters(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements IdStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``RuleResource.TargetProperty.Arn``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn
                 */
                public IdStep withArn(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "TargetProperty#arn is required");
                    this.instance._arn = value;
                    return this;
                }
                /**
                 * ``RuleResource.TargetProperty.Arn``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn
                 */
                public IdStep withArn(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "TargetProperty#arn is required");
                    this.instance._arn = value;
                    return this;
                }
                /**
                 * ``RuleResource.TargetProperty.EcsParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
                 */
                public Build withEcsParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty value) {
                    this.instance._ecsParameters = value;
                    return this;
                }
                /**
                 * ``RuleResource.TargetProperty.EcsParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
                 */
                public Build withEcsParameters(final software.amazon.awscdk.Token value) {
                    this.instance._ecsParameters = value;
                    return this;
                }
                /**
                 * ``RuleResource.TargetProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id
                 */
                public Build withId(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "TargetProperty#id is required");
                    this.instance._id = value;
                    return this;
                }
                /**
                 * ``RuleResource.TargetProperty.Id``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id
                 */
                public Build withId(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "TargetProperty#id is required");
                    this.instance._id = value;
                    return this;
                }
                /**
                 * ``RuleResource.TargetProperty.Input``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input
                 */
                public Build withInput(final java.lang.String value) {
                    this.instance._input = value;
                    return this;
                }
                /**
                 * ``RuleResource.TargetProperty.Input``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input
                 */
                public Build withInput(final software.amazon.awscdk.Token value) {
                    this.instance._input = value;
                    return this;
                }
                /**
                 * ``RuleResource.TargetProperty.InputPath``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath
                 */
                public Build withInputPath(final java.lang.String value) {
                    this.instance._inputPath = value;
                    return this;
                }
                /**
                 * ``RuleResource.TargetProperty.InputPath``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath
                 */
                public Build withInputPath(final software.amazon.awscdk.Token value) {
                    this.instance._inputPath = value;
                    return this;
                }
                /**
                 * ``RuleResource.TargetProperty.InputTransformer``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
                 */
                public Build withInputTransformer(final software.amazon.awscdk.Token value) {
                    this.instance._inputTransformer = value;
                    return this;
                }
                /**
                 * ``RuleResource.TargetProperty.InputTransformer``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
                 */
                public Build withInputTransformer(final software.amazon.awscdk.services.events.cloudformation.RuleResource.InputTransformerProperty value) {
                    this.instance._inputTransformer = value;
                    return this;
                }
                /**
                 * ``RuleResource.TargetProperty.KinesisParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
                 */
                public Build withKinesisParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty value) {
                    this.instance._kinesisParameters = value;
                    return this;
                }
                /**
                 * ``RuleResource.TargetProperty.KinesisParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
                 */
                public Build withKinesisParameters(final software.amazon.awscdk.Token value) {
                    this.instance._kinesisParameters = value;
                    return this;
                }
                /**
                 * ``RuleResource.TargetProperty.RoleArn``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn
                 */
                public Build withRoleArn(final java.lang.String value) {
                    this.instance._roleArn = value;
                    return this;
                }
                /**
                 * ``RuleResource.TargetProperty.RoleArn``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn
                 */
                public Build withRoleArn(final software.amazon.awscdk.Token value) {
                    this.instance._roleArn = value;
                    return this;
                }
                /**
                 * ``RuleResource.TargetProperty.RunCommandParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
                 */
                public Build withRunCommandParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty value) {
                    this.instance._runCommandParameters = value;
                    return this;
                }
                /**
                 * ``RuleResource.TargetProperty.RunCommandParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
                 */
                public Build withRunCommandParameters(final software.amazon.awscdk.Token value) {
                    this.instance._runCommandParameters = value;
                    return this;
                }
                public TargetProperty build() {
                    TargetProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link TargetProperty}.
         */
        final class Jsii$Pojo implements TargetProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _arn;

            public java.lang.Object getArn() {
                return this._arn;
            }
            public void setArn(final java.lang.String value) {
                this._arn = value;
            }
            public void setArn(final software.amazon.awscdk.Token value) {
                this._arn = value;
            }

            protected java.lang.Object _ecsParameters;

            public java.lang.Object getEcsParameters() {
                return this._ecsParameters;
            }
            public void setEcsParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty value) {
                this._ecsParameters = value;
            }
            public void setEcsParameters(final software.amazon.awscdk.Token value) {
                this._ecsParameters = value;
            }

            protected java.lang.Object _id;

            public java.lang.Object getId() {
                return this._id;
            }
            public void setId(final java.lang.String value) {
                this._id = value;
            }
            public void setId(final software.amazon.awscdk.Token value) {
                this._id = value;
            }

            protected java.lang.Object _input;

            public java.lang.Object getInput() {
                return this._input;
            }
            public void setInput(final java.lang.String value) {
                this._input = value;
            }
            public void setInput(final software.amazon.awscdk.Token value) {
                this._input = value;
            }

            protected java.lang.Object _inputPath;

            public java.lang.Object getInputPath() {
                return this._inputPath;
            }
            public void setInputPath(final java.lang.String value) {
                this._inputPath = value;
            }
            public void setInputPath(final software.amazon.awscdk.Token value) {
                this._inputPath = value;
            }

            protected java.lang.Object _inputTransformer;

            public java.lang.Object getInputTransformer() {
                return this._inputTransformer;
            }
            public void setInputTransformer(final software.amazon.awscdk.Token value) {
                this._inputTransformer = value;
            }
            public void setInputTransformer(final software.amazon.awscdk.services.events.cloudformation.RuleResource.InputTransformerProperty value) {
                this._inputTransformer = value;
            }

            protected java.lang.Object _kinesisParameters;

            public java.lang.Object getKinesisParameters() {
                return this._kinesisParameters;
            }
            public void setKinesisParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty value) {
                this._kinesisParameters = value;
            }
            public void setKinesisParameters(final software.amazon.awscdk.Token value) {
                this._kinesisParameters = value;
            }

            protected java.lang.Object _roleArn;

            public java.lang.Object getRoleArn() {
                return this._roleArn;
            }
            public void setRoleArn(final java.lang.String value) {
                this._roleArn = value;
            }
            public void setRoleArn(final software.amazon.awscdk.Token value) {
                this._roleArn = value;
            }

            protected java.lang.Object _runCommandParameters;

            public java.lang.Object getRunCommandParameters() {
                return this._runCommandParameters;
            }
            public void setRunCommandParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty value) {
                this._runCommandParameters = value;
            }
            public void setRunCommandParameters(final software.amazon.awscdk.Token value) {
                this._runCommandParameters = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.cloudformation.RuleResource.TargetProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``RuleResource.TargetProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn
             */
            public java.lang.Object getArn() {
                return this.jsiiGet("arn", java.lang.Object.class);
            }
            /**
             * ``RuleResource.TargetProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn
             */
            public void setArn(final java.lang.String value) {
                this.jsiiSet("arn", java.util.Objects.requireNonNull(value, "arn is required"));
            }
            /**
             * ``RuleResource.TargetProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn
             */
            public void setArn(final software.amazon.awscdk.Token value) {
                this.jsiiSet("arn", java.util.Objects.requireNonNull(value, "arn is required"));
            }
            /**
             * ``RuleResource.TargetProperty.EcsParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
             */
            @javax.annotation.Nullable
            public java.lang.Object getEcsParameters() {
                return this.jsiiGet("ecsParameters", java.lang.Object.class);
            }
            /**
             * ``RuleResource.TargetProperty.EcsParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
             */
            public void setEcsParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty value) {
                this.jsiiSet("ecsParameters", value);
            }
            /**
             * ``RuleResource.TargetProperty.EcsParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
             */
            public void setEcsParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ecsParameters", value);
            }
            /**
             * ``RuleResource.TargetProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id
             */
            public java.lang.Object getId() {
                return this.jsiiGet("id", java.lang.Object.class);
            }
            /**
             * ``RuleResource.TargetProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id
             */
            public void setId(final java.lang.String value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }
            /**
             * ``RuleResource.TargetProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id
             */
            public void setId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }
            /**
             * ``RuleResource.TargetProperty.Input``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input
             */
            @javax.annotation.Nullable
            public java.lang.Object getInput() {
                return this.jsiiGet("input", java.lang.Object.class);
            }
            /**
             * ``RuleResource.TargetProperty.Input``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input
             */
            public void setInput(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("input", value);
            }
            /**
             * ``RuleResource.TargetProperty.Input``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input
             */
            public void setInput(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("input", value);
            }
            /**
             * ``RuleResource.TargetProperty.InputPath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath
             */
            @javax.annotation.Nullable
            public java.lang.Object getInputPath() {
                return this.jsiiGet("inputPath", java.lang.Object.class);
            }
            /**
             * ``RuleResource.TargetProperty.InputPath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath
             */
            public void setInputPath(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("inputPath", value);
            }
            /**
             * ``RuleResource.TargetProperty.InputPath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath
             */
            public void setInputPath(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("inputPath", value);
            }
            /**
             * ``RuleResource.TargetProperty.InputTransformer``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
             */
            @javax.annotation.Nullable
            public java.lang.Object getInputTransformer() {
                return this.jsiiGet("inputTransformer", java.lang.Object.class);
            }
            /**
             * ``RuleResource.TargetProperty.InputTransformer``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
             */
            public void setInputTransformer(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("inputTransformer", value);
            }
            /**
             * ``RuleResource.TargetProperty.InputTransformer``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
             */
            public void setInputTransformer(@javax.annotation.Nullable final software.amazon.awscdk.services.events.cloudformation.RuleResource.InputTransformerProperty value) {
                this.jsiiSet("inputTransformer", value);
            }
            /**
             * ``RuleResource.TargetProperty.KinesisParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
             */
            @javax.annotation.Nullable
            public java.lang.Object getKinesisParameters() {
                return this.jsiiGet("kinesisParameters", java.lang.Object.class);
            }
            /**
             * ``RuleResource.TargetProperty.KinesisParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
             */
            public void setKinesisParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty value) {
                this.jsiiSet("kinesisParameters", value);
            }
            /**
             * ``RuleResource.TargetProperty.KinesisParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
             */
            public void setKinesisParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("kinesisParameters", value);
            }
            /**
             * ``RuleResource.TargetProperty.RoleArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn
             */
            @javax.annotation.Nullable
            public java.lang.Object getRoleArn() {
                return this.jsiiGet("roleArn", java.lang.Object.class);
            }
            /**
             * ``RuleResource.TargetProperty.RoleArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn
             */
            public void setRoleArn(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("roleArn", value);
            }
            /**
             * ``RuleResource.TargetProperty.RoleArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn
             */
            public void setRoleArn(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("roleArn", value);
            }
            /**
             * ``RuleResource.TargetProperty.RunCommandParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
             */
            @javax.annotation.Nullable
            public java.lang.Object getRunCommandParameters() {
                return this.jsiiGet("runCommandParameters", java.lang.Object.class);
            }
            /**
             * ``RuleResource.TargetProperty.RunCommandParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
             */
            public void setRunCommandParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty value) {
                this.jsiiSet("runCommandParameters", value);
            }
            /**
             * ``RuleResource.TargetProperty.RunCommandParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
             */
            public void setRunCommandParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("runCommandParameters", value);
            }
        }
    }
}
