package software.amazon.awscdk.services.events;
public interface EventRuleTargetProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * A unique, user-defined identifier for the target. Acceptable values
     * include alphanumeric characters, periods (.), hyphens (-), and
     * underscores (_).
     */
    java.lang.String getId();
    /**
     * A unique, user-defined identifier for the target. Acceptable values
     * include alphanumeric characters, periods (.), hyphens (-), and
     * underscores (_).
     */
    void setId(final java.lang.String value);
    /**
     * The Amazon Resource Name (ARN) of the target.
     */
    software.amazon.awscdk.Arn getArn();
    /**
     * The Amazon Resource Name (ARN) of the target.
     */
    void setArn(final software.amazon.awscdk.Arn value);
    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management
     * (IAM) role to use for this target when the rule is triggered. If one rule
     * triggers multiple targets, you can use a different IAM role for each
     * target.
     */
    software.amazon.awscdk.services.iam.RoleArn getRoleArn();
    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management
     * (IAM) role to use for this target when the rule is triggered. If one rule
     * triggers multiple targets, you can use a different IAM role for each
     * target.
     */
    void setRoleArn(final software.amazon.awscdk.services.iam.RoleArn value);
    /**
     * The Amazon ECS task definition and task count to use, if the event target
     * is an Amazon ECS task.
     */
    software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty getEcsParameters();
    /**
     * The Amazon ECS task definition and task count to use, if the event target
     * is an Amazon ECS task.
     */
    void setEcsParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty value);
    /**
     * Settings that control shard assignment, when the target is a Kinesis
     * stream. If you don't include this parameter, eventId is used as the
     * partition key.
     */
    software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty getKinesisParameters();
    /**
     * Settings that control shard assignment, when the target is a Kinesis
     * stream. If you don't include this parameter, eventId is used as the
     * partition key.
     */
    void setKinesisParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty value);
    /**
     * Parameters used when the rule invokes Amazon EC2 Systems Manager Run
     * Command.
     */
    software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty getRunCommandParameters();
    /**
     * Parameters used when the rule invokes Amazon EC2 Systems Manager Run
     * Command.
     */
    void setRunCommandParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link EventRuleTargetProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * A unique, user-defined identifier for the target. Acceptable values
         * include alphanumeric characters, periods (.), hyphens (-), and
         * underscores (_).
         */
        public ArnStep withId(final java.lang.String value) {
            return new FullBuilder().withId(value);
        }

        public interface ArnStep {
            /**
             * The Amazon Resource Name (ARN) of the target.
             */
            Build withArn(final software.amazon.awscdk.Arn value);
        }

        public interface Build {
            /**
             * @return a new {@link EventRuleTargetProps} object, initialized with the values set on this builder.
             */
            EventRuleTargetProps build();
            /**
             * The Amazon Resource Name (ARN) of the AWS Identity and Access Management
             * (IAM) role to use for this target when the rule is triggered. If one rule
             * triggers multiple targets, you can use a different IAM role for each
             * target.
             */
            Build withRoleArn(final software.amazon.awscdk.services.iam.RoleArn value);
            /**
             * The Amazon ECS task definition and task count to use, if the event target
             * is an Amazon ECS task.
             */
            Build withEcsParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty value);
            /**
             * Settings that control shard assignment, when the target is a Kinesis
             * stream. If you don't include this parameter, eventId is used as the
             * partition key.
             */
            Build withKinesisParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty value);
            /**
             * Parameters used when the rule invokes Amazon EC2 Systems Manager Run
             * Command.
             */
            Build withRunCommandParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty value);
        }

        final class FullBuilder implements ArnStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * A unique, user-defined identifier for the target. Acceptable values
             * include alphanumeric characters, periods (.), hyphens (-), and
             * underscores (_).
             */
            public ArnStep withId(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "EventRuleTargetProps#id is required");
                this.instance._id = value;
                return this;
            }
            /**
             * The Amazon Resource Name (ARN) of the target.
             */
            public Build withArn(final software.amazon.awscdk.Arn value) {
                java.util.Objects.requireNonNull(value, "EventRuleTargetProps#arn is required");
                this.instance._arn = value;
                return this;
            }
            /**
             * The Amazon Resource Name (ARN) of the AWS Identity and Access Management
             * (IAM) role to use for this target when the rule is triggered. If one rule
             * triggers multiple targets, you can use a different IAM role for each
             * target.
             */
            public Build withRoleArn(final software.amazon.awscdk.services.iam.RoleArn value) {
                this.instance._roleArn = value;
                return this;
            }
            /**
             * The Amazon ECS task definition and task count to use, if the event target
             * is an Amazon ECS task.
             */
            public Build withEcsParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty value) {
                this.instance._ecsParameters = value;
                return this;
            }
            /**
             * Settings that control shard assignment, when the target is a Kinesis
             * stream. If you don't include this parameter, eventId is used as the
             * partition key.
             */
            public Build withKinesisParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty value) {
                this.instance._kinesisParameters = value;
                return this;
            }
            /**
             * Parameters used when the rule invokes Amazon EC2 Systems Manager Run
             * Command.
             */
            public Build withRunCommandParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty value) {
                this.instance._runCommandParameters = value;
                return this;
            }
            public EventRuleTargetProps build() {
                EventRuleTargetProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link EventRuleTargetProps}.
     */
    final class Jsii$Pojo implements EventRuleTargetProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.String _id;

        public java.lang.String getId() {
            return this._id;
        }
        public void setId(final java.lang.String value) {
            this._id = value;
        }

        protected software.amazon.awscdk.Arn _arn;

        public software.amazon.awscdk.Arn getArn() {
            return this._arn;
        }
        public void setArn(final software.amazon.awscdk.Arn value) {
            this._arn = value;
        }

        protected software.amazon.awscdk.services.iam.RoleArn _roleArn;

        public software.amazon.awscdk.services.iam.RoleArn getRoleArn() {
            return this._roleArn;
        }
        public void setRoleArn(final software.amazon.awscdk.services.iam.RoleArn value) {
            this._roleArn = value;
        }

        protected software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty _ecsParameters;

        public software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty getEcsParameters() {
            return this._ecsParameters;
        }
        public void setEcsParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty value) {
            this._ecsParameters = value;
        }

        protected software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty _kinesisParameters;

        public software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty getKinesisParameters() {
            return this._kinesisParameters;
        }
        public void setKinesisParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty value) {
            this._kinesisParameters = value;
        }

        protected software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty _runCommandParameters;

        public software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty getRunCommandParameters() {
            return this._runCommandParameters;
        }
        public void setRunCommandParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty value) {
            this._runCommandParameters = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.EventRuleTargetProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * A unique, user-defined identifier for the target. Acceptable values
         * include alphanumeric characters, periods (.), hyphens (-), and
         * underscores (_).
         */
        public java.lang.String getId() {
            return this.jsiiGet("id", java.lang.String.class);
        }
        /**
         * A unique, user-defined identifier for the target. Acceptable values
         * include alphanumeric characters, periods (.), hyphens (-), and
         * underscores (_).
         */
        public void setId(final java.lang.String value) {
            this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
        }
        /**
         * The Amazon Resource Name (ARN) of the target.
         */
        public software.amazon.awscdk.Arn getArn() {
            return this.jsiiGet("arn", software.amazon.awscdk.Arn.class);
        }
        /**
         * The Amazon Resource Name (ARN) of the target.
         */
        public void setArn(final software.amazon.awscdk.Arn value) {
            this.jsiiSet("arn", java.util.Objects.requireNonNull(value, "arn is required"));
        }
        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management
         * (IAM) role to use for this target when the rule is triggered. If one rule
         * triggers multiple targets, you can use a different IAM role for each
         * target.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.RoleArn getRoleArn() {
            return this.jsiiGet("roleArn", software.amazon.awscdk.services.iam.RoleArn.class);
        }
        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management
         * (IAM) role to use for this target when the rule is triggered. If one rule
         * triggers multiple targets, you can use a different IAM role for each
         * target.
         */
        public void setRoleArn(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.RoleArn value) {
            this.jsiiSet("roleArn", value);
        }
        /**
         * The Amazon ECS task definition and task count to use, if the event target
         * is an Amazon ECS task.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty getEcsParameters() {
            return this.jsiiGet("ecsParameters", software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty.class);
        }
        /**
         * The Amazon ECS task definition and task count to use, if the event target
         * is an Amazon ECS task.
         */
        public void setEcsParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty value) {
            this.jsiiSet("ecsParameters", value);
        }
        /**
         * Settings that control shard assignment, when the target is a Kinesis
         * stream. If you don't include this parameter, eventId is used as the
         * partition key.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty getKinesisParameters() {
            return this.jsiiGet("kinesisParameters", software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty.class);
        }
        /**
         * Settings that control shard assignment, when the target is a Kinesis
         * stream. If you don't include this parameter, eventId is used as the
         * partition key.
         */
        public void setKinesisParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty value) {
            this.jsiiSet("kinesisParameters", value);
        }
        /**
         * Parameters used when the rule invokes Amazon EC2 Systems Manager Run
         * Command.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty getRunCommandParameters() {
            return this.jsiiGet("runCommandParameters", software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty.class);
        }
        /**
         * Parameters used when the rule invokes Amazon EC2 Systems Manager Run
         * Command.
         */
        public void setRunCommandParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty value) {
            this.jsiiSet("runCommandParameters", value);
        }
    }
}
