package software.amazon.awscdk.services.events;
/**
 * Events in Amazon CloudWatch Events are represented as JSON objects. For more
 * information about JSON objects, see RFC 7159.
 * 
 * Rules use event patterns to select events and route them to targets. A
 * pattern either matches an event or it doesn't. Event patterns are represented
 * as JSON objects with a structure that is similar to that of events, for
 * example:
 * 
 * It is important to remember the following about event pattern matching:
 * 
 * - For a pattern to match an event, the event must contain all the field names
 *    listed in the pattern. The field names must appear in the event with the
 *    same nesting structure.
 * 
 * - Other fields of the event not mentioned in the pattern are ignored;
 *    effectively, there is a ``"*": "*"`` wildcard for fields not mentioned.
 * 
 * - The matching is exact (character-by-character), without case-folding or any
 *    other string normalization.
 * 
 * - The values being matched follow JSON rules: Strings enclosed in quotes,
 *    numbers, and the unquoted keywords true, false, and null.
 * 
 * - Number matching is at the string representation level. For example, 300,
 *    300.0, and 3.0e2 are not considered equal.
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html
 */
public interface EventPattern extends software.amazon.jsii.JsiiSerializable {
    /**
     * By default, this is set to 0 (zero) in all events.
     */
    java.util.List<java.lang.String> getVersion();
    /**
     * By default, this is set to 0 (zero) in all events.
     */
    void setVersion(final java.util.List<java.lang.String> value);
    /**
     * A unique value is generated for every event. This can be helpful in
     * tracing events as they move through rules to targets, and are processed.
     */
    java.util.List<java.lang.String> getId();
    /**
     * A unique value is generated for every event. This can be helpful in
     * tracing events as they move through rules to targets, and are processed.
     */
    void setId(final java.util.List<java.lang.String> value);
    /**
     * Identifies, in combination with the source field, the fields and values
     * that appear in the detail field.
     * 
     * Represents the "detail-type" event field.
     */
    java.util.List<java.lang.String> getDetailType();
    /**
     * Identifies, in combination with the source field, the fields and values
     * that appear in the detail field.
     * 
     * Represents the "detail-type" event field.
     */
    void setDetailType(final java.util.List<java.lang.String> value);
    /**
     * Identifies the service that sourced the event. All events sourced from
     * within AWS begin with "aws." Customer-generated events can have any value
     * here, as long as it doesn't begin with "aws." We recommend the use of
     * Java package-name style reverse domain-name strings.
     * 
     * To find the correct value for source for an AWS service, see the table in
     * AWS Service Namespaces. For example, the source value for Amazon
     * CloudFront is aws.cloudfront.
     * @see http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces
     */
    java.util.List<java.lang.String> getSource();
    /**
     * Identifies the service that sourced the event. All events sourced from
     * within AWS begin with "aws." Customer-generated events can have any value
     * here, as long as it doesn't begin with "aws." We recommend the use of
     * Java package-name style reverse domain-name strings.
     * 
     * To find the correct value for source for an AWS service, see the table in
     * AWS Service Namespaces. For example, the source value for Amazon
     * CloudFront is aws.cloudfront.
     * @see http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces
     */
    void setSource(final java.util.List<java.lang.String> value);
    /**
     * The 12-digit number identifying an AWS account.
     */
    java.util.List<java.lang.String> getAccount();
    /**
     * The 12-digit number identifying an AWS account.
     */
    void setAccount(final java.util.List<java.lang.String> value);
    /**
     * The event timestamp, which can be specified by the service originating
     * the event. If the event spans a time interval, the service might choose
     * to report the start time, so this value can be noticeably before the time
     * the event is actually received.
     */
    java.util.List<java.lang.String> getTime();
    /**
     * The event timestamp, which can be specified by the service originating
     * the event. If the event spans a time interval, the service might choose
     * to report the start time, so this value can be noticeably before the time
     * the event is actually received.
     */
    void setTime(final java.util.List<java.lang.String> value);
    /**
     * Identifies the AWS region where the event originated.
     */
    java.util.List<java.lang.String> getRegion();
    /**
     * Identifies the AWS region where the event originated.
     */
    void setRegion(final java.util.List<java.lang.String> value);
    /**
     * This JSON array contains ARNs that identify resources that are involved
     * in the event. Inclusion of these ARNs is at the discretion of the
     * service.
     * 
     * For example, Amazon EC2 instance state-changes include Amazon EC2
     * instance ARNs, Auto Scaling events include ARNs for both instances and
     * Auto Scaling groups, but API calls with AWS CloudTrail do not include
     * resource ARNs.
     */
    java.util.List<software.amazon.awscdk.Arn> getResources();
    /**
     * This JSON array contains ARNs that identify resources that are involved
     * in the event. Inclusion of these ARNs is at the discretion of the
     * service.
     * 
     * For example, Amazon EC2 instance state-changes include Amazon EC2
     * instance ARNs, Auto Scaling events include ARNs for both instances and
     * Auto Scaling groups, but API calls with AWS CloudTrail do not include
     * resource ARNs.
     */
    void setResources(final java.util.List<software.amazon.awscdk.Arn> value);
    /**
     * A JSON object, whose content is at the discretion of the service
     * originating the event.
     */
    java.lang.Object getDetail();
    /**
     * A JSON object, whose content is at the discretion of the service
     * originating the event.
     */
    void setDetail(final java.lang.Object value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }

    /**
     * A fluent builder class for {@link EventPattern}.
     */
    public static final class Builder {
        private Jsii$Pojo instance = new Jsii$Pojo();

        /**
         * By default, this is set to 0 (zero) in all events.
         */
        public Builder withVersion(final java.util.List<java.lang.String> value) {
            this.instance._version = value;
            return this;
        }
        /**
         * A unique value is generated for every event. This can be helpful in
         * tracing events as they move through rules to targets, and are processed.
         */
        public Builder withId(final java.util.List<java.lang.String> value) {
            this.instance._id = value;
            return this;
        }
        /**
         * Identifies, in combination with the source field, the fields and values
         * that appear in the detail field.
         * 
         * Represents the "detail-type" event field.
         */
        public Builder withDetailType(final java.util.List<java.lang.String> value) {
            this.instance._detailType = value;
            return this;
        }
        /**
         * Identifies the service that sourced the event. All events sourced from
         * within AWS begin with "aws." Customer-generated events can have any value
         * here, as long as it doesn't begin with "aws." We recommend the use of
         * Java package-name style reverse domain-name strings.
         * 
         * To find the correct value for source for an AWS service, see the table in
         * AWS Service Namespaces. For example, the source value for Amazon
         * CloudFront is aws.cloudfront.
         * @see http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces
         */
        public Builder withSource(final java.util.List<java.lang.String> value) {
            this.instance._source = value;
            return this;
        }
        /**
         * The 12-digit number identifying an AWS account.
         */
        public Builder withAccount(final java.util.List<java.lang.String> value) {
            this.instance._account = value;
            return this;
        }
        /**
         * The event timestamp, which can be specified by the service originating
         * the event. If the event spans a time interval, the service might choose
         * to report the start time, so this value can be noticeably before the time
         * the event is actually received.
         */
        public Builder withTime(final java.util.List<java.lang.String> value) {
            this.instance._time = value;
            return this;
        }
        /**
         * Identifies the AWS region where the event originated.
         */
        public Builder withRegion(final java.util.List<java.lang.String> value) {
            this.instance._region = value;
            return this;
        }
        /**
         * This JSON array contains ARNs that identify resources that are involved
         * in the event. Inclusion of these ARNs is at the discretion of the
         * service.
         * 
         * For example, Amazon EC2 instance state-changes include Amazon EC2
         * instance ARNs, Auto Scaling events include ARNs for both instances and
         * Auto Scaling groups, but API calls with AWS CloudTrail do not include
         * resource ARNs.
         */
        public Builder withResources(final java.util.List<software.amazon.awscdk.Arn> value) {
            this.instance._resources = value;
            return this;
        }
        /**
         * A JSON object, whose content is at the discretion of the service
         * originating the event.
         */
        public Builder withDetail(final java.lang.Object value) {
            this.instance._detail = value;
            return this;
        }
        public EventPattern build() {
            EventPattern result = this.instance;
            this.instance = new Jsii$Pojo();
            return result;
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link EventPattern}.
     */
    final class Jsii$Pojo implements EventPattern {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.util.List<java.lang.String> _version;

        public java.util.List<java.lang.String> getVersion() {
            return this._version;
        }
        public void setVersion(final java.util.List<java.lang.String> value) {
            this._version = value;
        }

        protected java.util.List<java.lang.String> _id;

        public java.util.List<java.lang.String> getId() {
            return this._id;
        }
        public void setId(final java.util.List<java.lang.String> value) {
            this._id = value;
        }

        protected java.util.List<java.lang.String> _detailType;

        public java.util.List<java.lang.String> getDetailType() {
            return this._detailType;
        }
        public void setDetailType(final java.util.List<java.lang.String> value) {
            this._detailType = value;
        }

        protected java.util.List<java.lang.String> _source;

        public java.util.List<java.lang.String> getSource() {
            return this._source;
        }
        public void setSource(final java.util.List<java.lang.String> value) {
            this._source = value;
        }

        protected java.util.List<java.lang.String> _account;

        public java.util.List<java.lang.String> getAccount() {
            return this._account;
        }
        public void setAccount(final java.util.List<java.lang.String> value) {
            this._account = value;
        }

        protected java.util.List<java.lang.String> _time;

        public java.util.List<java.lang.String> getTime() {
            return this._time;
        }
        public void setTime(final java.util.List<java.lang.String> value) {
            this._time = value;
        }

        protected java.util.List<java.lang.String> _region;

        public java.util.List<java.lang.String> getRegion() {
            return this._region;
        }
        public void setRegion(final java.util.List<java.lang.String> value) {
            this._region = value;
        }

        protected java.util.List<software.amazon.awscdk.Arn> _resources;

        public java.util.List<software.amazon.awscdk.Arn> getResources() {
            return this._resources;
        }
        public void setResources(final java.util.List<software.amazon.awscdk.Arn> value) {
            this._resources = value;
        }

        protected java.lang.Object _detail;

        public java.lang.Object getDetail() {
            return this._detail;
        }
        public void setDetail(final java.lang.Object value) {
            this._detail = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.EventPattern {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * By default, this is set to 0 (zero) in all events.
         */
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getVersion() {
            return this.jsiiGet("version", java.util.List.class);
        }
        /**
         * By default, this is set to 0 (zero) in all events.
         */
        public void setVersion(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("version", value);
        }
        /**
         * A unique value is generated for every event. This can be helpful in
         * tracing events as they move through rules to targets, and are processed.
         */
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getId() {
            return this.jsiiGet("id", java.util.List.class);
        }
        /**
         * A unique value is generated for every event. This can be helpful in
         * tracing events as they move through rules to targets, and are processed.
         */
        public void setId(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("id", value);
        }
        /**
         * Identifies, in combination with the source field, the fields and values
         * that appear in the detail field.
         * 
         * Represents the "detail-type" event field.
         */
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getDetailType() {
            return this.jsiiGet("detailType", java.util.List.class);
        }
        /**
         * Identifies, in combination with the source field, the fields and values
         * that appear in the detail field.
         * 
         * Represents the "detail-type" event field.
         */
        public void setDetailType(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("detailType", value);
        }
        /**
         * Identifies the service that sourced the event. All events sourced from
         * within AWS begin with "aws." Customer-generated events can have any value
         * here, as long as it doesn't begin with "aws." We recommend the use of
         * Java package-name style reverse domain-name strings.
         * 
         * To find the correct value for source for an AWS service, see the table in
         * AWS Service Namespaces. For example, the source value for Amazon
         * CloudFront is aws.cloudfront.
         * @see http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces
         */
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getSource() {
            return this.jsiiGet("source", java.util.List.class);
        }
        /**
         * Identifies the service that sourced the event. All events sourced from
         * within AWS begin with "aws." Customer-generated events can have any value
         * here, as long as it doesn't begin with "aws." We recommend the use of
         * Java package-name style reverse domain-name strings.
         * 
         * To find the correct value for source for an AWS service, see the table in
         * AWS Service Namespaces. For example, the source value for Amazon
         * CloudFront is aws.cloudfront.
         * @see http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces
         */
        public void setSource(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("source", value);
        }
        /**
         * The 12-digit number identifying an AWS account.
         */
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getAccount() {
            return this.jsiiGet("account", java.util.List.class);
        }
        /**
         * The 12-digit number identifying an AWS account.
         */
        public void setAccount(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("account", value);
        }
        /**
         * The event timestamp, which can be specified by the service originating
         * the event. If the event spans a time interval, the service might choose
         * to report the start time, so this value can be noticeably before the time
         * the event is actually received.
         */
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getTime() {
            return this.jsiiGet("time", java.util.List.class);
        }
        /**
         * The event timestamp, which can be specified by the service originating
         * the event. If the event spans a time interval, the service might choose
         * to report the start time, so this value can be noticeably before the time
         * the event is actually received.
         */
        public void setTime(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("time", value);
        }
        /**
         * Identifies the AWS region where the event originated.
         */
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getRegion() {
            return this.jsiiGet("region", java.util.List.class);
        }
        /**
         * Identifies the AWS region where the event originated.
         */
        public void setRegion(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("region", value);
        }
        /**
         * This JSON array contains ARNs that identify resources that are involved
         * in the event. Inclusion of these ARNs is at the discretion of the
         * service.
         * 
         * For example, Amazon EC2 instance state-changes include Amazon EC2
         * instance ARNs, Auto Scaling events include ARNs for both instances and
         * Auto Scaling groups, but API calls with AWS CloudTrail do not include
         * resource ARNs.
         */
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.Arn> getResources() {
            return this.jsiiGet("resources", java.util.List.class);
        }
        /**
         * This JSON array contains ARNs that identify resources that are involved
         * in the event. Inclusion of these ARNs is at the discretion of the
         * service.
         * 
         * For example, Amazon EC2 instance state-changes include Amazon EC2
         * instance ARNs, Auto Scaling events include ARNs for both instances and
         * Auto Scaling groups, but API calls with AWS CloudTrail do not include
         * resource ARNs.
         */
        public void setResources(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.Arn> value) {
            this.jsiiSet("resources", value);
        }
        /**
         * A JSON object, whose content is at the discretion of the service
         * originating the event.
         */
        @javax.annotation.Nullable
        public java.lang.Object getDetail() {
            return this.jsiiGet("detail", java.lang.Object.class);
        }
        /**
         * A JSON object, whose content is at the discretion of the service
         * originating the event.
         */
        public void setDetail(@javax.annotation.Nullable final java.lang.Object value) {
            this.jsiiSet("detail", value);
        }
    }
}
