package software.amazon.awscdk.services.events;
/**
 * Specifies settings that provide custom input to an Amazon CloudWatch Events
 * rule target based on certain event data.
 * @see https://docs.aws.amazon.com/AmazonCloudWatchEvents/latest/APIReference/API_InputTransformer.html
 */
public interface TargetInputTemplate extends software.amazon.jsii.JsiiSerializable {
    /**
     * Input template where you can use the values of the keys from
     * inputPathsMap to customize the data sent to the target. Enclose each
     * InputPathsMaps value in brackets: <value>
     * 
     * The value passed here will be double-quoted to indicate it's a string value.
     * This option is mutually exclusive with `jsonTemplate`.
     * @example {    textTemplate: 'Build <buildid> started',    pathsMap: {      buildid: '$.detail.id'    } }
     */
    java.lang.Object getTextTemplate();
    /**
     * Input template where you can use the values of the keys from
     * inputPathsMap to customize the data sent to the target. Enclose each
     * InputPathsMaps value in brackets: <value>
     * 
     * The value passed here will be double-quoted to indicate it's a string value.
     * This option is mutually exclusive with `jsonTemplate`.
     * @example {    textTemplate: 'Build <buildid> started',    pathsMap: {      buildid: '$.detail.id'    } }
     */
    void setTextTemplate(final java.lang.Object value);
    /**
     * Input template where you can use the values of the keys from
     * inputPathsMap to customize the data sent to the target. Enclose each
     * InputPathsMaps value in brackets: <value>
     * 
     * This option is mutually exclusive with `textTemplate`.
     * @example {    jsonTemplate: '{ "commands": <commandsToRun> }' ,    pathsMap: {      commandsToRun: '$.detail.commands'    } }
     */
    java.lang.Object getJsonTemplate();
    /**
     * Input template where you can use the values of the keys from
     * inputPathsMap to customize the data sent to the target. Enclose each
     * InputPathsMaps value in brackets: <value>
     * 
     * This option is mutually exclusive with `textTemplate`.
     * @example {    jsonTemplate: '{ "commands": <commandsToRun> }' ,    pathsMap: {      commandsToRun: '$.detail.commands'    } }
     */
    void setJsonTemplate(final java.lang.Object value);
    /**
     * Map of JSON paths to be extracted from the event. These are key-value
     * pairs, where each value is a JSON path. You must use JSON dot notation,
     * not bracket notation.
     */
    java.util.Map<java.lang.String, java.lang.String> getPathsMap();
    /**
     * Map of JSON paths to be extracted from the event. These are key-value
     * pairs, where each value is a JSON path. You must use JSON dot notation,
     * not bracket notation.
     */
    void setPathsMap(final java.util.Map<java.lang.String, java.lang.String> value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }

    /**
     * A fluent builder class for {@link TargetInputTemplate}.
     */
    public static final class Builder {
        private Jsii$Pojo instance = new Jsii$Pojo();

        /**
         * Input template where you can use the values of the keys from
         * inputPathsMap to customize the data sent to the target. Enclose each
         * InputPathsMaps value in brackets: <value>
         * 
         * The value passed here will be double-quoted to indicate it's a string value.
         * This option is mutually exclusive with `jsonTemplate`.
         * @example {    textTemplate: 'Build <buildid> started',    pathsMap: {      buildid: '$.detail.id'    } }
         */
        public Builder withTextTemplate(final java.lang.Object value) {
            this.instance._textTemplate = value;
            return this;
        }
        /**
         * Input template where you can use the values of the keys from
         * inputPathsMap to customize the data sent to the target. Enclose each
         * InputPathsMaps value in brackets: <value>
         * 
         * This option is mutually exclusive with `textTemplate`.
         * @example {    jsonTemplate: '{ "commands": <commandsToRun> }' ,    pathsMap: {      commandsToRun: '$.detail.commands'    } }
         */
        public Builder withJsonTemplate(final java.lang.Object value) {
            this.instance._jsonTemplate = value;
            return this;
        }
        /**
         * Map of JSON paths to be extracted from the event. These are key-value
         * pairs, where each value is a JSON path. You must use JSON dot notation,
         * not bracket notation.
         */
        public Builder withPathsMap(final java.util.Map<java.lang.String, java.lang.String> value) {
            this.instance._pathsMap = value;
            return this;
        }
        public TargetInputTemplate build() {
            TargetInputTemplate result = this.instance;
            this.instance = new Jsii$Pojo();
            return result;
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link TargetInputTemplate}.
     */
    final class Jsii$Pojo implements TargetInputTemplate {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _textTemplate;

        public java.lang.Object getTextTemplate() {
            return this._textTemplate;
        }
        public void setTextTemplate(final java.lang.Object value) {
            this._textTemplate = value;
        }

        protected java.lang.Object _jsonTemplate;

        public java.lang.Object getJsonTemplate() {
            return this._jsonTemplate;
        }
        public void setJsonTemplate(final java.lang.Object value) {
            this._jsonTemplate = value;
        }

        protected java.util.Map<java.lang.String, java.lang.String> _pathsMap;

        public java.util.Map<java.lang.String, java.lang.String> getPathsMap() {
            return this._pathsMap;
        }
        public void setPathsMap(final java.util.Map<java.lang.String, java.lang.String> value) {
            this._pathsMap = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.TargetInputTemplate {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * Input template where you can use the values of the keys from
         * inputPathsMap to customize the data sent to the target. Enclose each
         * InputPathsMaps value in brackets: <value>
         * 
         * The value passed here will be double-quoted to indicate it's a string value.
         * This option is mutually exclusive with `jsonTemplate`.
         * @example {    textTemplate: 'Build <buildid> started',    pathsMap: {      buildid: '$.detail.id'    } }
         */
        @javax.annotation.Nullable
        public java.lang.Object getTextTemplate() {
            return this.jsiiGet("textTemplate", java.lang.Object.class);
        }
        /**
         * Input template where you can use the values of the keys from
         * inputPathsMap to customize the data sent to the target. Enclose each
         * InputPathsMaps value in brackets: <value>
         * 
         * The value passed here will be double-quoted to indicate it's a string value.
         * This option is mutually exclusive with `jsonTemplate`.
         * @example {    textTemplate: 'Build <buildid> started',    pathsMap: {      buildid: '$.detail.id'    } }
         */
        public void setTextTemplate(@javax.annotation.Nullable final java.lang.Object value) {
            this.jsiiSet("textTemplate", value);
        }
        /**
         * Input template where you can use the values of the keys from
         * inputPathsMap to customize the data sent to the target. Enclose each
         * InputPathsMaps value in brackets: <value>
         * 
         * This option is mutually exclusive with `textTemplate`.
         * @example {    jsonTemplate: '{ "commands": <commandsToRun> }' ,    pathsMap: {      commandsToRun: '$.detail.commands'    } }
         */
        @javax.annotation.Nullable
        public java.lang.Object getJsonTemplate() {
            return this.jsiiGet("jsonTemplate", java.lang.Object.class);
        }
        /**
         * Input template where you can use the values of the keys from
         * inputPathsMap to customize the data sent to the target. Enclose each
         * InputPathsMaps value in brackets: <value>
         * 
         * This option is mutually exclusive with `textTemplate`.
         * @example {    jsonTemplate: '{ "commands": <commandsToRun> }' ,    pathsMap: {      commandsToRun: '$.detail.commands'    } }
         */
        public void setJsonTemplate(@javax.annotation.Nullable final java.lang.Object value) {
            this.jsiiSet("jsonTemplate", value);
        }
        /**
         * Map of JSON paths to be extracted from the event. These are key-value
         * pairs, where each value is a JSON path. You must use JSON dot notation,
         * not bracket notation.
         */
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getPathsMap() {
            return this.jsiiGet("pathsMap", java.util.Map.class);
        }
        /**
         * Map of JSON paths to be extracted from the event. These are key-value
         * pairs, where each value is a JSON path. You must use JSON dot notation,
         * not bracket notation.
         */
        public void setPathsMap(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this.jsiiSet("pathsMap", value);
        }
    }
}
