package software.amazon.awscdk.services.events;
/**
 * An abstract target for EventRules.
 */
public interface IEventRuleTarget extends software.amazon.jsii.JsiiSerializable {
    /**
     * Returns the rule target specification.
     * NOTE: Do not use the various `inputXxx` options. They can be set in a call to `addTarget`.
     */
    software.amazon.awscdk.services.events.EventRuleTargetProps getEventRuleTarget();

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link IEventRuleTarget}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * Returns the rule target specification.
         * NOTE: Do not use the various `inputXxx` options. They can be set in a call to `addTarget`.
         */
        public Build withEventRuleTarget(final software.amazon.awscdk.services.events.EventRuleTargetProps value) {
            return new FullBuilder().withEventRuleTarget(value);
        }

        public interface Build {
            /**
             * @return a new {@link IEventRuleTarget} object, initialized with the values set on this builder.
             */
            IEventRuleTarget build();
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * Returns the rule target specification.
             * NOTE: Do not use the various `inputXxx` options. They can be set in a call to `addTarget`.
             */
            public Build withEventRuleTarget(final software.amazon.awscdk.services.events.EventRuleTargetProps value) {
                java.util.Objects.requireNonNull(value, "IEventRuleTarget#eventRuleTarget is required");
                this.instance._eventRuleTarget = value;
                return this;
            }
            public IEventRuleTarget build() {
                IEventRuleTarget result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link IEventRuleTarget}.
     */
    final class Jsii$Pojo implements IEventRuleTarget {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected software.amazon.awscdk.services.events.EventRuleTargetProps _eventRuleTarget;

        public software.amazon.awscdk.services.events.EventRuleTargetProps getEventRuleTarget() {
            return this._eventRuleTarget;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IEventRuleTarget {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * Returns the rule target specification.
         * NOTE: Do not use the various `inputXxx` options. They can be set in a call to `addTarget`.
         */
        public software.amazon.awscdk.services.events.EventRuleTargetProps getEventRuleTarget() {
            return this.jsiiGet("eventRuleTarget", software.amazon.awscdk.services.events.EventRuleTargetProps.class);
        }
    }
}
