package software.amazon.awscdk.services.events;
public interface EventRuleProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * A description of the rule's purpose.
     */
    java.lang.String getDescription();
    /**
     * A description of the rule's purpose.
     */
    void setDescription(final java.lang.String value);
    /**
     * A name for the rule. If you don't specify a name, AWS CloudFormation
     * generates a unique physical ID and uses that ID for the rule name. For
     * more information, see Name Type.
     */
    java.lang.String getRuleName();
    /**
     * A name for the rule. If you don't specify a name, AWS CloudFormation
     * generates a unique physical ID and uses that ID for the rule name. For
     * more information, see Name Type.
     */
    void setRuleName(final java.lang.String value);
    /**
     * Indicates whether the rule is enabled.
     * @default Rule is enabled
     */
    java.lang.Boolean getEnabled();
    /**
     * Indicates whether the rule is enabled.
     * @default Rule is enabled
     */
    void setEnabled(final java.lang.Boolean value);
    /**
     * The schedule or rate (frequency) that determines when CloudWatch Events
     * runs the rule. For more information, see Schedule Expression Syntax for
     * Rules in the Amazon CloudWatch User Guide.
     * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html  You must specify this property, the `eventPattern` property, or both.
     */
    java.lang.String getScheduleExpression();
    /**
     * The schedule or rate (frequency) that determines when CloudWatch Events
     * runs the rule. For more information, see Schedule Expression Syntax for
     * Rules in the Amazon CloudWatch User Guide.
     * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html  You must specify this property, the `eventPattern` property, or both.
     */
    void setScheduleExpression(final java.lang.String value);
    /**
     * Describes which events CloudWatch Events routes to the specified target.
     * These routed events are matched events. For more information, see Events
     * and Event Patterns in the Amazon CloudWatch User Guide.
     * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CloudWatchEventsandEventPatterns.html  You must specify this property (either via props or via `addEventPattern`), the `scheduleExpression` property, or both. The method `addEventPattern` can be used to add filter values to the event pattern.
     */
    software.amazon.awscdk.services.events.EventPattern getEventPattern();
    /**
     * Describes which events CloudWatch Events routes to the specified target.
     * These routed events are matched events. For more information, see Events
     * and Event Patterns in the Amazon CloudWatch User Guide.
     * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CloudWatchEventsandEventPatterns.html  You must specify this property (either via props or via `addEventPattern`), the `scheduleExpression` property, or both. The method `addEventPattern` can be used to add filter values to the event pattern.
     */
    void setEventPattern(final software.amazon.awscdk.services.events.EventPattern value);
    /**
     * Targets to invoke when this rule matches an event.
     * 
     * Input will be the full matched event. If you wish to specify custom
     * target input, use `addTarget(target[, inputOptions])`.
     */
    java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> getTargets();
    /**
     * Targets to invoke when this rule matches an event.
     * 
     * Input will be the full matched event. If you wish to specify custom
     * target input, use `addTarget(target[, inputOptions])`.
     */
    void setTargets(final java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }

    /**
     * A fluent builder class for {@link EventRuleProps}.
     */
    public static final class Builder {
        private Jsii$Pojo instance = new Jsii$Pojo();

        /**
         * A description of the rule's purpose.
         */
        public Builder withDescription(final java.lang.String value) {
            this.instance._description = value;
            return this;
        }
        /**
         * A name for the rule. If you don't specify a name, AWS CloudFormation
         * generates a unique physical ID and uses that ID for the rule name. For
         * more information, see Name Type.
         */
        public Builder withRuleName(final java.lang.String value) {
            this.instance._ruleName = value;
            return this;
        }
        /**
         * Indicates whether the rule is enabled.
         * @default Rule is enabled
         */
        public Builder withEnabled(final java.lang.Boolean value) {
            this.instance._enabled = value;
            return this;
        }
        /**
         * The schedule or rate (frequency) that determines when CloudWatch Events
         * runs the rule. For more information, see Schedule Expression Syntax for
         * Rules in the Amazon CloudWatch User Guide.
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html  You must specify this property, the `eventPattern` property, or both.
         */
        public Builder withScheduleExpression(final java.lang.String value) {
            this.instance._scheduleExpression = value;
            return this;
        }
        /**
         * Describes which events CloudWatch Events routes to the specified target.
         * These routed events are matched events. For more information, see Events
         * and Event Patterns in the Amazon CloudWatch User Guide.
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CloudWatchEventsandEventPatterns.html  You must specify this property (either via props or via `addEventPattern`), the `scheduleExpression` property, or both. The method `addEventPattern` can be used to add filter values to the event pattern.
         */
        public Builder withEventPattern(final software.amazon.awscdk.services.events.EventPattern value) {
            this.instance._eventPattern = value;
            return this;
        }
        /**
         * Targets to invoke when this rule matches an event.
         * 
         * Input will be the full matched event. If you wish to specify custom
         * target input, use `addTarget(target[, inputOptions])`.
         */
        public Builder withTargets(final java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> value) {
            this.instance._targets = value;
            return this;
        }
        public EventRuleProps build() {
            EventRuleProps result = this.instance;
            this.instance = new Jsii$Pojo();
            return result;
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link EventRuleProps}.
     */
    final class Jsii$Pojo implements EventRuleProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.String _description;

        public java.lang.String getDescription() {
            return this._description;
        }
        public void setDescription(final java.lang.String value) {
            this._description = value;
        }

        protected java.lang.String _ruleName;

        public java.lang.String getRuleName() {
            return this._ruleName;
        }
        public void setRuleName(final java.lang.String value) {
            this._ruleName = value;
        }

        protected java.lang.Boolean _enabled;

        public java.lang.Boolean getEnabled() {
            return this._enabled;
        }
        public void setEnabled(final java.lang.Boolean value) {
            this._enabled = value;
        }

        protected java.lang.String _scheduleExpression;

        public java.lang.String getScheduleExpression() {
            return this._scheduleExpression;
        }
        public void setScheduleExpression(final java.lang.String value) {
            this._scheduleExpression = value;
        }

        protected software.amazon.awscdk.services.events.EventPattern _eventPattern;

        public software.amazon.awscdk.services.events.EventPattern getEventPattern() {
            return this._eventPattern;
        }
        public void setEventPattern(final software.amazon.awscdk.services.events.EventPattern value) {
            this._eventPattern = value;
        }

        protected java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> _targets;

        public java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> getTargets() {
            return this._targets;
        }
        public void setTargets(final java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> value) {
            this._targets = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.EventRuleProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * A description of the rule's purpose.
         */
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }
        /**
         * A description of the rule's purpose.
         */
        public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("description", value);
        }
        /**
         * A name for the rule. If you don't specify a name, AWS CloudFormation
         * generates a unique physical ID and uses that ID for the rule name. For
         * more information, see Name Type.
         */
        @javax.annotation.Nullable
        public java.lang.String getRuleName() {
            return this.jsiiGet("ruleName", java.lang.String.class);
        }
        /**
         * A name for the rule. If you don't specify a name, AWS CloudFormation
         * generates a unique physical ID and uses that ID for the rule name. For
         * more information, see Name Type.
         */
        public void setRuleName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("ruleName", value);
        }
        /**
         * Indicates whether the rule is enabled.
         * @default Rule is enabled
         */
        @javax.annotation.Nullable
        public java.lang.Boolean getEnabled() {
            return this.jsiiGet("enabled", java.lang.Boolean.class);
        }
        /**
         * Indicates whether the rule is enabled.
         * @default Rule is enabled
         */
        public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("enabled", value);
        }
        /**
         * The schedule or rate (frequency) that determines when CloudWatch Events
         * runs the rule. For more information, see Schedule Expression Syntax for
         * Rules in the Amazon CloudWatch User Guide.
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html  You must specify this property, the `eventPattern` property, or both.
         */
        @javax.annotation.Nullable
        public java.lang.String getScheduleExpression() {
            return this.jsiiGet("scheduleExpression", java.lang.String.class);
        }
        /**
         * The schedule or rate (frequency) that determines when CloudWatch Events
         * runs the rule. For more information, see Schedule Expression Syntax for
         * Rules in the Amazon CloudWatch User Guide.
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html  You must specify this property, the `eventPattern` property, or both.
         */
        public void setScheduleExpression(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("scheduleExpression", value);
        }
        /**
         * Describes which events CloudWatch Events routes to the specified target.
         * These routed events are matched events. For more information, see Events
         * and Event Patterns in the Amazon CloudWatch User Guide.
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CloudWatchEventsandEventPatterns.html  You must specify this property (either via props or via `addEventPattern`), the `scheduleExpression` property, or both. The method `addEventPattern` can be used to add filter values to the event pattern.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.EventPattern getEventPattern() {
            return this.jsiiGet("eventPattern", software.amazon.awscdk.services.events.EventPattern.class);
        }
        /**
         * Describes which events CloudWatch Events routes to the specified target.
         * These routed events are matched events. For more information, see Events
         * and Event Patterns in the Amazon CloudWatch User Guide.
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CloudWatchEventsandEventPatterns.html  You must specify this property (either via props or via `addEventPattern`), the `scheduleExpression` property, or both. The method `addEventPattern` can be used to add filter values to the event pattern.
         */
        public void setEventPattern(@javax.annotation.Nullable final software.amazon.awscdk.services.events.EventPattern value) {
            this.jsiiSet("eventPattern", value);
        }
        /**
         * Targets to invoke when this rule matches an event.
         * 
         * Input will be the full matched event. If you wish to specify custom
         * target input, use `addTarget(target[, inputOptions])`.
         */
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> getTargets() {
            return this.jsiiGet("targets", java.util.List.class);
        }
        /**
         * Targets to invoke when this rule matches an event.
         * 
         * Input will be the full matched event. If you wish to specify custom
         * target input, use `addTarget(target[, inputOptions])`.
         */
        public void setTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> value) {
            this.jsiiSet("targets", value);
        }
    }
}
