/**
 * <h2>Amazon CloudWatch Events Construct Library</h2>
 * <!-- raw HTML omitted -->
 * <hr />
 * <p><img src="https://img.shields.io/badge/stability-Experimental-important.svg?style=for-the-badge" alt="Stability: Experimental" /></p>
 * <blockquote>
 * <p><strong>This is a <em>developer preview</em> (public beta) module. Releases might lack important features and might have
 * future breaking changes.</strong></p>
 * <p>This API is still under active development and subject to non-backward
 * compatible changes or removal in any future version. Use of the API is not recommended in production
 * environments. Experimental APIs are not subject to the Semantic Versioning model.</p>
 * </blockquote>
 * <hr />
 * <!-- raw HTML omitted -->
 * <p>Amazon CloudWatch Events delivers a near real-time stream of system events that
 * describe changes in AWS resources. For example, an AWS CodePipeline emits the
 * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#codepipeline_event_type">State
 * Change</a>
 * event when the pipeline changes it's state.</p>
 * <ul>
 * <li><strong>Events</strong>: An event indicates a change in your AWS environment. AWS resources
 * can generate events when their state changes. For example, Amazon EC2
 * generates an event when the state of an EC2 instance changes from pending to
 * running, and Amazon EC2 Auto Scaling generates events when it launches or
 * terminates instances. AWS CloudTrail publishes events when you make API calls.
 * You can generate custom application-level events and publish them to
 * CloudWatch Events. You can also set up scheduled events that are generated on
 * a periodic basis. For a list of services that generate events, and sample
 * events from each service, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html">CloudWatch Events Event Examples From Each
 * Supported
 * Service</a>.</li>
 * <li><strong>Targets</strong>: A target processes events. Targets can include Amazon EC2
 * instances, AWS Lambda functions, Kinesis streams, Amazon ECS tasks, Step
 * Functions state machines, Amazon SNS topics, Amazon SQS queues, and built-in
 * targets. A target receives events in JSON format.</li>
 * <li><strong>Rules</strong>: A rule matches incoming events and routes them to targets for
 * processing. A single rule can route to multiple targets, all of which are
 * processed in parallel. Rules are not processed in a particular order. This
 * enables different parts of an organization to look for and process the events
 * that are of interest to them. A rule can customize the JSON sent to the
 * target, by passing only certain parts or by overwriting it with a constant.</li>
 * </ul>
 * <p>The <code>Rule</code> construct defines a CloudWatch events rule which monitors an
 * event based on an <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html">event
 * pattern</a>
 * and invoke <strong>event targets</strong> when the pattern is matched against a triggered
 * event. Event targets are objects that implement the <code>IEventTarget</code> interface.</p>
 * <p>Normally, you will use one of the <code>source.onXxx(name[, target[, options]]) -&gt; Rule</code> methods on the event source to define an event rule associated with
 * the specific activity. You can targets either via props, or add targets using
 * <code>rule.addTarget</code>.</p>
 * <p>For example, to define an rule that triggers a CodeBuild project build when a
 * commit is pushed to the &quot;master&quot; branch of a CodeCommit repository:</p>
 * <pre><code class="language-ts">const onCommitRule = repo.onCommit('OnCommitToMaster', project, 'master');
 * </code></pre>
 * <p>You can add additional targets, with optional <a href="https://docs.aws.amazon.com/AmazonCloudWatchEvents/latest/APIReference/API_InputTransformer.html">input
 * transformer</a>
 * using <code>eventRule.addTarget(target[, input])</code>. For example, we can add a SNS
 * topic target which formats a human-readable message for the commit.</p>
 * <p>For example, this adds an SNS topic as a target:</p>
 * <pre><code class="language-ts">onCommitRule.addTarget(topic, {
 *     template: 'A commit was pushed to the repository &lt;repo&gt; on branch &lt;branch&gt;',
 *     pathsMap: {
 *         branch: '$.detail.referenceName',
 *         repo: '$.detail.repositoryName'
 *     }
 * });
 * </code></pre>
 * <h2>Event Targets</h2>
 * <p>The <code>@aws-cdk/aws-events-targets</code> module includes classes that implement the <code>IRuleTarget</code>
 * interface for various AWS services.</p>
 * <p>The following targets are supported:</p>
 * <ul>
 * <li><code>targets.SnsTopic</code>: publish into an SNS topic when an event rule is triggered.</li>
 * <li><code>targets.CodeBuildProject</code>: start a CodeBuild project when an event rule is triggered.</li>
 * <li><code>targets.LambdaFunction</code>: invoke an AWS Lambda function when an event rule is triggered.</li>
 * </ul>
 * 
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.events;
