package software.amazon.awscdk.services.events;

/**
 * Standard set of options for `onXxx` event handlers on construct.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.2 (build a2116e9)", date = "2019-07-01T16:58:23.744Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface OnEventOptions extends software.amazon.jsii.JsiiSerializable {
    /**
     * A description of the rule's purpose.
     * 
     * Default: - No description
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getDescription();
    /**
     * Additional restrictions for the event to route to the specified target.
     * 
     * The method that generates the rule probably imposes some type of event
     * filtering. The filtering implied by what you pass here is added
     * on top of that filtering.
     * 
     * Default: - No additional filtering based on an event pattern.
     * 
     * EXPERIMENTAL
     * 
     * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CloudWatchEventsandEventPatterns.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.events.EventPattern getEventPattern();
    /**
     * A name for the rule.
     * 
     * Default: AWS CloudFormation generates a unique physical ID.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getRuleName();
    /**
     * The target to register for the event.
     * 
     * Default: - No target is added to the rule. Use `addTarget()` to add a target.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.events.IRuleTarget getTarget();

    /**
     * @return a {@link Builder} of {@link OnEventOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link OnEventOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.events.EventPattern _eventPattern;
        @javax.annotation.Nullable
        private java.lang.String _ruleName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.events.IRuleTarget _target;

        /**
         * Sets the value of Description
         * @param value A description of the rule's purpose.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of EventPattern
         * @param value Additional restrictions for the event to route to the specified target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withEventPattern(@javax.annotation.Nullable final software.amazon.awscdk.services.events.EventPattern value) {
            this._eventPattern = value;
            return this;
        }
        /**
         * Sets the value of RuleName
         * @param value A name for the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withRuleName(@javax.annotation.Nullable final java.lang.String value) {
            this._ruleName = value;
            return this;
        }
        /**
         * Sets the value of Target
         * @param value The target to register for the event.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withTarget(@javax.annotation.Nullable final software.amazon.awscdk.services.events.IRuleTarget value) {
            this._target = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OnEventOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public OnEventOptions build() {
            return new OnEventOptions() {
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.events.EventPattern $eventPattern = _eventPattern;
                @javax.annotation.Nullable
                private final java.lang.String $ruleName = _ruleName;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.events.IRuleTarget $target = _target;

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public software.amazon.awscdk.services.events.EventPattern getEventPattern() {
                    return this.$eventPattern;
                }

                @Override
                public java.lang.String getRuleName() {
                    return this.$ruleName;
                }

                @Override
                public software.amazon.awscdk.services.events.IRuleTarget getTarget() {
                    return this.$target;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree(this.getDescription()));
                    }
                    if (this.getEventPattern() != null) {
                        obj.set("eventPattern", om.valueToTree(this.getEventPattern()));
                    }
                    if (this.getRuleName() != null) {
                        obj.set("ruleName", om.valueToTree(this.getRuleName()));
                    }
                    if (this.getTarget() != null) {
                        obj.set("target", om.valueToTree(this.getTarget()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.OnEventOptions {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * A description of the rule's purpose.
         * 
         * Default: - No description
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * Additional restrictions for the event to route to the specified target.
         * 
         * The method that generates the rule probably imposes some type of event
         * filtering. The filtering implied by what you pass here is added
         * on top of that filtering.
         * 
         * Default: - No additional filtering based on an event pattern.
         * 
         * EXPERIMENTAL
         * 
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CloudWatchEventsandEventPatterns.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.EventPattern getEventPattern() {
            return this.jsiiGet("eventPattern", software.amazon.awscdk.services.events.EventPattern.class);
        }

        /**
         * A name for the rule.
         * 
         * Default: AWS CloudFormation generates a unique physical ID.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getRuleName() {
            return this.jsiiGet("ruleName", java.lang.String.class);
        }

        /**
         * The target to register for the event.
         * 
         * Default: - No target is added to the rule. Use `addTarget()` to add a target.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.IRuleTarget getTarget() {
            return this.jsiiGet("target", software.amazon.awscdk.services.events.IRuleTarget.class);
        }
    }
}
