package software.amazon.awscdk.services.events;

/**
 * Properties for an event rule target.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.12.1 (build 3ce4842)", date = "2019-06-25T14:03:59.553Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface RuleTargetConfig extends software.amazon.jsii.JsiiSerializable {
    /**
     * The Amazon Resource Name (ARN) of the target.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getArn();
    /**
     * A unique, user-defined identifier for the target.
     * 
     * Acceptable values
     * include alphanumeric characters, periods (.), hyphens (-), and
     * underscores (_).
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getId();
    /**
     * The Amazon ECS task definition and task count to use, if the event target is an Amazon ECS task.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty getEcsParameters();
    /**
     * What input to send to the event target.
     * 
     * Default: the entire event
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.events.RuleTargetInput getInput();
    /**
     * Settings that control shard assignment, when the target is a Kinesis stream.
     * 
     * If you don't include this parameter, eventId is used as the
     * partition key.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty getKinesisParameters();
    /**
     * Role to use to invoke this event target.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.iam.IRole getRole();
    /**
     * Parameters used when the rule invokes Amazon EC2 Systems Manager Run Command.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty getRunCommandParameters();

    /**
     * @return a {@link Builder} of {@link RuleTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link RuleTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private java.lang.String _arn;
        private java.lang.String _id;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty _ecsParameters;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.events.RuleTargetInput _input;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty _kinesisParameters;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.iam.IRole _role;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty _runCommandParameters;

        /**
         * Sets the value of Arn
         * @param value The Amazon Resource Name (ARN) of the target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withArn(final java.lang.String value) {
            this._arn = java.util.Objects.requireNonNull(value, "arn is required");
            return this;
        }
        /**
         * Sets the value of Id
         * @param value A unique, user-defined identifier for the target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withId(final java.lang.String value) {
            this._id = java.util.Objects.requireNonNull(value, "id is required");
            return this;
        }
        /**
         * Sets the value of EcsParameters
         * @param value The Amazon ECS task definition and task count to use, if the event target is an Amazon ECS task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withEcsParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty value) {
            this._ecsParameters = value;
            return this;
        }
        /**
         * Sets the value of Input
         * @param value What input to send to the event target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withInput(@javax.annotation.Nullable final software.amazon.awscdk.services.events.RuleTargetInput value) {
            this._input = value;
            return this;
        }
        /**
         * Sets the value of KinesisParameters
         * @param value Settings that control shard assignment, when the target is a Kinesis stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withKinesisParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty value) {
            this._kinesisParameters = value;
            return this;
        }
        /**
         * Sets the value of Role
         * @param value Role to use to invoke this event target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IRole value) {
            this._role = value;
            return this;
        }
        /**
         * Sets the value of RunCommandParameters
         * @param value Parameters used when the rule invokes Amazon EC2 Systems Manager Run Command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withRunCommandParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty value) {
            this._runCommandParameters = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RuleTargetConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public RuleTargetConfig build() {
            return new RuleTargetConfig() {
                private final java.lang.String $arn = java.util.Objects.requireNonNull(_arn, "arn is required");
                private final java.lang.String $id = java.util.Objects.requireNonNull(_id, "id is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty $ecsParameters = _ecsParameters;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.events.RuleTargetInput $input = _input;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty $kinesisParameters = _kinesisParameters;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.iam.IRole $role = _role;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty $runCommandParameters = _runCommandParameters;

                @Override
                public java.lang.String getArn() {
                    return this.$arn;
                }

                @Override
                public java.lang.String getId() {
                    return this.$id;
                }

                @Override
                public software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty getEcsParameters() {
                    return this.$ecsParameters;
                }

                @Override
                public software.amazon.awscdk.services.events.RuleTargetInput getInput() {
                    return this.$input;
                }

                @Override
                public software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty getKinesisParameters() {
                    return this.$kinesisParameters;
                }

                @Override
                public software.amazon.awscdk.services.iam.IRole getRole() {
                    return this.$role;
                }

                @Override
                public software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty getRunCommandParameters() {
                    return this.$runCommandParameters;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("arn", om.valueToTree(this.getArn()));
                    obj.set("id", om.valueToTree(this.getId()));
                    if (this.getEcsParameters() != null) {
                        obj.set("ecsParameters", om.valueToTree(this.getEcsParameters()));
                    }
                    if (this.getInput() != null) {
                        obj.set("input", om.valueToTree(this.getInput()));
                    }
                    if (this.getKinesisParameters() != null) {
                        obj.set("kinesisParameters", om.valueToTree(this.getKinesisParameters()));
                    }
                    if (this.getRole() != null) {
                        obj.set("role", om.valueToTree(this.getRole()));
                    }
                    if (this.getRunCommandParameters() != null) {
                        obj.set("runCommandParameters", om.valueToTree(this.getRunCommandParameters()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.RuleTargetConfig {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The Amazon Resource Name (ARN) of the target.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getArn() {
            return this.jsiiGet("arn", java.lang.String.class);
        }

        /**
         * A unique, user-defined identifier for the target.
         * 
         * Acceptable values
         * include alphanumeric characters, periods (.), hyphens (-), and
         * underscores (_).
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getId() {
            return this.jsiiGet("id", java.lang.String.class);
        }

        /**
         * The Amazon ECS task definition and task count to use, if the event target is an Amazon ECS task.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty getEcsParameters() {
            return this.jsiiGet("ecsParameters", software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty.class);
        }

        /**
         * What input to send to the event target.
         * 
         * Default: the entire event
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.RuleTargetInput getInput() {
            return this.jsiiGet("input", software.amazon.awscdk.services.events.RuleTargetInput.class);
        }

        /**
         * Settings that control shard assignment, when the target is a Kinesis stream.
         * 
         * If you don't include this parameter, eventId is used as the
         * partition key.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty getKinesisParameters() {
            return this.jsiiGet("kinesisParameters", software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty.class);
        }

        /**
         * Role to use to invoke this event target.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
        }

        /**
         * Parameters used when the rule invokes Amazon EC2 Systems Manager Run Command.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty getRunCommandParameters() {
            return this.jsiiGet("runCommandParameters", software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty.class);
        }
    }
}
