package software.amazon.awscdk.services.events;

/**
 * Standard set of options for `onXxx` event handlers on construct.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.3 (build 464b8c6)", date = "2019-06-19T15:07:58.509Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface OnEventOptions extends software.amazon.jsii.JsiiSerializable {
    /**
     * The target to register for the event.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.events.IRuleTarget getTarget();
    /**
     * A description of the rule's purpose.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getDescription();
    /**
     * Additional restrictions for the event to route to the specified target.
     * 
     * The method that generates the rule probably imposes some type of event
     * filtering. The filtering implied by what you pass here is added
     * on top of that filtering.
     * 
     * EXPERIMENTAL
     * 
     * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CloudWatchEventsandEventPatterns.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.events.EventPattern getEventPattern();
    /**
     * A name for the rule.
     * 
     * Default: AWS CloudFormation generates a unique physical ID.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getRuleName();

    /**
     * @return a {@link Builder} of {@link OnEventOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link OnEventOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private software.amazon.awscdk.services.events.IRuleTarget _target;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.events.EventPattern _eventPattern;
        @javax.annotation.Nullable
        private java.lang.String _ruleName;

        /**
         * Sets the value of Target
         * @param value The target to register for the event.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withTarget(final software.amazon.awscdk.services.events.IRuleTarget value) {
            this._target = java.util.Objects.requireNonNull(value, "target is required");
            return this;
        }
        /**
         * Sets the value of Description
         * @param value A description of the rule's purpose.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of EventPattern
         * @param value Additional restrictions for the event to route to the specified target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withEventPattern(@javax.annotation.Nullable final software.amazon.awscdk.services.events.EventPattern value) {
            this._eventPattern = value;
            return this;
        }
        /**
         * Sets the value of RuleName
         * @param value A name for the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withRuleName(@javax.annotation.Nullable final java.lang.String value) {
            this._ruleName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OnEventOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public OnEventOptions build() {
            return new OnEventOptions() {
                private final software.amazon.awscdk.services.events.IRuleTarget $target = java.util.Objects.requireNonNull(_target, "target is required");
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.events.EventPattern $eventPattern = _eventPattern;
                @javax.annotation.Nullable
                private final java.lang.String $ruleName = _ruleName;

                @Override
                public software.amazon.awscdk.services.events.IRuleTarget getTarget() {
                    return this.$target;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public software.amazon.awscdk.services.events.EventPattern getEventPattern() {
                    return this.$eventPattern;
                }

                @Override
                public java.lang.String getRuleName() {
                    return this.$ruleName;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("target", om.valueToTree(this.getTarget()));
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree(this.getDescription()));
                    }
                    if (this.getEventPattern() != null) {
                        obj.set("eventPattern", om.valueToTree(this.getEventPattern()));
                    }
                    if (this.getRuleName() != null) {
                        obj.set("ruleName", om.valueToTree(this.getRuleName()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.OnEventOptions {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The target to register for the event.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.events.IRuleTarget getTarget() {
            return this.jsiiGet("target", software.amazon.awscdk.services.events.IRuleTarget.class);
        }

        /**
         * A description of the rule's purpose.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * Additional restrictions for the event to route to the specified target.
         * 
         * The method that generates the rule probably imposes some type of event
         * filtering. The filtering implied by what you pass here is added
         * on top of that filtering.
         * 
         * EXPERIMENTAL
         * 
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CloudWatchEventsandEventPatterns.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.EventPattern getEventPattern() {
            return this.jsiiGet("eventPattern", software.amazon.awscdk.services.events.EventPattern.class);
        }

        /**
         * A name for the rule.
         * 
         * Default: AWS CloudFormation generates a unique physical ID.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getRuleName() {
            return this.jsiiGet("ruleName", java.lang.String.class);
        }
    }
}
