package software.amazon.awscdk.services.events;

/**
 * Options to configure a cron expression.
 * 
 * All fields are strings so you can use complex expresions. Absence of
 * a field implies '*' or '?', whichever one is appropriate.
 * 
 * EXPERIMENTAL
 * 
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.3 (build 464b8c6)", date = "2019-06-19T15:07:58.506Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CronOptions extends software.amazon.jsii.JsiiSerializable {
    /**
     * The day of the month to run this rule at.
     * 
     * Default: - Every day of the month
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getDay();
    /**
     * The hour to run this rule at.
     * 
     * Default: - Every hour
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getHour();
    /**
     * The minute to run this rule at.
     * 
     * Default: - Every minute
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getMinute();
    /**
     * The month to run this rule at.
     * 
     * Default: - Every month
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getMonth();
    /**
     * The day of the week to run this rule at.
     * 
     * Default: - Any day of the week
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getWeekDay();
    /**
     * The year to run this rule at.
     * 
     * Default: - Every year
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getYear();

    /**
     * @return a {@link Builder} of {@link CronOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CronOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _day;
        @javax.annotation.Nullable
        private java.lang.String _hour;
        @javax.annotation.Nullable
        private java.lang.String _minute;
        @javax.annotation.Nullable
        private java.lang.String _month;
        @javax.annotation.Nullable
        private java.lang.String _weekDay;
        @javax.annotation.Nullable
        private java.lang.String _year;

        /**
         * Sets the value of Day
         * @param value The day of the month to run this rule at.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDay(@javax.annotation.Nullable final java.lang.String value) {
            this._day = value;
            return this;
        }
        /**
         * Sets the value of Hour
         * @param value The hour to run this rule at.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withHour(@javax.annotation.Nullable final java.lang.String value) {
            this._hour = value;
            return this;
        }
        /**
         * Sets the value of Minute
         * @param value The minute to run this rule at.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withMinute(@javax.annotation.Nullable final java.lang.String value) {
            this._minute = value;
            return this;
        }
        /**
         * Sets the value of Month
         * @param value The month to run this rule at.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withMonth(@javax.annotation.Nullable final java.lang.String value) {
            this._month = value;
            return this;
        }
        /**
         * Sets the value of WeekDay
         * @param value The day of the week to run this rule at.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withWeekDay(@javax.annotation.Nullable final java.lang.String value) {
            this._weekDay = value;
            return this;
        }
        /**
         * Sets the value of Year
         * @param value The year to run this rule at.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withYear(@javax.annotation.Nullable final java.lang.String value) {
            this._year = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CronOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public CronOptions build() {
            return new CronOptions() {
                @javax.annotation.Nullable
                private final java.lang.String $day = _day;
                @javax.annotation.Nullable
                private final java.lang.String $hour = _hour;
                @javax.annotation.Nullable
                private final java.lang.String $minute = _minute;
                @javax.annotation.Nullable
                private final java.lang.String $month = _month;
                @javax.annotation.Nullable
                private final java.lang.String $weekDay = _weekDay;
                @javax.annotation.Nullable
                private final java.lang.String $year = _year;

                @Override
                public java.lang.String getDay() {
                    return this.$day;
                }

                @Override
                public java.lang.String getHour() {
                    return this.$hour;
                }

                @Override
                public java.lang.String getMinute() {
                    return this.$minute;
                }

                @Override
                public java.lang.String getMonth() {
                    return this.$month;
                }

                @Override
                public java.lang.String getWeekDay() {
                    return this.$weekDay;
                }

                @Override
                public java.lang.String getYear() {
                    return this.$year;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getDay() != null) {
                        obj.set("day", om.valueToTree(this.getDay()));
                    }
                    if (this.getHour() != null) {
                        obj.set("hour", om.valueToTree(this.getHour()));
                    }
                    if (this.getMinute() != null) {
                        obj.set("minute", om.valueToTree(this.getMinute()));
                    }
                    if (this.getMonth() != null) {
                        obj.set("month", om.valueToTree(this.getMonth()));
                    }
                    if (this.getWeekDay() != null) {
                        obj.set("weekDay", om.valueToTree(this.getWeekDay()));
                    }
                    if (this.getYear() != null) {
                        obj.set("year", om.valueToTree(this.getYear()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.CronOptions {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The day of the month to run this rule at.
         * 
         * Default: - Every day of the month
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getDay() {
            return this.jsiiGet("day", java.lang.String.class);
        }

        /**
         * The hour to run this rule at.
         * 
         * Default: - Every hour
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getHour() {
            return this.jsiiGet("hour", java.lang.String.class);
        }

        /**
         * The minute to run this rule at.
         * 
         * Default: - Every minute
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getMinute() {
            return this.jsiiGet("minute", java.lang.String.class);
        }

        /**
         * The month to run this rule at.
         * 
         * Default: - Every month
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getMonth() {
            return this.jsiiGet("month", java.lang.String.class);
        }

        /**
         * The day of the week to run this rule at.
         * 
         * Default: - Any day of the week
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getWeekDay() {
            return this.jsiiGet("weekDay", java.lang.String.class);
        }

        /**
         * The year to run this rule at.
         * 
         * Default: - Every year
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getYear() {
            return this.jsiiGet("year", java.lang.String.class);
        }
    }
}
