/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.events.CfnRule;
import software.amazon.awscdk.services.events.RuleTargetInput;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface RuleTargetConfig
extends JsiiSerializable {
    public String getArn();

    public String getId();

    public CfnRule.EcsParametersProperty getEcsParameters();

    public RuleTargetInput getInput();

    public CfnRule.KinesisParametersProperty getKinesisParameters();

    public IRole getRole();

    public CfnRule.RunCommandParametersProperty getRunCommandParameters();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _arn;
        private String _id;
        @Nullable
        private CfnRule.EcsParametersProperty _ecsParameters;
        @Nullable
        private RuleTargetInput _input;
        @Nullable
        private CfnRule.KinesisParametersProperty _kinesisParameters;
        @Nullable
        private IRole _role;
        @Nullable
        private CfnRule.RunCommandParametersProperty _runCommandParameters;

        public Builder withArn(String value) {
            this._arn = Objects.requireNonNull(value, "arn is required");
            return this;
        }

        public Builder withId(String value) {
            this._id = Objects.requireNonNull(value, "id is required");
            return this;
        }

        public Builder withEcsParameters(@Nullable CfnRule.EcsParametersProperty value) {
            this._ecsParameters = value;
            return this;
        }

        public Builder withInput(@Nullable RuleTargetInput value) {
            this._input = value;
            return this;
        }

        public Builder withKinesisParameters(@Nullable CfnRule.KinesisParametersProperty value) {
            this._kinesisParameters = value;
            return this;
        }

        public Builder withRole(@Nullable IRole value) {
            this._role = value;
            return this;
        }

        public Builder withRunCommandParameters(@Nullable CfnRule.RunCommandParametersProperty value) {
            this._runCommandParameters = value;
            return this;
        }

        public RuleTargetConfig build() {
            return new RuleTargetConfig(){
                private final String $arn;
                private final String $id;
                @Nullable
                private final CfnRule.EcsParametersProperty $ecsParameters;
                @Nullable
                private final RuleTargetInput $input;
                @Nullable
                private final CfnRule.KinesisParametersProperty $kinesisParameters;
                @Nullable
                private final IRole $role;
                @Nullable
                private final CfnRule.RunCommandParametersProperty $runCommandParameters;
                {
                    this.$arn = Objects.requireNonNull(_arn, "arn is required");
                    this.$id = Objects.requireNonNull(_id, "id is required");
                    this.$ecsParameters = _ecsParameters;
                    this.$input = _input;
                    this.$kinesisParameters = _kinesisParameters;
                    this.$role = _role;
                    this.$runCommandParameters = _runCommandParameters;
                }

                @Override
                public String getArn() {
                    return this.$arn;
                }

                @Override
                public String getId() {
                    return this.$id;
                }

                @Override
                public CfnRule.EcsParametersProperty getEcsParameters() {
                    return this.$ecsParameters;
                }

                @Override
                public RuleTargetInput getInput() {
                    return this.$input;
                }

                @Override
                public CfnRule.KinesisParametersProperty getKinesisParameters() {
                    return this.$kinesisParameters;
                }

                @Override
                public IRole getRole() {
                    return this.$role;
                }

                @Override
                public CfnRule.RunCommandParametersProperty getRunCommandParameters() {
                    return this.$runCommandParameters;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("arn", om.valueToTree((Object)this.getArn()));
                    obj.set("id", om.valueToTree((Object)this.getId()));
                    if (this.getEcsParameters() != null) {
                        obj.set("ecsParameters", om.valueToTree((Object)this.getEcsParameters()));
                    }
                    if (this.getInput() != null) {
                        obj.set("input", om.valueToTree((Object)this.getInput()));
                    }
                    if (this.getKinesisParameters() != null) {
                        obj.set("kinesisParameters", om.valueToTree((Object)this.getKinesisParameters()));
                    }
                    if (this.getRole() != null) {
                        obj.set("role", om.valueToTree((Object)this.getRole()));
                    }
                    if (this.getRunCommandParameters() != null) {
                        obj.set("runCommandParameters", om.valueToTree((Object)this.getRunCommandParameters()));
                    }
                    return obj;
                }
            };
        }
    }
}

