/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.events.EventPattern;
import software.amazon.awscdk.services.events.IRuleTarget;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface OnEventOptions
extends JsiiSerializable {
    public IRuleTarget getTarget();

    public String getDescription();

    public EventPattern getEventPattern();

    public String getRuleName();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IRuleTarget _target;
        @Nullable
        private String _description;
        @Nullable
        private EventPattern _eventPattern;
        @Nullable
        private String _ruleName;

        public Builder withTarget(IRuleTarget value) {
            this._target = Objects.requireNonNull(value, "target is required");
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withEventPattern(@Nullable EventPattern value) {
            this._eventPattern = value;
            return this;
        }

        public Builder withRuleName(@Nullable String value) {
            this._ruleName = value;
            return this;
        }

        public OnEventOptions build() {
            return new OnEventOptions(){
                private final IRuleTarget $target;
                @Nullable
                private final String $description;
                @Nullable
                private final EventPattern $eventPattern;
                @Nullable
                private final String $ruleName;
                {
                    this.$target = Objects.requireNonNull(_target, "target is required");
                    this.$description = _description;
                    this.$eventPattern = _eventPattern;
                    this.$ruleName = _ruleName;
                }

                @Override
                public IRuleTarget getTarget() {
                    return this.$target;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public EventPattern getEventPattern() {
                    return this.$eventPattern;
                }

                @Override
                public String getRuleName() {
                    return this.$ruleName;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("target", om.valueToTree((Object)this.getTarget()));
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree((Object)this.getDescription()));
                    }
                    if (this.getEventPattern() != null) {
                        obj.set("eventPattern", om.valueToTree((Object)this.getEventPattern()));
                    }
                    if (this.getRuleName() != null) {
                        obj.set("ruleName", om.valueToTree((Object)this.getRuleName()));
                    }
                    return obj;
                }
            };
        }
    }
}

