package software.amazon.awscdk.services.events;

/**
 * Events in Amazon CloudWatch Events are represented as JSON objects. For more information about JSON objects, see RFC 7159.
 * 
 * Rules use event patterns to select events and route them to targets. A
 * pattern either matches an event or it doesn't. Event patterns are represented
 * as JSON objects with a structure that is similar to that of events, for
 * example:
 * 
 * It is important to remember the following about event pattern matching:
 * 
 * - For a pattern to match an event, the event must contain all the field names
 *    listed in the pattern. The field names must appear in the event with the
 *    same nesting structure.
 * 
 * - Other fields of the event not mentioned in the pattern are ignored;
 *    effectively, there is a ``"*": "*"`` wildcard for fields not mentioned.
 * 
 * - The matching is exact (character-by-character), without case-folding or any
 *    other string normalization.
 * 
 * - The values being matched follow JSON rules: Strings enclosed in quotes,
 *    numbers, and the unquoted keywords true, false, and null.
 * 
 * - Number matching is at the string representation level. For example, 300,
 *    300.0, and 3.0e2 are not considered equal.
 * 
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:03:09.128Z")
public interface EventPattern extends software.amazon.jsii.JsiiSerializable {
    /**
     * The 12-digit number identifying an AWS account.
     */
    java.util.List<java.lang.String> getAccount();
    /**
     * A JSON object, whose content is at the discretion of the service originating the event.
     */
    java.lang.Object getDetail();
    /**
     * Identifies, in combination with the source field, the fields and values that appear in the detail field.
     * 
     * Represents the "detail-type" event field.
     */
    java.util.List<java.lang.String> getDetailType();
    /**
     * A unique value is generated for every event.
     * 
     * This can be helpful in
     * tracing events as they move through rules to targets, and are processed.
     */
    java.util.List<java.lang.String> getId();
    /**
     * Identifies the AWS region where the event originated.
     */
    java.util.List<java.lang.String> getRegion();
    /**
     * This JSON array contains ARNs that identify resources that are involved in the event.
     * 
     * Inclusion of these ARNs is at the discretion of the
     * service.
     * 
     * For example, Amazon EC2 instance state-changes include Amazon EC2
     * instance ARNs, Auto Scaling events include ARNs for both instances and
     * Auto Scaling groups, but API calls with AWS CloudTrail do not include
     * resource ARNs.
     */
    java.util.List<java.lang.String> getResources();
    /**
     * Identifies the service that sourced the event.
     * 
     * All events sourced from
     * within AWS begin with "aws." Customer-generated events can have any value
     * here, as long as it doesn't begin with "aws." We recommend the use of
     * Java package-name style reverse domain-name strings.
     * 
     * To find the correct value for source for an AWS service, see the table in
     * AWS Service Namespaces. For example, the source value for Amazon
     * CloudFront is aws.cloudfront.
     * 
     * @see http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces
     */
    java.util.List<java.lang.String> getSource();
    /**
     * The event timestamp, which can be specified by the service originating the event.
     * 
     * If the event spans a time interval, the service might choose
     * to report the start time, so this value can be noticeably before the time
     * the event is actually received.
     */
    java.util.List<java.lang.String> getTime();
    /**
     * By default, this is set to 0 (zero) in all events.
     */
    java.util.List<java.lang.String> getVersion();

    /**
     * @return a {@link Builder} of {@link EventPattern}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link EventPattern}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _account;
        @javax.annotation.Nullable
        private java.lang.Object _detail;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _detailType;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _id;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _region;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _resources;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _source;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _time;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _version;

        /**
         * Sets the value of Account
         * @param value The 12-digit number identifying an AWS account.
         * @return {@code this}
         */
        public Builder withAccount(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._account = value;
            return this;
        }
        /**
         * Sets the value of Detail
         * @param value A JSON object, whose content is at the discretion of the service originating the event.
         * @return {@code this}
         */
        public Builder withDetail(@javax.annotation.Nullable final java.lang.Object value) {
            this._detail = value;
            return this;
        }
        /**
         * Sets the value of DetailType
         * @param value Identifies, in combination with the source field, the fields and values that appear in the detail field.
         * @return {@code this}
         */
        public Builder withDetailType(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._detailType = value;
            return this;
        }
        /**
         * Sets the value of Id
         * @param value A unique value is generated for every event.
         * @return {@code this}
         */
        public Builder withId(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._id = value;
            return this;
        }
        /**
         * Sets the value of Region
         * @param value Identifies the AWS region where the event originated.
         * @return {@code this}
         */
        public Builder withRegion(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._region = value;
            return this;
        }
        /**
         * Sets the value of Resources
         * @param value This JSON array contains ARNs that identify resources that are involved in the event.
         * @return {@code this}
         */
        public Builder withResources(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._resources = value;
            return this;
        }
        /**
         * Sets the value of Source
         * @param value Identifies the service that sourced the event.
         * @return {@code this}
         */
        public Builder withSource(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._source = value;
            return this;
        }
        /**
         * Sets the value of Time
         * @param value The event timestamp, which can be specified by the service originating the event.
         * @return {@code this}
         */
        public Builder withTime(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._time = value;
            return this;
        }
        /**
         * Sets the value of Version
         * @param value By default, this is set to 0 (zero) in all events.
         * @return {@code this}
         */
        public Builder withVersion(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._version = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventPattern}
         * @throws NullPointerException if any required attribute was not provided
         */
        public EventPattern build() {
            return new EventPattern() {
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $account = _account;
                @javax.annotation.Nullable
                private final java.lang.Object $detail = _detail;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $detailType = _detailType;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $id = _id;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $region = _region;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $resources = _resources;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $source = _source;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $time = _time;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $version = _version;

                @Override
                public java.util.List<java.lang.String> getAccount() {
                    return this.$account;
                }

                @Override
                public java.lang.Object getDetail() {
                    return this.$detail;
                }

                @Override
                public java.util.List<java.lang.String> getDetailType() {
                    return this.$detailType;
                }

                @Override
                public java.util.List<java.lang.String> getId() {
                    return this.$id;
                }

                @Override
                public java.util.List<java.lang.String> getRegion() {
                    return this.$region;
                }

                @Override
                public java.util.List<java.lang.String> getResources() {
                    return this.$resources;
                }

                @Override
                public java.util.List<java.lang.String> getSource() {
                    return this.$source;
                }

                @Override
                public java.util.List<java.lang.String> getTime() {
                    return this.$time;
                }

                @Override
                public java.util.List<java.lang.String> getVersion() {
                    return this.$version;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("account", om.valueToTree(this.getAccount()));
                    obj.set("detail", om.valueToTree(this.getDetail()));
                    obj.set("detailType", om.valueToTree(this.getDetailType()));
                    obj.set("id", om.valueToTree(this.getId()));
                    obj.set("region", om.valueToTree(this.getRegion()));
                    obj.set("resources", om.valueToTree(this.getResources()));
                    obj.set("source", om.valueToTree(this.getSource()));
                    obj.set("time", om.valueToTree(this.getTime()));
                    obj.set("version", om.valueToTree(this.getVersion()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.EventPattern {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The 12-digit number identifying an AWS account.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getAccount() {
            return this.jsiiGet("account", java.util.List.class);
        }

        /**
         * A JSON object, whose content is at the discretion of the service originating the event.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getDetail() {
            return this.jsiiGet("detail", java.lang.Object.class);
        }

        /**
         * Identifies, in combination with the source field, the fields and values that appear in the detail field.
         * 
         * Represents the "detail-type" event field.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getDetailType() {
            return this.jsiiGet("detailType", java.util.List.class);
        }

        /**
         * A unique value is generated for every event.
         * 
         * This can be helpful in
         * tracing events as they move through rules to targets, and are processed.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getId() {
            return this.jsiiGet("id", java.util.List.class);
        }

        /**
         * Identifies the AWS region where the event originated.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getRegion() {
            return this.jsiiGet("region", java.util.List.class);
        }

        /**
         * This JSON array contains ARNs that identify resources that are involved in the event.
         * 
         * Inclusion of these ARNs is at the discretion of the
         * service.
         * 
         * For example, Amazon EC2 instance state-changes include Amazon EC2
         * instance ARNs, Auto Scaling events include ARNs for both instances and
         * Auto Scaling groups, but API calls with AWS CloudTrail do not include
         * resource ARNs.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getResources() {
            return this.jsiiGet("resources", java.util.List.class);
        }

        /**
         * Identifies the service that sourced the event.
         * 
         * All events sourced from
         * within AWS begin with "aws." Customer-generated events can have any value
         * here, as long as it doesn't begin with "aws." We recommend the use of
         * Java package-name style reverse domain-name strings.
         * 
         * To find the correct value for source for an AWS service, see the table in
         * AWS Service Namespaces. For example, the source value for Amazon
         * CloudFront is aws.cloudfront.
         * 
         * @see http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getSource() {
            return this.jsiiGet("source", java.util.List.class);
        }

        /**
         * The event timestamp, which can be specified by the service originating the event.
         * 
         * If the event spans a time interval, the service might choose
         * to report the start time, so this value can be noticeably before the time
         * the event is actually received.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getTime() {
            return this.jsiiGet("time", java.util.List.class);
        }

        /**
         * By default, this is set to 0 (zero) in all events.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getVersion() {
            return this.jsiiGet("version", java.util.List.class);
        }
    }
}
