/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.events.CfnRule;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface EventRuleTargetProps
extends JsiiSerializable {
    public String getArn();

    public String getId();

    public CfnRule.EcsParametersProperty getEcsParameters();

    public CfnRule.KinesisParametersProperty getKinesisParameters();

    public String getRoleArn();

    public CfnRule.RunCommandParametersProperty getRunCommandParameters();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _arn;
        private String _id;
        @Nullable
        private CfnRule.EcsParametersProperty _ecsParameters;
        @Nullable
        private CfnRule.KinesisParametersProperty _kinesisParameters;
        @Nullable
        private String _roleArn;
        @Nullable
        private CfnRule.RunCommandParametersProperty _runCommandParameters;

        public Builder withArn(String value) {
            this._arn = Objects.requireNonNull(value, "arn is required");
            return this;
        }

        public Builder withId(String value) {
            this._id = Objects.requireNonNull(value, "id is required");
            return this;
        }

        public Builder withEcsParameters(@Nullable CfnRule.EcsParametersProperty value) {
            this._ecsParameters = value;
            return this;
        }

        public Builder withKinesisParameters(@Nullable CfnRule.KinesisParametersProperty value) {
            this._kinesisParameters = value;
            return this;
        }

        public Builder withRoleArn(@Nullable String value) {
            this._roleArn = value;
            return this;
        }

        public Builder withRunCommandParameters(@Nullable CfnRule.RunCommandParametersProperty value) {
            this._runCommandParameters = value;
            return this;
        }

        public EventRuleTargetProps build() {
            return new EventRuleTargetProps(){
                private final String $arn;
                private final String $id;
                @Nullable
                private final CfnRule.EcsParametersProperty $ecsParameters;
                @Nullable
                private final CfnRule.KinesisParametersProperty $kinesisParameters;
                @Nullable
                private final String $roleArn;
                @Nullable
                private final CfnRule.RunCommandParametersProperty $runCommandParameters;
                {
                    this.$arn = Objects.requireNonNull(_arn, "arn is required");
                    this.$id = Objects.requireNonNull(_id, "id is required");
                    this.$ecsParameters = _ecsParameters;
                    this.$kinesisParameters = _kinesisParameters;
                    this.$roleArn = _roleArn;
                    this.$runCommandParameters = _runCommandParameters;
                }

                @Override
                public String getArn() {
                    return this.$arn;
                }

                @Override
                public String getId() {
                    return this.$id;
                }

                @Override
                public CfnRule.EcsParametersProperty getEcsParameters() {
                    return this.$ecsParameters;
                }

                @Override
                public CfnRule.KinesisParametersProperty getKinesisParameters() {
                    return this.$kinesisParameters;
                }

                @Override
                public String getRoleArn() {
                    return this.$roleArn;
                }

                @Override
                public CfnRule.RunCommandParametersProperty getRunCommandParameters() {
                    return this.$runCommandParameters;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("arn", om.valueToTree((Object)this.getArn()));
                    obj.set("id", om.valueToTree((Object)this.getId()));
                    obj.set("ecsParameters", om.valueToTree((Object)this.getEcsParameters()));
                    obj.set("kinesisParameters", om.valueToTree((Object)this.getKinesisParameters()));
                    obj.set("roleArn", om.valueToTree((Object)this.getRoleArn()));
                    obj.set("runCommandParameters", om.valueToTree((Object)this.getRunCommandParameters()));
                    return obj;
                }
            };
        }
    }
}

