package software.amazon.awscdk.services.events;

@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:09:41.366Z")
public interface EventRuleProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * A description of the rule's purpose.
     */
    java.lang.String getDescription();
    /**
     * Indicates whether the rule is enabled.
     * 
     * Default: Rule is enabled
     */
    java.lang.Boolean getEnabled();
    /**
     * Describes which events CloudWatch Events routes to the specified target. These routed events are matched events. For more information, see Events and Event Patterns in the Amazon CloudWatch User Guide.
     * 
     * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CloudWatchEventsandEventPatterns.html
     * 
     * You must specify this property (either via props or via
     * `addEventPattern`), the `scheduleExpression` property, or both. The
     * method `addEventPattern` can be used to add filter values to the event
     * pattern.
     */
    software.amazon.awscdk.services.events.EventPattern getEventPattern();
    /**
     * A name for the rule.
     * 
     * If you don't specify a name, AWS CloudFormation
     * generates a unique physical ID and uses that ID for the rule name. For
     * more information, see Name Type.
     */
    java.lang.String getRuleName();
    /**
     * The schedule or rate (frequency) that determines when CloudWatch Events runs the rule.
     * 
     * For more information, see Schedule Expression Syntax for
     * Rules in the Amazon CloudWatch User Guide.
     * 
     * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html
     * 
     * You must specify this property, the `eventPattern` property, or both.
     */
    java.lang.String getScheduleExpression();
    /**
     * Targets to invoke when this rule matches an event.
     * 
     * Input will be the full matched event. If you wish to specify custom
     * target input, use `addTarget(target[, inputOptions])`.
     */
    java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> getTargets();

    /**
     * @return a {@link Builder} of {@link EventRuleProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link EventRuleProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.lang.Boolean _enabled;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.events.EventPattern _eventPattern;
        @javax.annotation.Nullable
        private java.lang.String _ruleName;
        @javax.annotation.Nullable
        private java.lang.String _scheduleExpression;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> _targets;

        /**
         * Sets the value of Description
         * @param value A description of the rule's purpose.
         * @return {@code this}
         */
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of Enabled
         * @param value Indicates whether the rule is enabled.
         * @return {@code this}
         */
        public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._enabled = value;
            return this;
        }
        /**
         * Sets the value of EventPattern
         * @param value Describes which events CloudWatch Events routes to the specified target. These routed events are matched events. For more information, see Events and Event Patterns in the Amazon CloudWatch User Guide.
         * @return {@code this}
         */
        public Builder withEventPattern(@javax.annotation.Nullable final software.amazon.awscdk.services.events.EventPattern value) {
            this._eventPattern = value;
            return this;
        }
        /**
         * Sets the value of RuleName
         * @param value A name for the rule.
         * @return {@code this}
         */
        public Builder withRuleName(@javax.annotation.Nullable final java.lang.String value) {
            this._ruleName = value;
            return this;
        }
        /**
         * Sets the value of ScheduleExpression
         * @param value The schedule or rate (frequency) that determines when CloudWatch Events runs the rule.
         * @return {@code this}
         */
        public Builder withScheduleExpression(@javax.annotation.Nullable final java.lang.String value) {
            this._scheduleExpression = value;
            return this;
        }
        /**
         * Sets the value of Targets
         * @param value Targets to invoke when this rule matches an event.
         * @return {@code this}
         */
        public Builder withTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> value) {
            this._targets = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public EventRuleProps build() {
            return new EventRuleProps() {
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;
                @javax.annotation.Nullable
                private final java.lang.Boolean $enabled = _enabled;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.events.EventPattern $eventPattern = _eventPattern;
                @javax.annotation.Nullable
                private final java.lang.String $ruleName = _ruleName;
                @javax.annotation.Nullable
                private final java.lang.String $scheduleExpression = _scheduleExpression;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> $targets = _targets;

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public java.lang.Boolean getEnabled() {
                    return this.$enabled;
                }

                @Override
                public software.amazon.awscdk.services.events.EventPattern getEventPattern() {
                    return this.$eventPattern;
                }

                @Override
                public java.lang.String getRuleName() {
                    return this.$ruleName;
                }

                @Override
                public java.lang.String getScheduleExpression() {
                    return this.$scheduleExpression;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> getTargets() {
                    return this.$targets;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("description", om.valueToTree(this.getDescription()));
                    obj.set("enabled", om.valueToTree(this.getEnabled()));
                    obj.set("eventPattern", om.valueToTree(this.getEventPattern()));
                    obj.set("ruleName", om.valueToTree(this.getRuleName()));
                    obj.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
                    obj.set("targets", om.valueToTree(this.getTargets()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.EventRuleProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * A description of the rule's purpose.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * Indicates whether the rule is enabled.
         * 
         * Default: Rule is enabled
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getEnabled() {
            return this.jsiiGet("enabled", java.lang.Boolean.class);
        }

        /**
         * Describes which events CloudWatch Events routes to the specified target. These routed events are matched events. For more information, see Events and Event Patterns in the Amazon CloudWatch User Guide.
         * 
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CloudWatchEventsandEventPatterns.html
         * 
         * You must specify this property (either via props or via
         * `addEventPattern`), the `scheduleExpression` property, or both. The
         * method `addEventPattern` can be used to add filter values to the event
         * pattern.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.EventPattern getEventPattern() {
            return this.jsiiGet("eventPattern", software.amazon.awscdk.services.events.EventPattern.class);
        }

        /**
         * A name for the rule.
         * 
         * If you don't specify a name, AWS CloudFormation
         * generates a unique physical ID and uses that ID for the rule name. For
         * more information, see Name Type.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getRuleName() {
            return this.jsiiGet("ruleName", java.lang.String.class);
        }

        /**
         * The schedule or rate (frequency) that determines when CloudWatch Events runs the rule.
         * 
         * For more information, see Schedule Expression Syntax for
         * Rules in the Amazon CloudWatch User Guide.
         * 
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html
         * 
         * You must specify this property, the `eventPattern` property, or both.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getScheduleExpression() {
            return this.jsiiGet("scheduleExpression", java.lang.String.class);
        }

        /**
         * Targets to invoke when this rule matches an event.
         * 
         * Input will be the full matched event. If you wish to specify custom
         * target input, use `addTarget(target[, inputOptions])`.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.events.IEventRuleTarget> getTargets() {
            return this.jsiiGet("targets", java.util.List.class);
        }
    }
}
