package software.amazon.awscdk.services.events;

/**
 * Defines a CloudWatch Event Rule in this stack.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:09:41.364Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.$Module.class, fqn = "@aws-cdk/aws-events.EventRule")
public class EventRule extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.events.IEventRule {
    protected EventRule(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public EventRule(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.events.EventRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }
    public EventRule(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Imports a rule by ARN into this stack.
     */
    public static software.amazon.awscdk.services.events.IEventRule import_(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.events.EventRuleImportProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.EventRule.class, "import", software.amazon.awscdk.services.events.IEventRule.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds an event pattern filter to this rule.
     * 
     * If a pattern was already specified,
     * these values are merged into the existing pattern.
     * 
     * For example, if the rule already contains the pattern:
     * 
     *     {
     *       "resources": [ "r1" ],
     *       "detail": {
     *         "hello": [ 1 ]
     *       }
     *     }
     * 
     * And `addEventPattern` is called with the pattern:
     * 
     *     {
     *       "resources": [ "r2" ],
     *       "detail": {
     *         "foo": [ "bar" ]
     *       }
     *     }
     * 
     * The resulting event pattern will be:
     * 
     *     {
     *       "resources": [ "r1", "r2" ],
     *       "detail": {
     *         "hello": [ 1 ],
     *         "foo": [ "bar" ]
     *       }
     *     }
     */
    public void addEventPattern(@javax.annotation.Nullable final software.amazon.awscdk.services.events.EventPattern eventPattern) {
        this.jsiiCall("addEventPattern", Void.class, new Object[] { eventPattern });
    }

    /**
     * Adds an event pattern filter to this rule.
     * 
     * If a pattern was already specified,
     * these values are merged into the existing pattern.
     * 
     * For example, if the rule already contains the pattern:
     * 
     *     {
     *       "resources": [ "r1" ],
     *       "detail": {
     *         "hello": [ 1 ]
     *       }
     *     }
     * 
     * And `addEventPattern` is called with the pattern:
     * 
     *     {
     *       "resources": [ "r2" ],
     *       "detail": {
     *         "foo": [ "bar" ]
     *       }
     *     }
     * 
     * The resulting event pattern will be:
     * 
     *     {
     *       "resources": [ "r1", "r2" ],
     *       "detail": {
     *         "hello": [ 1 ],
     *         "foo": [ "bar" ]
     *       }
     *     }
     */
    public void addEventPattern() {
        this.jsiiCall("addEventPattern", Void.class);
    }

    /**
     * Adds a target to the rule. The abstract class RuleTarget can be extended to define new targets.
     * 
     * No-op if target is undefined.
     */
    public void addTarget(@javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target, @javax.annotation.Nullable final software.amazon.awscdk.services.events.TargetInputTemplate inputOptions) {
        this.jsiiCall("addTarget", Void.class, new Object[] { target, inputOptions });
    }

    /**
     * Adds a target to the rule. The abstract class RuleTarget can be extended to define new targets.
     * 
     * No-op if target is undefined.
     */
    public void addTarget(@javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target) {
        this.jsiiCall("addTarget", Void.class, new Object[] { target });
    }

    /**
     * Adds a target to the rule. The abstract class RuleTarget can be extended to define new targets.
     * 
     * No-op if target is undefined.
     */
    public void addTarget() {
        this.jsiiCall("addTarget", Void.class);
    }

    /**
     * Exports this rule resource from this stack and returns an import token.
     */
    @Override
    public software.amazon.awscdk.services.events.EventRuleImportProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.events.EventRuleImportProps.class);
    }

    /**
     * Validate the current construct.
     * 
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @Override
    protected java.util.List<java.lang.String> validate() {
        return this.jsiiCall("validate", java.util.List.class);
    }

    /**
     * The value of the event rule Amazon Resource Name (ARN), such as arn:aws:events:us-east-2:123456789012:rule/example.
     */
    @Override
    public java.lang.String getRuleArn() {
        return this.jsiiGet("ruleArn", java.lang.String.class);
    }
}
