package software.amazon.awscdk.services.events;

/**
 * A CloudFormation `AWS::Events::Rule`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:09:41.357Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.$Module.class, fqn = "@aws-cdk/aws-events.CfnRule")
public class CfnRule extends software.amazon.awscdk.CfnResource {
    protected CfnRule(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.events.CfnRule.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::Events::Rule`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnRule(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }
    /**
     * Create a new `AWS::Events::Rule`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     */
    public CfnRule(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.events.CfnRuleProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.events.CfnRuleProps.class);
    }

    /**
     */
    public java.lang.String getRuleArn() {
        return this.jsiiGet("ruleArn", java.lang.String.class);
    }

    public java.lang.String getRuleId() {
        return this.jsiiGet("ruleId", java.lang.String.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html
     */
    public static interface EcsParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnRule.EcsParametersProperty.TaskDefinitionArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn
         */
        java.lang.String getTaskDefinitionArn();
        /**
         * `CfnRule.EcsParametersProperty.TaskCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
         */
        java.lang.Object getTaskCount();

        /**
         * @return a {@link Builder} of {@link EcsParametersProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EcsParametersProperty}
         */
        final class Builder {
            private java.lang.String _taskDefinitionArn;
            @javax.annotation.Nullable
            private java.lang.Object _taskCount;

            /**
             * Sets the value of TaskDefinitionArn
             * @param value `CfnRule.EcsParametersProperty.TaskDefinitionArn`.
             * @return {@code this}
             */
            public Builder withTaskDefinitionArn(final java.lang.String value) {
                this._taskDefinitionArn = java.util.Objects.requireNonNull(value, "taskDefinitionArn is required");
                return this;
            }
            /**
             * Sets the value of TaskCount
             * @param value `CfnRule.EcsParametersProperty.TaskCount`.
             * @return {@code this}
             */
            public Builder withTaskCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._taskCount = value;
                return this;
            }
            /**
             * Sets the value of TaskCount
             * @param value `CfnRule.EcsParametersProperty.TaskCount`.
             * @return {@code this}
             */
            public Builder withTaskCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._taskCount = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EcsParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EcsParametersProperty build() {
                return new EcsParametersProperty() {
                    private final java.lang.String $taskDefinitionArn = java.util.Objects.requireNonNull(_taskDefinitionArn, "taskDefinitionArn is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $taskCount = _taskCount;

                    @Override
                    public java.lang.String getTaskDefinitionArn() {
                        return this.$taskDefinitionArn;
                    }

                    @Override
                    public java.lang.Object getTaskCount() {
                        return this.$taskCount;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("taskDefinitionArn", om.valueToTree(this.getTaskDefinitionArn()));
                        obj.set("taskCount", om.valueToTree(this.getTaskCount()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnRule.EcsParametersProperty.TaskDefinitionArn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn
             */
            @Override
            public java.lang.String getTaskDefinitionArn() {
                return this.jsiiGet("taskDefinitionArn", java.lang.String.class);
            }

            /**
             * `CfnRule.EcsParametersProperty.TaskCount`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTaskCount() {
                return this.jsiiGet("taskCount", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html
     */
    public static interface InputTransformerProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnRule.InputTransformerProperty.InputTemplate`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate
         */
        java.lang.String getInputTemplate();
        /**
         * `CfnRule.InputTransformerProperty.InputPathsMap`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
         */
        java.lang.Object getInputPathsMap();

        /**
         * @return a {@link Builder} of {@link InputTransformerProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InputTransformerProperty}
         */
        final class Builder {
            private java.lang.String _inputTemplate;
            @javax.annotation.Nullable
            private java.lang.Object _inputPathsMap;

            /**
             * Sets the value of InputTemplate
             * @param value `CfnRule.InputTransformerProperty.InputTemplate`.
             * @return {@code this}
             */
            public Builder withInputTemplate(final java.lang.String value) {
                this._inputTemplate = java.util.Objects.requireNonNull(value, "inputTemplate is required");
                return this;
            }
            /**
             * Sets the value of InputPathsMap
             * @param value `CfnRule.InputTransformerProperty.InputPathsMap`.
             * @return {@code this}
             */
            public Builder withInputPathsMap(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._inputPathsMap = value;
                return this;
            }
            /**
             * Sets the value of InputPathsMap
             * @param value `CfnRule.InputTransformerProperty.InputPathsMap`.
             * @return {@code this}
             */
            public Builder withInputPathsMap(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                this._inputPathsMap = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputTransformerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public InputTransformerProperty build() {
                return new InputTransformerProperty() {
                    private final java.lang.String $inputTemplate = java.util.Objects.requireNonNull(_inputTemplate, "inputTemplate is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $inputPathsMap = _inputPathsMap;

                    @Override
                    public java.lang.String getInputTemplate() {
                        return this.$inputTemplate;
                    }

                    @Override
                    public java.lang.Object getInputPathsMap() {
                        return this.$inputPathsMap;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("inputTemplate", om.valueToTree(this.getInputTemplate()));
                        obj.set("inputPathsMap", om.valueToTree(this.getInputPathsMap()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.CfnRule.InputTransformerProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnRule.InputTransformerProperty.InputTemplate`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate
             */
            @Override
            public java.lang.String getInputTemplate() {
                return this.jsiiGet("inputTemplate", java.lang.String.class);
            }

            /**
             * `CfnRule.InputTransformerProperty.InputPathsMap`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getInputPathsMap() {
                return this.jsiiGet("inputPathsMap", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html
     */
    public static interface KinesisParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnRule.KinesisParametersProperty.PartitionKeyPath`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath
         */
        java.lang.String getPartitionKeyPath();

        /**
         * @return a {@link Builder} of {@link KinesisParametersProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link KinesisParametersProperty}
         */
        final class Builder {
            private java.lang.String _partitionKeyPath;

            /**
             * Sets the value of PartitionKeyPath
             * @param value `CfnRule.KinesisParametersProperty.PartitionKeyPath`.
             * @return {@code this}
             */
            public Builder withPartitionKeyPath(final java.lang.String value) {
                this._partitionKeyPath = java.util.Objects.requireNonNull(value, "partitionKeyPath is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public KinesisParametersProperty build() {
                return new KinesisParametersProperty() {
                    private final java.lang.String $partitionKeyPath = java.util.Objects.requireNonNull(_partitionKeyPath, "partitionKeyPath is required");

                    @Override
                    public java.lang.String getPartitionKeyPath() {
                        return this.$partitionKeyPath;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("partitionKeyPath", om.valueToTree(this.getPartitionKeyPath()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnRule.KinesisParametersProperty.PartitionKeyPath`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath
             */
            @Override
            public java.lang.String getPartitionKeyPath() {
                return this.jsiiGet("partitionKeyPath", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html
     */
    public static interface RunCommandParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnRule.RunCommandParametersProperty.RunCommandTargets`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
         */
        java.lang.Object getRunCommandTargets();

        /**
         * @return a {@link Builder} of {@link RunCommandParametersProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RunCommandParametersProperty}
         */
        final class Builder {
            private java.lang.Object _runCommandTargets;

            /**
             * Sets the value of RunCommandTargets
             * @param value `CfnRule.RunCommandParametersProperty.RunCommandTargets`.
             * @return {@code this}
             */
            public Builder withRunCommandTargets(final software.amazon.awscdk.Token value) {
                this._runCommandTargets = java.util.Objects.requireNonNull(value, "runCommandTargets is required");
                return this;
            }
            /**
             * Sets the value of RunCommandTargets
             * @param value `CfnRule.RunCommandParametersProperty.RunCommandTargets`.
             * @return {@code this}
             */
            public Builder withRunCommandTargets(final java.util.List<java.lang.Object> value) {
                this._runCommandTargets = java.util.Objects.requireNonNull(value, "runCommandTargets is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RunCommandParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RunCommandParametersProperty build() {
                return new RunCommandParametersProperty() {
                    private final java.lang.Object $runCommandTargets = java.util.Objects.requireNonNull(_runCommandTargets, "runCommandTargets is required");

                    @Override
                    public java.lang.Object getRunCommandTargets() {
                        return this.$runCommandTargets;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("runCommandTargets", om.valueToTree(this.getRunCommandTargets()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnRule.RunCommandParametersProperty.RunCommandTargets`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
             */
            @Override
            public java.lang.Object getRunCommandTargets() {
                return this.jsiiGet("runCommandTargets", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html
     */
    public static interface RunCommandTargetProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnRule.RunCommandTargetProperty.Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key
         */
        java.lang.String getKey();
        /**
         * `CfnRule.RunCommandTargetProperty.Values`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
         */
        java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link RunCommandTargetProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RunCommandTargetProperty}
         */
        final class Builder {
            private java.lang.String _key;
            private java.util.List<java.lang.String> _values;

            /**
             * Sets the value of Key
             * @param value `CfnRule.RunCommandTargetProperty.Key`.
             * @return {@code this}
             */
            public Builder withKey(final java.lang.String value) {
                this._key = java.util.Objects.requireNonNull(value, "key is required");
                return this;
            }
            /**
             * Sets the value of Values
             * @param value `CfnRule.RunCommandTargetProperty.Values`.
             * @return {@code this}
             */
            public Builder withValues(final java.util.List<java.lang.String> value) {
                this._values = java.util.Objects.requireNonNull(value, "values is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RunCommandTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RunCommandTargetProperty build() {
                return new RunCommandTargetProperty() {
                    private final java.lang.String $key = java.util.Objects.requireNonNull(_key, "key is required");
                    private final java.util.List<java.lang.String> $values = java.util.Objects.requireNonNull(_values, "values is required");

                    @Override
                    public java.lang.String getKey() {
                        return this.$key;
                    }

                    @Override
                    public java.util.List<java.lang.String> getValues() {
                        return this.$values;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("key", om.valueToTree(this.getKey()));
                        obj.set("values", om.valueToTree(this.getValues()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.CfnRule.RunCommandTargetProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnRule.RunCommandTargetProperty.Key`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key
             */
            @Override
            public java.lang.String getKey() {
                return this.jsiiGet("key", java.lang.String.class);
            }

            /**
             * `CfnRule.RunCommandTargetProperty.Values`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
             */
            @Override
            public java.util.List<java.lang.String> getValues() {
                return this.jsiiGet("values", java.util.List.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sqsparameters.html
     */
    public static interface SqsParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnRule.SqsParametersProperty.MessageGroupId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sqsparameters.html#cfn-events-rule-sqsparameters-messagegroupid
         */
        java.lang.String getMessageGroupId();

        /**
         * @return a {@link Builder} of {@link SqsParametersProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SqsParametersProperty}
         */
        final class Builder {
            private java.lang.String _messageGroupId;

            /**
             * Sets the value of MessageGroupId
             * @param value `CfnRule.SqsParametersProperty.MessageGroupId`.
             * @return {@code this}
             */
            public Builder withMessageGroupId(final java.lang.String value) {
                this._messageGroupId = java.util.Objects.requireNonNull(value, "messageGroupId is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SqsParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SqsParametersProperty build() {
                return new SqsParametersProperty() {
                    private final java.lang.String $messageGroupId = java.util.Objects.requireNonNull(_messageGroupId, "messageGroupId is required");

                    @Override
                    public java.lang.String getMessageGroupId() {
                        return this.$messageGroupId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("messageGroupId", om.valueToTree(this.getMessageGroupId()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnRule.SqsParametersProperty.MessageGroupId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sqsparameters.html#cfn-events-rule-sqsparameters-messagegroupid
             */
            @Override
            public java.lang.String getMessageGroupId() {
                return this.jsiiGet("messageGroupId", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html
     */
    public static interface TargetProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnRule.TargetProperty.Arn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn
         */
        java.lang.String getArn();
        /**
         * `CfnRule.TargetProperty.Id`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id
         */
        java.lang.String getId();
        /**
         * `CfnRule.TargetProperty.EcsParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
         */
        java.lang.Object getEcsParameters();
        /**
         * `CfnRule.TargetProperty.Input`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input
         */
        java.lang.String getInput();
        /**
         * `CfnRule.TargetProperty.InputPath`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath
         */
        java.lang.String getInputPath();
        /**
         * `CfnRule.TargetProperty.InputTransformer`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
         */
        java.lang.Object getInputTransformer();
        /**
         * `CfnRule.TargetProperty.KinesisParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
         */
        java.lang.Object getKinesisParameters();
        /**
         * `CfnRule.TargetProperty.RoleArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn
         */
        java.lang.String getRoleArn();
        /**
         * `CfnRule.TargetProperty.RunCommandParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
         */
        java.lang.Object getRunCommandParameters();
        /**
         * `CfnRule.TargetProperty.SqsParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-sqsparameters
         */
        java.lang.Object getSqsParameters();

        /**
         * @return a {@link Builder} of {@link TargetProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TargetProperty}
         */
        final class Builder {
            private java.lang.String _arn;
            private java.lang.String _id;
            @javax.annotation.Nullable
            private java.lang.Object _ecsParameters;
            @javax.annotation.Nullable
            private java.lang.String _input;
            @javax.annotation.Nullable
            private java.lang.String _inputPath;
            @javax.annotation.Nullable
            private java.lang.Object _inputTransformer;
            @javax.annotation.Nullable
            private java.lang.Object _kinesisParameters;
            @javax.annotation.Nullable
            private java.lang.String _roleArn;
            @javax.annotation.Nullable
            private java.lang.Object _runCommandParameters;
            @javax.annotation.Nullable
            private java.lang.Object _sqsParameters;

            /**
             * Sets the value of Arn
             * @param value `CfnRule.TargetProperty.Arn`.
             * @return {@code this}
             */
            public Builder withArn(final java.lang.String value) {
                this._arn = java.util.Objects.requireNonNull(value, "arn is required");
                return this;
            }
            /**
             * Sets the value of Id
             * @param value `CfnRule.TargetProperty.Id`.
             * @return {@code this}
             */
            public Builder withId(final java.lang.String value) {
                this._id = java.util.Objects.requireNonNull(value, "id is required");
                return this;
            }
            /**
             * Sets the value of EcsParameters
             * @param value `CfnRule.TargetProperty.EcsParameters`.
             * @return {@code this}
             */
            public Builder withEcsParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty value) {
                this._ecsParameters = value;
                return this;
            }
            /**
             * Sets the value of EcsParameters
             * @param value `CfnRule.TargetProperty.EcsParameters`.
             * @return {@code this}
             */
            public Builder withEcsParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ecsParameters = value;
                return this;
            }
            /**
             * Sets the value of Input
             * @param value `CfnRule.TargetProperty.Input`.
             * @return {@code this}
             */
            public Builder withInput(@javax.annotation.Nullable final java.lang.String value) {
                this._input = value;
                return this;
            }
            /**
             * Sets the value of InputPath
             * @param value `CfnRule.TargetProperty.InputPath`.
             * @return {@code this}
             */
            public Builder withInputPath(@javax.annotation.Nullable final java.lang.String value) {
                this._inputPath = value;
                return this;
            }
            /**
             * Sets the value of InputTransformer
             * @param value `CfnRule.TargetProperty.InputTransformer`.
             * @return {@code this}
             */
            public Builder withInputTransformer(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._inputTransformer = value;
                return this;
            }
            /**
             * Sets the value of InputTransformer
             * @param value `CfnRule.TargetProperty.InputTransformer`.
             * @return {@code this}
             */
            public Builder withInputTransformer(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.InputTransformerProperty value) {
                this._inputTransformer = value;
                return this;
            }
            /**
             * Sets the value of KinesisParameters
             * @param value `CfnRule.TargetProperty.KinesisParameters`.
             * @return {@code this}
             */
            public Builder withKinesisParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty value) {
                this._kinesisParameters = value;
                return this;
            }
            /**
             * Sets the value of KinesisParameters
             * @param value `CfnRule.TargetProperty.KinesisParameters`.
             * @return {@code this}
             */
            public Builder withKinesisParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._kinesisParameters = value;
                return this;
            }
            /**
             * Sets the value of RoleArn
             * @param value `CfnRule.TargetProperty.RoleArn`.
             * @return {@code this}
             */
            public Builder withRoleArn(@javax.annotation.Nullable final java.lang.String value) {
                this._roleArn = value;
                return this;
            }
            /**
             * Sets the value of RunCommandParameters
             * @param value `CfnRule.TargetProperty.RunCommandParameters`.
             * @return {@code this}
             */
            public Builder withRunCommandParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty value) {
                this._runCommandParameters = value;
                return this;
            }
            /**
             * Sets the value of RunCommandParameters
             * @param value `CfnRule.TargetProperty.RunCommandParameters`.
             * @return {@code this}
             */
            public Builder withRunCommandParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._runCommandParameters = value;
                return this;
            }
            /**
             * Sets the value of SqsParameters
             * @param value `CfnRule.TargetProperty.SqsParameters`.
             * @return {@code this}
             */
            public Builder withSqsParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._sqsParameters = value;
                return this;
            }
            /**
             * Sets the value of SqsParameters
             * @param value `CfnRule.TargetProperty.SqsParameters`.
             * @return {@code this}
             */
            public Builder withSqsParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty value) {
                this._sqsParameters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TargetProperty build() {
                return new TargetProperty() {
                    private final java.lang.String $arn = java.util.Objects.requireNonNull(_arn, "arn is required");
                    private final java.lang.String $id = java.util.Objects.requireNonNull(_id, "id is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $ecsParameters = _ecsParameters;
                    @javax.annotation.Nullable
                    private final java.lang.String $input = _input;
                    @javax.annotation.Nullable
                    private final java.lang.String $inputPath = _inputPath;
                    @javax.annotation.Nullable
                    private final java.lang.Object $inputTransformer = _inputTransformer;
                    @javax.annotation.Nullable
                    private final java.lang.Object $kinesisParameters = _kinesisParameters;
                    @javax.annotation.Nullable
                    private final java.lang.String $roleArn = _roleArn;
                    @javax.annotation.Nullable
                    private final java.lang.Object $runCommandParameters = _runCommandParameters;
                    @javax.annotation.Nullable
                    private final java.lang.Object $sqsParameters = _sqsParameters;

                    @Override
                    public java.lang.String getArn() {
                        return this.$arn;
                    }

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public java.lang.Object getEcsParameters() {
                        return this.$ecsParameters;
                    }

                    @Override
                    public java.lang.String getInput() {
                        return this.$input;
                    }

                    @Override
                    public java.lang.String getInputPath() {
                        return this.$inputPath;
                    }

                    @Override
                    public java.lang.Object getInputTransformer() {
                        return this.$inputTransformer;
                    }

                    @Override
                    public java.lang.Object getKinesisParameters() {
                        return this.$kinesisParameters;
                    }

                    @Override
                    public java.lang.String getRoleArn() {
                        return this.$roleArn;
                    }

                    @Override
                    public java.lang.Object getRunCommandParameters() {
                        return this.$runCommandParameters;
                    }

                    @Override
                    public java.lang.Object getSqsParameters() {
                        return this.$sqsParameters;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("arn", om.valueToTree(this.getArn()));
                        obj.set("id", om.valueToTree(this.getId()));
                        obj.set("ecsParameters", om.valueToTree(this.getEcsParameters()));
                        obj.set("input", om.valueToTree(this.getInput()));
                        obj.set("inputPath", om.valueToTree(this.getInputPath()));
                        obj.set("inputTransformer", om.valueToTree(this.getInputTransformer()));
                        obj.set("kinesisParameters", om.valueToTree(this.getKinesisParameters()));
                        obj.set("roleArn", om.valueToTree(this.getRoleArn()));
                        obj.set("runCommandParameters", om.valueToTree(this.getRunCommandParameters()));
                        obj.set("sqsParameters", om.valueToTree(this.getSqsParameters()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.CfnRule.TargetProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnRule.TargetProperty.Arn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn
             */
            @Override
            public java.lang.String getArn() {
                return this.jsiiGet("arn", java.lang.String.class);
            }

            /**
             * `CfnRule.TargetProperty.Id`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id
             */
            @Override
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * `CfnRule.TargetProperty.EcsParameters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEcsParameters() {
                return this.jsiiGet("ecsParameters", java.lang.Object.class);
            }

            /**
             * `CfnRule.TargetProperty.Input`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getInput() {
                return this.jsiiGet("input", java.lang.String.class);
            }

            /**
             * `CfnRule.TargetProperty.InputPath`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getInputPath() {
                return this.jsiiGet("inputPath", java.lang.String.class);
            }

            /**
             * `CfnRule.TargetProperty.InputTransformer`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getInputTransformer() {
                return this.jsiiGet("inputTransformer", java.lang.Object.class);
            }

            /**
             * `CfnRule.TargetProperty.KinesisParameters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getKinesisParameters() {
                return this.jsiiGet("kinesisParameters", java.lang.Object.class);
            }

            /**
             * `CfnRule.TargetProperty.RoleArn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getRoleArn() {
                return this.jsiiGet("roleArn", java.lang.String.class);
            }

            /**
             * `CfnRule.TargetProperty.RunCommandParameters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRunCommandParameters() {
                return this.jsiiGet("runCommandParameters", java.lang.Object.class);
            }

            /**
             * `CfnRule.TargetProperty.SqsParameters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-sqsparameters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSqsParameters() {
                return this.jsiiGet("sqsParameters", java.lang.Object.class);
            }
        }
    }
}
