package software.amazon.awscdk.services.events;

@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-04-04T15:05:14.270Z")
public interface EventRuleTargetProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The Amazon Resource Name (ARN) of the target.
     */
    java.lang.String getArn();
    /**
     * A unique, user-defined identifier for the target. Acceptable values
     * include alphanumeric characters, periods (.), hyphens (-), and
     * underscores (_).
     */
    java.lang.String getId();
    /**
     * The Amazon ECS task definition and task count to use, if the event target
     * is an Amazon ECS task.
     */
    software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty getEcsParameters();
    /**
     * Settings that control shard assignment, when the target is a Kinesis
     * stream. If you don't include this parameter, eventId is used as the
     * partition key.
     */
    software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty getKinesisParameters();
    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management
     * (IAM) role to use for this target when the rule is triggered. If one rule
     * triggers multiple targets, you can use a different IAM role for each
     * target.
     */
    java.lang.String getRoleArn();
    /**
     * Parameters used when the rule invokes Amazon EC2 Systems Manager Run
     * Command.
     */
    software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty getRunCommandParameters();

    /**
     * @return a {@link Builder} of {@link EventRuleTargetProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link EventRuleTargetProps}
     */
    final class Builder {
        private java.lang.String _arn;
        private java.lang.String _id;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty _ecsParameters;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty _kinesisParameters;
        @javax.annotation.Nullable
        private java.lang.String _roleArn;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty _runCommandParameters;

        /**
         * Sets the value of Arn
         * @param value The Amazon Resource Name (ARN) of the target.
         * @return {@code this}
         */
        public Builder withArn(final java.lang.String value) {
            this._arn = java.util.Objects.requireNonNull(value, "arn is required");
            return this;
        }
        /**
         * Sets the value of Id
         * @param value A unique, user-defined identifier for the target. Acceptable values
include alphanumeric characters, periods (.), hyphens (-), and
underscores (_).
         * @return {@code this}
         */
        public Builder withId(final java.lang.String value) {
            this._id = java.util.Objects.requireNonNull(value, "id is required");
            return this;
        }
        /**
         * Sets the value of EcsParameters
         * @param value The Amazon ECS task definition and task count to use, if the event target
is an Amazon ECS task.
         * @return {@code this}
         */
        public Builder withEcsParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty value) {
            this._ecsParameters = value;
            return this;
        }
        /**
         * Sets the value of KinesisParameters
         * @param value Settings that control shard assignment, when the target is a Kinesis
stream. If you don't include this parameter, eventId is used as the
partition key.
         * @return {@code this}
         */
        public Builder withKinesisParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty value) {
            this._kinesisParameters = value;
            return this;
        }
        /**
         * Sets the value of RoleArn
         * @param value The Amazon Resource Name (ARN) of the AWS Identity and Access Management
(IAM) role to use for this target when the rule is triggered. If one rule
triggers multiple targets, you can use a different IAM role for each
target.
         * @return {@code this}
         */
        public Builder withRoleArn(@javax.annotation.Nullable final java.lang.String value) {
            this._roleArn = value;
            return this;
        }
        /**
         * Sets the value of RunCommandParameters
         * @param value Parameters used when the rule invokes Amazon EC2 Systems Manager Run
Command.
         * @return {@code this}
         */
        public Builder withRunCommandParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty value) {
            this._runCommandParameters = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventRuleTargetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public EventRuleTargetProps build() {
            return new EventRuleTargetProps() {
                private final java.lang.String $arn = java.util.Objects.requireNonNull(_arn, "arn is required");
                private final java.lang.String $id = java.util.Objects.requireNonNull(_id, "id is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty $ecsParameters = _ecsParameters;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty $kinesisParameters = _kinesisParameters;
                @javax.annotation.Nullable
                private final java.lang.String $roleArn = _roleArn;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty $runCommandParameters = _runCommandParameters;

                @Override
                public java.lang.String getArn() {
                    return this.$arn;
                }

                @Override
                public java.lang.String getId() {
                    return this.$id;
                }

                @Override
                public software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty getEcsParameters() {
                    return this.$ecsParameters;
                }

                @Override
                public software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty getKinesisParameters() {
                    return this.$kinesisParameters;
                }

                @Override
                public java.lang.String getRoleArn() {
                    return this.$roleArn;
                }

                @Override
                public software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty getRunCommandParameters() {
                    return this.$runCommandParameters;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("arn", om.valueToTree(this.getArn()));
                    obj.set("id", om.valueToTree(this.getId()));
                    obj.set("ecsParameters", om.valueToTree(this.getEcsParameters()));
                    obj.set("kinesisParameters", om.valueToTree(this.getKinesisParameters()));
                    obj.set("roleArn", om.valueToTree(this.getRoleArn()));
                    obj.set("runCommandParameters", om.valueToTree(this.getRunCommandParameters()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.EventRuleTargetProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The Amazon Resource Name (ARN) of the target.
         */
        @Override
        public java.lang.String getArn() {
            return this.jsiiGet("arn", java.lang.String.class);
        }

        /**
         * A unique, user-defined identifier for the target. Acceptable values
         * include alphanumeric characters, periods (.), hyphens (-), and
         * underscores (_).
         */
        @Override
        public java.lang.String getId() {
            return this.jsiiGet("id", java.lang.String.class);
        }

        /**
         * The Amazon ECS task definition and task count to use, if the event target
         * is an Amazon ECS task.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty getEcsParameters() {
            return this.jsiiGet("ecsParameters", software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty.class);
        }

        /**
         * Settings that control shard assignment, when the target is a Kinesis
         * stream. If you don't include this parameter, eventId is used as the
         * partition key.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty getKinesisParameters() {
            return this.jsiiGet("kinesisParameters", software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty.class);
        }

        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management
         * (IAM) role to use for this target when the rule is triggered. If one rule
         * triggers multiple targets, you can use a different IAM role for each
         * target.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getRoleArn() {
            return this.jsiiGet("roleArn", java.lang.String.class);
        }

        /**
         * Parameters used when the rule invokes Amazon EC2 Systems Manager Run
         * Command.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty getRunCommandParameters() {
            return this.jsiiGet("runCommandParameters", software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty.class);
        }
    }
}
