package software.amazon.awscdk.services.events;

/**
 * Specifies settings that provide custom input to an Amazon CloudWatch Events
 * rule target based on certain event data.
 * @see https://docs.aws.amazon.com/AmazonCloudWatchEvents/latest/APIReference/API_InputTransformer.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:35:09.575Z")
public interface TargetInputTemplate extends software.amazon.jsii.JsiiSerializable {
    /**
     * Input template where you can use the values of the keys from
     * inputPathsMap to customize the data sent to the target. Enclose each
     * InputPathsMaps value in brackets: <value>
     * 
     * This option is mutually exclusive with `textTemplate`.
     * @example { jsonTemplate: '{ "commands": <commandsToRun> }' , pathsMap: { commandsToRun: '$.detail.commands' } }
     */
    java.lang.Object getJsonTemplate();
    /**
     * Map of JSON paths to be extracted from the event. These are key-value
     * pairs, where each value is a JSON path. You must use JSON dot notation,
     * not bracket notation.
     */
    java.util.Map<java.lang.String, java.lang.String> getPathsMap();
    /**
     * Input template where you can use the values of the keys from
     * inputPathsMap to customize the data sent to the target. Enclose each
     * InputPathsMaps value in brackets: <value>
     * 
     * The value passed here will be double-quoted to indicate it's a string value.
     * This option is mutually exclusive with `jsonTemplate`.
     * @example { textTemplate: 'Build <buildid> started', pathsMap: { buildid: '$.detail.id' } }
     */
    java.lang.String getTextTemplate();

    /**
     * @return a {@link Builder} of {@link TargetInputTemplate}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link TargetInputTemplate}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Object _jsonTemplate;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _pathsMap;
        @javax.annotation.Nullable
        private java.lang.String _textTemplate;

        /**
         * Sets the value of JsonTemplate
         * @param value Input template where you can use the values of the keys from
inputPathsMap to customize the data sent to the target. Enclose each
InputPathsMaps value in brackets: <value>

This option is mutually exclusive with `textTemplate`.
         * @return {@code this}
         */
        public Builder withJsonTemplate(@javax.annotation.Nullable final java.lang.Object value) {
            this._jsonTemplate = value;
            return this;
        }
        /**
         * Sets the value of PathsMap
         * @param value Map of JSON paths to be extracted from the event. These are key-value
pairs, where each value is a JSON path. You must use JSON dot notation,
not bracket notation.
         * @return {@code this}
         */
        public Builder withPathsMap(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._pathsMap = value;
            return this;
        }
        /**
         * Sets the value of TextTemplate
         * @param value Input template where you can use the values of the keys from
inputPathsMap to customize the data sent to the target. Enclose each
InputPathsMaps value in brackets: <value>

The value passed here will be double-quoted to indicate it's a string value.
This option is mutually exclusive with `jsonTemplate`.
         * @return {@code this}
         */
        public Builder withTextTemplate(@javax.annotation.Nullable final java.lang.String value) {
            this._textTemplate = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TargetInputTemplate}
         * @throws NullPointerException if any required attribute was not provided
         */
        public TargetInputTemplate build() {
            return new TargetInputTemplate() {
                @javax.annotation.Nullable
                private final java.lang.Object $jsonTemplate = _jsonTemplate;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.String> $pathsMap = _pathsMap;
                @javax.annotation.Nullable
                private final java.lang.String $textTemplate = _textTemplate;

                @Override
                public java.lang.Object getJsonTemplate() {
                    return this.$jsonTemplate;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getPathsMap() {
                    return this.$pathsMap;
                }

                @Override
                public java.lang.String getTextTemplate() {
                    return this.$textTemplate;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("jsonTemplate", om.valueToTree(this.getJsonTemplate()));
                    obj.set("pathsMap", om.valueToTree(this.getPathsMap()));
                    obj.set("textTemplate", om.valueToTree(this.getTextTemplate()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.TargetInputTemplate {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Input template where you can use the values of the keys from
         * inputPathsMap to customize the data sent to the target. Enclose each
         * InputPathsMaps value in brackets: <value>
         * 
         * This option is mutually exclusive with `textTemplate`.
         * @example { jsonTemplate: '{ "commands": <commandsToRun> }' , pathsMap: { commandsToRun: '$.detail.commands' } }
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getJsonTemplate() {
            return this.jsiiGet("jsonTemplate", java.lang.Object.class);
        }

        /**
         * Map of JSON paths to be extracted from the event. These are key-value
         * pairs, where each value is a JSON path. You must use JSON dot notation,
         * not bracket notation.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getPathsMap() {
            return this.jsiiGet("pathsMap", java.util.Map.class);
        }

        /**
         * Input template where you can use the values of the keys from
         * inputPathsMap to customize the data sent to the target. Enclose each
         * InputPathsMaps value in brackets: <value>
         * 
         * The value passed here will be double-quoted to indicate it's a string value.
         * This option is mutually exclusive with `jsonTemplate`.
         * @example { textTemplate: 'Build <buildid> started', pathsMap: { buildid: '$.detail.id' } }
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getTextTemplate() {
            return this.jsiiGet("textTemplate", java.lang.String.class);
        }
    }
}
