package software.amazon.awscdk.services.events;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.14 (build 91853ce)", date = "2019-02-07T16:57:55.202Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.$Module.class, fqn = "@aws-cdk/aws-events.CfnRule")
public class CfnRule extends software.amazon.awscdk.Resource {
    protected CfnRule(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.events.CfnRule.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::Events::Rule``.
     * @param scope scope in which this resource is defined
     * @param id scoped id of the resource
     * @param props resource properties
     */
    public CfnRule(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(props)).toArray());
    }
    /**
     * Creates a new ``AWS::Events::Rule``.
     * @param scope scope in which this resource is defined
     * @param id scoped id of the resource
     */
    public CfnRule(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.events.CfnRuleProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.events.CfnRuleProps.class);
    }

    /**
     * @cloudformation_attribute Arn
     */
    public java.lang.String getRuleArn() {
        return this.jsiiGet("ruleArn", java.lang.String.class);
    }

    public java.lang.String getRuleId() {
        return this.jsiiGet("ruleId", java.lang.String.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html
     */
    public static interface EcsParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnRule.EcsParametersProperty.TaskDefinitionArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn
         */
        java.lang.String getTaskDefinitionArn();
        /**
         * ``CfnRule.EcsParametersProperty.TaskDefinitionArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn
         */
        void setTaskDefinitionArn(final java.lang.String value);
        /**
         * ``CfnRule.EcsParametersProperty.TaskCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
         */
        java.lang.Object getTaskCount();
        /**
         * ``CfnRule.EcsParametersProperty.TaskCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
         */
        void setTaskCount(final java.lang.Number value);
        /**
         * ``CfnRule.EcsParametersProperty.TaskCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
         */
        void setTaskCount(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link EcsParametersProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EcsParametersProperty}
         */
        final class Builder {
            private java.lang.String _taskDefinitionArn;
            @javax.annotation.Nullable
            private java.lang.Object _taskCount;

            /**
             * Sets the value of TaskDefinitionArn
             * @param value ``CfnRule.EcsParametersProperty.TaskDefinitionArn``
             * @return {@code this}
             */
            public Builder withTaskDefinitionArn(final java.lang.String value) {
                this._taskDefinitionArn = java.util.Objects.requireNonNull(value, "taskDefinitionArn is required");
                return this;
            }
            /**
             * Sets the value of TaskCount
             * @param value ``CfnRule.EcsParametersProperty.TaskCount``
             * @return {@code this}
             */
            public Builder withTaskCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._taskCount = value;
                return this;
            }
            /**
             * Sets the value of TaskCount
             * @param value ``CfnRule.EcsParametersProperty.TaskCount``
             * @return {@code this}
             */
            public Builder withTaskCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._taskCount = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EcsParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EcsParametersProperty build() {
                return new EcsParametersProperty() {
                    private java.lang.String $taskDefinitionArn = java.util.Objects.requireNonNull(_taskDefinitionArn, "taskDefinitionArn is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $taskCount = _taskCount;

                    @Override
                    public java.lang.String getTaskDefinitionArn() {
                        return this.$taskDefinitionArn;
                    }

                    @Override
                    public void setTaskDefinitionArn(final java.lang.String value) {
                        this.$taskDefinitionArn = java.util.Objects.requireNonNull(value, "taskDefinitionArn is required");
                    }

                    @Override
                    public java.lang.Object getTaskCount() {
                        return this.$taskCount;
                    }

                    @Override
                    public void setTaskCount(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$taskCount = value;
                    }

                    @Override
                    public void setTaskCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$taskCount = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnRule.EcsParametersProperty.TaskDefinitionArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn
             */
            @Override
            public java.lang.String getTaskDefinitionArn() {
                return this.jsiiGet("taskDefinitionArn", java.lang.String.class);
            }

            /**
             * ``CfnRule.EcsParametersProperty.TaskDefinitionArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn
             */
            @Override
            public void setTaskDefinitionArn(final java.lang.String value) {
                this.jsiiSet("taskDefinitionArn", java.util.Objects.requireNonNull(value, "taskDefinitionArn is required"));
            }

            /**
             * ``CfnRule.EcsParametersProperty.TaskCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTaskCount() {
                return this.jsiiGet("taskCount", java.lang.Object.class);
            }

            /**
             * ``CfnRule.EcsParametersProperty.TaskCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
             */
            @Override
            public void setTaskCount(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("taskCount", value);
            }

            /**
             * ``CfnRule.EcsParametersProperty.TaskCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
             */
            @Override
            public void setTaskCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("taskCount", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html
     */
    public static interface InputTransformerProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnRule.InputTransformerProperty.InputTemplate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate
         */
        java.lang.String getInputTemplate();
        /**
         * ``CfnRule.InputTransformerProperty.InputTemplate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate
         */
        void setInputTemplate(final java.lang.String value);
        /**
         * ``CfnRule.InputTransformerProperty.InputPathsMap``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
         */
        java.lang.Object getInputPathsMap();
        /**
         * ``CfnRule.InputTransformerProperty.InputPathsMap``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
         */
        void setInputPathsMap(final software.amazon.awscdk.Token value);
        /**
         * ``CfnRule.InputTransformerProperty.InputPathsMap``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
         */
        void setInputPathsMap(final java.util.Map<java.lang.String, java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link InputTransformerProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InputTransformerProperty}
         */
        final class Builder {
            private java.lang.String _inputTemplate;
            @javax.annotation.Nullable
            private java.lang.Object _inputPathsMap;

            /**
             * Sets the value of InputTemplate
             * @param value ``CfnRule.InputTransformerProperty.InputTemplate``
             * @return {@code this}
             */
            public Builder withInputTemplate(final java.lang.String value) {
                this._inputTemplate = java.util.Objects.requireNonNull(value, "inputTemplate is required");
                return this;
            }
            /**
             * Sets the value of InputPathsMap
             * @param value ``CfnRule.InputTransformerProperty.InputPathsMap``
             * @return {@code this}
             */
            public Builder withInputPathsMap(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._inputPathsMap = value;
                return this;
            }
            /**
             * Sets the value of InputPathsMap
             * @param value ``CfnRule.InputTransformerProperty.InputPathsMap``
             * @return {@code this}
             */
            public Builder withInputPathsMap(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this._inputPathsMap = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputTransformerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public InputTransformerProperty build() {
                return new InputTransformerProperty() {
                    private java.lang.String $inputTemplate = java.util.Objects.requireNonNull(_inputTemplate, "inputTemplate is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $inputPathsMap = _inputPathsMap;

                    @Override
                    public java.lang.String getInputTemplate() {
                        return this.$inputTemplate;
                    }

                    @Override
                    public void setInputTemplate(final java.lang.String value) {
                        this.$inputTemplate = java.util.Objects.requireNonNull(value, "inputTemplate is required");
                    }

                    @Override
                    public java.lang.Object getInputPathsMap() {
                        return this.$inputPathsMap;
                    }

                    @Override
                    public void setInputPathsMap(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$inputPathsMap = value;
                    }

                    @Override
                    public void setInputPathsMap(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                        this.$inputPathsMap = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.CfnRule.InputTransformerProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnRule.InputTransformerProperty.InputTemplate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate
             */
            @Override
            public java.lang.String getInputTemplate() {
                return this.jsiiGet("inputTemplate", java.lang.String.class);
            }

            /**
             * ``CfnRule.InputTransformerProperty.InputTemplate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate
             */
            @Override
            public void setInputTemplate(final java.lang.String value) {
                this.jsiiSet("inputTemplate", java.util.Objects.requireNonNull(value, "inputTemplate is required"));
            }

            /**
             * ``CfnRule.InputTransformerProperty.InputPathsMap``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getInputPathsMap() {
                return this.jsiiGet("inputPathsMap", java.lang.Object.class);
            }

            /**
             * ``CfnRule.InputTransformerProperty.InputPathsMap``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
             */
            @Override
            public void setInputPathsMap(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("inputPathsMap", value);
            }

            /**
             * ``CfnRule.InputTransformerProperty.InputPathsMap``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
             */
            @Override
            public void setInputPathsMap(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.jsiiSet("inputPathsMap", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html
     */
    public static interface KinesisParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnRule.KinesisParametersProperty.PartitionKeyPath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath
         */
        java.lang.String getPartitionKeyPath();
        /**
         * ``CfnRule.KinesisParametersProperty.PartitionKeyPath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath
         */
        void setPartitionKeyPath(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link KinesisParametersProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link KinesisParametersProperty}
         */
        final class Builder {
            private java.lang.String _partitionKeyPath;

            /**
             * Sets the value of PartitionKeyPath
             * @param value ``CfnRule.KinesisParametersProperty.PartitionKeyPath``
             * @return {@code this}
             */
            public Builder withPartitionKeyPath(final java.lang.String value) {
                this._partitionKeyPath = java.util.Objects.requireNonNull(value, "partitionKeyPath is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public KinesisParametersProperty build() {
                return new KinesisParametersProperty() {
                    private java.lang.String $partitionKeyPath = java.util.Objects.requireNonNull(_partitionKeyPath, "partitionKeyPath is required");

                    @Override
                    public java.lang.String getPartitionKeyPath() {
                        return this.$partitionKeyPath;
                    }

                    @Override
                    public void setPartitionKeyPath(final java.lang.String value) {
                        this.$partitionKeyPath = java.util.Objects.requireNonNull(value, "partitionKeyPath is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnRule.KinesisParametersProperty.PartitionKeyPath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath
             */
            @Override
            public java.lang.String getPartitionKeyPath() {
                return this.jsiiGet("partitionKeyPath", java.lang.String.class);
            }

            /**
             * ``CfnRule.KinesisParametersProperty.PartitionKeyPath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath
             */
            @Override
            public void setPartitionKeyPath(final java.lang.String value) {
                this.jsiiSet("partitionKeyPath", java.util.Objects.requireNonNull(value, "partitionKeyPath is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html
     */
    public static interface RunCommandParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnRule.RunCommandParametersProperty.RunCommandTargets``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
         */
        java.lang.Object getRunCommandTargets();
        /**
         * ``CfnRule.RunCommandParametersProperty.RunCommandTargets``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
         */
        void setRunCommandTargets(final software.amazon.awscdk.Token value);
        /**
         * ``CfnRule.RunCommandParametersProperty.RunCommandTargets``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
         */
        void setRunCommandTargets(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link RunCommandParametersProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RunCommandParametersProperty}
         */
        final class Builder {
            private java.lang.Object _runCommandTargets;

            /**
             * Sets the value of RunCommandTargets
             * @param value ``CfnRule.RunCommandParametersProperty.RunCommandTargets``
             * @return {@code this}
             */
            public Builder withRunCommandTargets(final software.amazon.awscdk.Token value) {
                this._runCommandTargets = java.util.Objects.requireNonNull(value, "runCommandTargets is required");
                return this;
            }
            /**
             * Sets the value of RunCommandTargets
             * @param value ``CfnRule.RunCommandParametersProperty.RunCommandTargets``
             * @return {@code this}
             */
            public Builder withRunCommandTargets(final java.util.List<java.lang.Object> value) {
                this._runCommandTargets = java.util.Objects.requireNonNull(value, "runCommandTargets is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RunCommandParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RunCommandParametersProperty build() {
                return new RunCommandParametersProperty() {
                    private java.lang.Object $runCommandTargets = java.util.Objects.requireNonNull(_runCommandTargets, "runCommandTargets is required");

                    @Override
                    public java.lang.Object getRunCommandTargets() {
                        return this.$runCommandTargets;
                    }

                    @Override
                    public void setRunCommandTargets(final software.amazon.awscdk.Token value) {
                        this.$runCommandTargets = java.util.Objects.requireNonNull(value, "runCommandTargets is required");
                    }

                    @Override
                    public void setRunCommandTargets(final java.util.List<java.lang.Object> value) {
                        this.$runCommandTargets = java.util.Objects.requireNonNull(value, "runCommandTargets is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnRule.RunCommandParametersProperty.RunCommandTargets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
             */
            @Override
            public java.lang.Object getRunCommandTargets() {
                return this.jsiiGet("runCommandTargets", java.lang.Object.class);
            }

            /**
             * ``CfnRule.RunCommandParametersProperty.RunCommandTargets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
             */
            @Override
            public void setRunCommandTargets(final software.amazon.awscdk.Token value) {
                this.jsiiSet("runCommandTargets", java.util.Objects.requireNonNull(value, "runCommandTargets is required"));
            }

            /**
             * ``CfnRule.RunCommandParametersProperty.RunCommandTargets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
             */
            @Override
            public void setRunCommandTargets(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("runCommandTargets", java.util.Objects.requireNonNull(value, "runCommandTargets is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html
     */
    public static interface RunCommandTargetProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnRule.RunCommandTargetProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key
         */
        java.lang.String getKey();
        /**
         * ``CfnRule.RunCommandTargetProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``CfnRule.RunCommandTargetProperty.Values``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
         */
        java.lang.Object getValues();
        /**
         * ``CfnRule.RunCommandTargetProperty.Values``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
         */
        void setValues(final software.amazon.awscdk.Token value);
        /**
         * ``CfnRule.RunCommandTargetProperty.Values``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
         */
        void setValues(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link RunCommandTargetProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RunCommandTargetProperty}
         */
        final class Builder {
            private java.lang.String _key;
            private java.lang.Object _values;

            /**
             * Sets the value of Key
             * @param value ``CfnRule.RunCommandTargetProperty.Key``
             * @return {@code this}
             */
            public Builder withKey(final java.lang.String value) {
                this._key = java.util.Objects.requireNonNull(value, "key is required");
                return this;
            }
            /**
             * Sets the value of Values
             * @param value ``CfnRule.RunCommandTargetProperty.Values``
             * @return {@code this}
             */
            public Builder withValues(final software.amazon.awscdk.Token value) {
                this._values = java.util.Objects.requireNonNull(value, "values is required");
                return this;
            }
            /**
             * Sets the value of Values
             * @param value ``CfnRule.RunCommandTargetProperty.Values``
             * @return {@code this}
             */
            public Builder withValues(final java.util.List<java.lang.Object> value) {
                this._values = java.util.Objects.requireNonNull(value, "values is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RunCommandTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RunCommandTargetProperty build() {
                return new RunCommandTargetProperty() {
                    private java.lang.String $key = java.util.Objects.requireNonNull(_key, "key is required");
                    private java.lang.Object $values = java.util.Objects.requireNonNull(_values, "values is required");

                    @Override
                    public java.lang.String getKey() {
                        return this.$key;
                    }

                    @Override
                    public void setKey(final java.lang.String value) {
                        this.$key = java.util.Objects.requireNonNull(value, "key is required");
                    }

                    @Override
                    public java.lang.Object getValues() {
                        return this.$values;
                    }

                    @Override
                    public void setValues(final software.amazon.awscdk.Token value) {
                        this.$values = java.util.Objects.requireNonNull(value, "values is required");
                    }

                    @Override
                    public void setValues(final java.util.List<java.lang.Object> value) {
                        this.$values = java.util.Objects.requireNonNull(value, "values is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.CfnRule.RunCommandTargetProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnRule.RunCommandTargetProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key
             */
            @Override
            public java.lang.String getKey() {
                return this.jsiiGet("key", java.lang.String.class);
            }

            /**
             * ``CfnRule.RunCommandTargetProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key
             */
            @Override
            public void setKey(final java.lang.String value) {
                this.jsiiSet("key", java.util.Objects.requireNonNull(value, "key is required"));
            }

            /**
             * ``CfnRule.RunCommandTargetProperty.Values``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
             */
            @Override
            public java.lang.Object getValues() {
                return this.jsiiGet("values", java.lang.Object.class);
            }

            /**
             * ``CfnRule.RunCommandTargetProperty.Values``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
             */
            @Override
            public void setValues(final software.amazon.awscdk.Token value) {
                this.jsiiSet("values", java.util.Objects.requireNonNull(value, "values is required"));
            }

            /**
             * ``CfnRule.RunCommandTargetProperty.Values``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
             */
            @Override
            public void setValues(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("values", java.util.Objects.requireNonNull(value, "values is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sqsparameters.html
     */
    public static interface SqsParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnRule.SqsParametersProperty.MessageGroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sqsparameters.html#cfn-events-rule-sqsparameters-messagegroupid
         */
        java.lang.String getMessageGroupId();
        /**
         * ``CfnRule.SqsParametersProperty.MessageGroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sqsparameters.html#cfn-events-rule-sqsparameters-messagegroupid
         */
        void setMessageGroupId(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link SqsParametersProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SqsParametersProperty}
         */
        final class Builder {
            private java.lang.String _messageGroupId;

            /**
             * Sets the value of MessageGroupId
             * @param value ``CfnRule.SqsParametersProperty.MessageGroupId``
             * @return {@code this}
             */
            public Builder withMessageGroupId(final java.lang.String value) {
                this._messageGroupId = java.util.Objects.requireNonNull(value, "messageGroupId is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SqsParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SqsParametersProperty build() {
                return new SqsParametersProperty() {
                    private java.lang.String $messageGroupId = java.util.Objects.requireNonNull(_messageGroupId, "messageGroupId is required");

                    @Override
                    public java.lang.String getMessageGroupId() {
                        return this.$messageGroupId;
                    }

                    @Override
                    public void setMessageGroupId(final java.lang.String value) {
                        this.$messageGroupId = java.util.Objects.requireNonNull(value, "messageGroupId is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnRule.SqsParametersProperty.MessageGroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sqsparameters.html#cfn-events-rule-sqsparameters-messagegroupid
             */
            @Override
            public java.lang.String getMessageGroupId() {
                return this.jsiiGet("messageGroupId", java.lang.String.class);
            }

            /**
             * ``CfnRule.SqsParametersProperty.MessageGroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sqsparameters.html#cfn-events-rule-sqsparameters-messagegroupid
             */
            @Override
            public void setMessageGroupId(final java.lang.String value) {
                this.jsiiSet("messageGroupId", java.util.Objects.requireNonNull(value, "messageGroupId is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html
     */
    public static interface TargetProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnRule.TargetProperty.Arn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn
         */
        java.lang.String getArn();
        /**
         * ``CfnRule.TargetProperty.Arn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn
         */
        void setArn(final java.lang.String value);
        /**
         * ``CfnRule.TargetProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id
         */
        java.lang.String getId();
        /**
         * ``CfnRule.TargetProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id
         */
        void setId(final java.lang.String value);
        /**
         * ``CfnRule.TargetProperty.EcsParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
         */
        java.lang.Object getEcsParameters();
        /**
         * ``CfnRule.TargetProperty.EcsParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
         */
        void setEcsParameters(final software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty value);
        /**
         * ``CfnRule.TargetProperty.EcsParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
         */
        void setEcsParameters(final software.amazon.awscdk.Token value);
        /**
         * ``CfnRule.TargetProperty.Input``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input
         */
        java.lang.String getInput();
        /**
         * ``CfnRule.TargetProperty.Input``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input
         */
        void setInput(final java.lang.String value);
        /**
         * ``CfnRule.TargetProperty.InputPath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath
         */
        java.lang.String getInputPath();
        /**
         * ``CfnRule.TargetProperty.InputPath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath
         */
        void setInputPath(final java.lang.String value);
        /**
         * ``CfnRule.TargetProperty.InputTransformer``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
         */
        java.lang.Object getInputTransformer();
        /**
         * ``CfnRule.TargetProperty.InputTransformer``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
         */
        void setInputTransformer(final software.amazon.awscdk.Token value);
        /**
         * ``CfnRule.TargetProperty.InputTransformer``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
         */
        void setInputTransformer(final software.amazon.awscdk.services.events.CfnRule.InputTransformerProperty value);
        /**
         * ``CfnRule.TargetProperty.KinesisParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
         */
        java.lang.Object getKinesisParameters();
        /**
         * ``CfnRule.TargetProperty.KinesisParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
         */
        void setKinesisParameters(final software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty value);
        /**
         * ``CfnRule.TargetProperty.KinesisParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
         */
        void setKinesisParameters(final software.amazon.awscdk.Token value);
        /**
         * ``CfnRule.TargetProperty.RoleArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn
         */
        java.lang.String getRoleArn();
        /**
         * ``CfnRule.TargetProperty.RoleArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn
         */
        void setRoleArn(final java.lang.String value);
        /**
         * ``CfnRule.TargetProperty.RunCommandParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
         */
        java.lang.Object getRunCommandParameters();
        /**
         * ``CfnRule.TargetProperty.RunCommandParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
         */
        void setRunCommandParameters(final software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty value);
        /**
         * ``CfnRule.TargetProperty.RunCommandParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
         */
        void setRunCommandParameters(final software.amazon.awscdk.Token value);
        /**
         * ``CfnRule.TargetProperty.SqsParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-sqsparameters
         */
        java.lang.Object getSqsParameters();
        /**
         * ``CfnRule.TargetProperty.SqsParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-sqsparameters
         */
        void setSqsParameters(final software.amazon.awscdk.Token value);
        /**
         * ``CfnRule.TargetProperty.SqsParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-sqsparameters
         */
        void setSqsParameters(final software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty value);

        /**
         * @return a {@link Builder} of {@link TargetProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TargetProperty}
         */
        final class Builder {
            private java.lang.String _arn;
            private java.lang.String _id;
            @javax.annotation.Nullable
            private java.lang.Object _ecsParameters;
            @javax.annotation.Nullable
            private java.lang.String _input;
            @javax.annotation.Nullable
            private java.lang.String _inputPath;
            @javax.annotation.Nullable
            private java.lang.Object _inputTransformer;
            @javax.annotation.Nullable
            private java.lang.Object _kinesisParameters;
            @javax.annotation.Nullable
            private java.lang.String _roleArn;
            @javax.annotation.Nullable
            private java.lang.Object _runCommandParameters;
            @javax.annotation.Nullable
            private java.lang.Object _sqsParameters;

            /**
             * Sets the value of Arn
             * @param value ``CfnRule.TargetProperty.Arn``
             * @return {@code this}
             */
            public Builder withArn(final java.lang.String value) {
                this._arn = java.util.Objects.requireNonNull(value, "arn is required");
                return this;
            }
            /**
             * Sets the value of Id
             * @param value ``CfnRule.TargetProperty.Id``
             * @return {@code this}
             */
            public Builder withId(final java.lang.String value) {
                this._id = java.util.Objects.requireNonNull(value, "id is required");
                return this;
            }
            /**
             * Sets the value of EcsParameters
             * @param value ``CfnRule.TargetProperty.EcsParameters``
             * @return {@code this}
             */
            public Builder withEcsParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty value) {
                this._ecsParameters = value;
                return this;
            }
            /**
             * Sets the value of EcsParameters
             * @param value ``CfnRule.TargetProperty.EcsParameters``
             * @return {@code this}
             */
            public Builder withEcsParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ecsParameters = value;
                return this;
            }
            /**
             * Sets the value of Input
             * @param value ``CfnRule.TargetProperty.Input``
             * @return {@code this}
             */
            public Builder withInput(@javax.annotation.Nullable final java.lang.String value) {
                this._input = value;
                return this;
            }
            /**
             * Sets the value of InputPath
             * @param value ``CfnRule.TargetProperty.InputPath``
             * @return {@code this}
             */
            public Builder withInputPath(@javax.annotation.Nullable final java.lang.String value) {
                this._inputPath = value;
                return this;
            }
            /**
             * Sets the value of InputTransformer
             * @param value ``CfnRule.TargetProperty.InputTransformer``
             * @return {@code this}
             */
            public Builder withInputTransformer(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._inputTransformer = value;
                return this;
            }
            /**
             * Sets the value of InputTransformer
             * @param value ``CfnRule.TargetProperty.InputTransformer``
             * @return {@code this}
             */
            public Builder withInputTransformer(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.InputTransformerProperty value) {
                this._inputTransformer = value;
                return this;
            }
            /**
             * Sets the value of KinesisParameters
             * @param value ``CfnRule.TargetProperty.KinesisParameters``
             * @return {@code this}
             */
            public Builder withKinesisParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty value) {
                this._kinesisParameters = value;
                return this;
            }
            /**
             * Sets the value of KinesisParameters
             * @param value ``CfnRule.TargetProperty.KinesisParameters``
             * @return {@code this}
             */
            public Builder withKinesisParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._kinesisParameters = value;
                return this;
            }
            /**
             * Sets the value of RoleArn
             * @param value ``CfnRule.TargetProperty.RoleArn``
             * @return {@code this}
             */
            public Builder withRoleArn(@javax.annotation.Nullable final java.lang.String value) {
                this._roleArn = value;
                return this;
            }
            /**
             * Sets the value of RunCommandParameters
             * @param value ``CfnRule.TargetProperty.RunCommandParameters``
             * @return {@code this}
             */
            public Builder withRunCommandParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty value) {
                this._runCommandParameters = value;
                return this;
            }
            /**
             * Sets the value of RunCommandParameters
             * @param value ``CfnRule.TargetProperty.RunCommandParameters``
             * @return {@code this}
             */
            public Builder withRunCommandParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._runCommandParameters = value;
                return this;
            }
            /**
             * Sets the value of SqsParameters
             * @param value ``CfnRule.TargetProperty.SqsParameters``
             * @return {@code this}
             */
            public Builder withSqsParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._sqsParameters = value;
                return this;
            }
            /**
             * Sets the value of SqsParameters
             * @param value ``CfnRule.TargetProperty.SqsParameters``
             * @return {@code this}
             */
            public Builder withSqsParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty value) {
                this._sqsParameters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TargetProperty build() {
                return new TargetProperty() {
                    private java.lang.String $arn = java.util.Objects.requireNonNull(_arn, "arn is required");
                    private java.lang.String $id = java.util.Objects.requireNonNull(_id, "id is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $ecsParameters = _ecsParameters;
                    @javax.annotation.Nullable
                    private java.lang.String $input = _input;
                    @javax.annotation.Nullable
                    private java.lang.String $inputPath = _inputPath;
                    @javax.annotation.Nullable
                    private java.lang.Object $inputTransformer = _inputTransformer;
                    @javax.annotation.Nullable
                    private java.lang.Object $kinesisParameters = _kinesisParameters;
                    @javax.annotation.Nullable
                    private java.lang.String $roleArn = _roleArn;
                    @javax.annotation.Nullable
                    private java.lang.Object $runCommandParameters = _runCommandParameters;
                    @javax.annotation.Nullable
                    private java.lang.Object $sqsParameters = _sqsParameters;

                    @Override
                    public java.lang.String getArn() {
                        return this.$arn;
                    }

                    @Override
                    public void setArn(final java.lang.String value) {
                        this.$arn = java.util.Objects.requireNonNull(value, "arn is required");
                    }

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(final java.lang.String value) {
                        this.$id = java.util.Objects.requireNonNull(value, "id is required");
                    }

                    @Override
                    public java.lang.Object getEcsParameters() {
                        return this.$ecsParameters;
                    }

                    @Override
                    public void setEcsParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty value) {
                        this.$ecsParameters = value;
                    }

                    @Override
                    public void setEcsParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ecsParameters = value;
                    }

                    @Override
                    public java.lang.String getInput() {
                        return this.$input;
                    }

                    @Override
                    public void setInput(@javax.annotation.Nullable final java.lang.String value) {
                        this.$input = value;
                    }

                    @Override
                    public java.lang.String getInputPath() {
                        return this.$inputPath;
                    }

                    @Override
                    public void setInputPath(@javax.annotation.Nullable final java.lang.String value) {
                        this.$inputPath = value;
                    }

                    @Override
                    public java.lang.Object getInputTransformer() {
                        return this.$inputTransformer;
                    }

                    @Override
                    public void setInputTransformer(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$inputTransformer = value;
                    }

                    @Override
                    public void setInputTransformer(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.InputTransformerProperty value) {
                        this.$inputTransformer = value;
                    }

                    @Override
                    public java.lang.Object getKinesisParameters() {
                        return this.$kinesisParameters;
                    }

                    @Override
                    public void setKinesisParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty value) {
                        this.$kinesisParameters = value;
                    }

                    @Override
                    public void setKinesisParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$kinesisParameters = value;
                    }

                    @Override
                    public java.lang.String getRoleArn() {
                        return this.$roleArn;
                    }

                    @Override
                    public void setRoleArn(@javax.annotation.Nullable final java.lang.String value) {
                        this.$roleArn = value;
                    }

                    @Override
                    public java.lang.Object getRunCommandParameters() {
                        return this.$runCommandParameters;
                    }

                    @Override
                    public void setRunCommandParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty value) {
                        this.$runCommandParameters = value;
                    }

                    @Override
                    public void setRunCommandParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$runCommandParameters = value;
                    }

                    @Override
                    public java.lang.Object getSqsParameters() {
                        return this.$sqsParameters;
                    }

                    @Override
                    public void setSqsParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$sqsParameters = value;
                    }

                    @Override
                    public void setSqsParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty value) {
                        this.$sqsParameters = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.CfnRule.TargetProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnRule.TargetProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn
             */
            @Override
            public java.lang.String getArn() {
                return this.jsiiGet("arn", java.lang.String.class);
            }

            /**
             * ``CfnRule.TargetProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn
             */
            @Override
            public void setArn(final java.lang.String value) {
                this.jsiiSet("arn", java.util.Objects.requireNonNull(value, "arn is required"));
            }

            /**
             * ``CfnRule.TargetProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id
             */
            @Override
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * ``CfnRule.TargetProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id
             */
            @Override
            public void setId(final java.lang.String value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }

            /**
             * ``CfnRule.TargetProperty.EcsParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEcsParameters() {
                return this.jsiiGet("ecsParameters", java.lang.Object.class);
            }

            /**
             * ``CfnRule.TargetProperty.EcsParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
             */
            @Override
            public void setEcsParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty value) {
                this.jsiiSet("ecsParameters", value);
            }

            /**
             * ``CfnRule.TargetProperty.EcsParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
             */
            @Override
            public void setEcsParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ecsParameters", value);
            }

            /**
             * ``CfnRule.TargetProperty.Input``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getInput() {
                return this.jsiiGet("input", java.lang.String.class);
            }

            /**
             * ``CfnRule.TargetProperty.Input``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input
             */
            @Override
            public void setInput(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("input", value);
            }

            /**
             * ``CfnRule.TargetProperty.InputPath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getInputPath() {
                return this.jsiiGet("inputPath", java.lang.String.class);
            }

            /**
             * ``CfnRule.TargetProperty.InputPath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath
             */
            @Override
            public void setInputPath(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("inputPath", value);
            }

            /**
             * ``CfnRule.TargetProperty.InputTransformer``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getInputTransformer() {
                return this.jsiiGet("inputTransformer", java.lang.Object.class);
            }

            /**
             * ``CfnRule.TargetProperty.InputTransformer``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
             */
            @Override
            public void setInputTransformer(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("inputTransformer", value);
            }

            /**
             * ``CfnRule.TargetProperty.InputTransformer``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
             */
            @Override
            public void setInputTransformer(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.InputTransformerProperty value) {
                this.jsiiSet("inputTransformer", value);
            }

            /**
             * ``CfnRule.TargetProperty.KinesisParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getKinesisParameters() {
                return this.jsiiGet("kinesisParameters", java.lang.Object.class);
            }

            /**
             * ``CfnRule.TargetProperty.KinesisParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
             */
            @Override
            public void setKinesisParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty value) {
                this.jsiiSet("kinesisParameters", value);
            }

            /**
             * ``CfnRule.TargetProperty.KinesisParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
             */
            @Override
            public void setKinesisParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("kinesisParameters", value);
            }

            /**
             * ``CfnRule.TargetProperty.RoleArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getRoleArn() {
                return this.jsiiGet("roleArn", java.lang.String.class);
            }

            /**
             * ``CfnRule.TargetProperty.RoleArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn
             */
            @Override
            public void setRoleArn(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("roleArn", value);
            }

            /**
             * ``CfnRule.TargetProperty.RunCommandParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRunCommandParameters() {
                return this.jsiiGet("runCommandParameters", java.lang.Object.class);
            }

            /**
             * ``CfnRule.TargetProperty.RunCommandParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
             */
            @Override
            public void setRunCommandParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty value) {
                this.jsiiSet("runCommandParameters", value);
            }

            /**
             * ``CfnRule.TargetProperty.RunCommandParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
             */
            @Override
            public void setRunCommandParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("runCommandParameters", value);
            }

            /**
             * ``CfnRule.TargetProperty.SqsParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-sqsparameters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSqsParameters() {
                return this.jsiiGet("sqsParameters", java.lang.Object.class);
            }

            /**
             * ``CfnRule.TargetProperty.SqsParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-sqsparameters
             */
            @Override
            public void setSqsParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("sqsParameters", value);
            }

            /**
             * ``CfnRule.TargetProperty.SqsParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-sqsparameters
             */
            @Override
            public void setSqsParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty value) {
                this.jsiiSet("sqsParameters", value);
            }
        }
    }
}
