package software.amazon.awscdk.services.events;

/**
 * Specifies settings that provide custom input to an Amazon CloudWatch Events
 * rule target based on certain event data.
 * @see https://docs.aws.amazon.com/AmazonCloudWatchEvents/latest/APIReference/API_InputTransformer.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-11-21T12:40:19.618Z")
public interface TargetInputTemplate extends software.amazon.jsii.JsiiSerializable {
    /**
     * Input template where you can use the values of the keys from
     * inputPathsMap to customize the data sent to the target. Enclose each
     * InputPathsMaps value in brackets: <value>
     * 
     * This option is mutually exclusive with `textTemplate`.
     * @example { jsonTemplate: '{ "commands": <commandsToRun> }' , pathsMap: { commandsToRun: '$.detail.commands' } }
     */
    java.lang.Object getJsonTemplate();
    /**
     * Input template where you can use the values of the keys from
     * inputPathsMap to customize the data sent to the target. Enclose each
     * InputPathsMaps value in brackets: <value>
     * 
     * This option is mutually exclusive with `textTemplate`.
     * @example { jsonTemplate: '{ "commands": <commandsToRun> }' , pathsMap: { commandsToRun: '$.detail.commands' } }
     */
    void setJsonTemplate(final java.lang.Object value);
    /**
     * Map of JSON paths to be extracted from the event. These are key-value
     * pairs, where each value is a JSON path. You must use JSON dot notation,
     * not bracket notation.
     */
    java.util.Map<java.lang.String, java.lang.String> getPathsMap();
    /**
     * Map of JSON paths to be extracted from the event. These are key-value
     * pairs, where each value is a JSON path. You must use JSON dot notation,
     * not bracket notation.
     */
    void setPathsMap(final java.util.Map<java.lang.String, java.lang.String> value);
    /**
     * Input template where you can use the values of the keys from
     * inputPathsMap to customize the data sent to the target. Enclose each
     * InputPathsMaps value in brackets: <value>
     * 
     * The value passed here will be double-quoted to indicate it's a string value.
     * This option is mutually exclusive with `jsonTemplate`.
     * @example { textTemplate: 'Build <buildid> started', pathsMap: { buildid: '$.detail.id' } }
     */
    java.lang.Object getTextTemplate();
    /**
     * Input template where you can use the values of the keys from
     * inputPathsMap to customize the data sent to the target. Enclose each
     * InputPathsMaps value in brackets: <value>
     * 
     * The value passed here will be double-quoted to indicate it's a string value.
     * This option is mutually exclusive with `jsonTemplate`.
     * @example { textTemplate: 'Build <buildid> started', pathsMap: { buildid: '$.detail.id' } }
     */
    void setTextTemplate(final java.lang.Object value);

    /**
     * @return a {@link Builder} of {@link TargetInputTemplate}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link TargetInputTemplate}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Object _jsonTemplate;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _pathsMap;
        @javax.annotation.Nullable
        private java.lang.Object _textTemplate;

        /**
         * Sets the value of JsonTemplate
         * @param value Input template where you can use the values of the keys from
inputPathsMap to customize the data sent to the target. Enclose each
InputPathsMaps value in brackets: <value>

This option is mutually exclusive with `textTemplate`.
         * @return {@code this}
         */
        public Builder withJsonTemplate(@javax.annotation.Nullable final java.lang.Object value) {
            this._jsonTemplate = value;
            return this;
        }
        /**
         * Sets the value of PathsMap
         * @param value Map of JSON paths to be extracted from the event. These are key-value
pairs, where each value is a JSON path. You must use JSON dot notation,
not bracket notation.
         * @return {@code this}
         */
        public Builder withPathsMap(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._pathsMap = value;
            return this;
        }
        /**
         * Sets the value of TextTemplate
         * @param value Input template where you can use the values of the keys from
inputPathsMap to customize the data sent to the target. Enclose each
InputPathsMaps value in brackets: <value>

The value passed here will be double-quoted to indicate it's a string value.
This option is mutually exclusive with `jsonTemplate`.
         * @return {@code this}
         */
        public Builder withTextTemplate(@javax.annotation.Nullable final java.lang.Object value) {
            this._textTemplate = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TargetInputTemplate}
         * @throws NullPointerException if any required attribute was not provided
         */
        public TargetInputTemplate build() {
            return new TargetInputTemplate() {
                @javax.annotation.Nullable
                private java.lang.Object $jsonTemplate = _jsonTemplate;
                @javax.annotation.Nullable
                private java.util.Map<java.lang.String, java.lang.String> $pathsMap = _pathsMap;
                @javax.annotation.Nullable
                private java.lang.Object $textTemplate = _textTemplate;

                @Override
                public java.lang.Object getJsonTemplate() {
                    return this.$jsonTemplate;
                }

                @Override
                public void setJsonTemplate(@javax.annotation.Nullable final java.lang.Object value) {
                    this.$jsonTemplate = value;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getPathsMap() {
                    return this.$pathsMap;
                }

                @Override
                public void setPathsMap(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                    this.$pathsMap = value;
                }

                @Override
                public java.lang.Object getTextTemplate() {
                    return this.$textTemplate;
                }

                @Override
                public void setTextTemplate(@javax.annotation.Nullable final java.lang.Object value) {
                    this.$textTemplate = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.TargetInputTemplate {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Input template where you can use the values of the keys from
         * inputPathsMap to customize the data sent to the target. Enclose each
         * InputPathsMaps value in brackets: <value>
         * 
         * This option is mutually exclusive with `textTemplate`.
         * @example { jsonTemplate: '{ "commands": <commandsToRun> }' , pathsMap: { commandsToRun: '$.detail.commands' } }
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getJsonTemplate() {
            return this.jsiiGet("jsonTemplate", java.lang.Object.class);
        }

        /**
         * Input template where you can use the values of the keys from
         * inputPathsMap to customize the data sent to the target. Enclose each
         * InputPathsMaps value in brackets: <value>
         * 
         * This option is mutually exclusive with `textTemplate`.
         * @example { jsonTemplate: '{ "commands": <commandsToRun> }' , pathsMap: { commandsToRun: '$.detail.commands' } }
         */
        @Override
        public void setJsonTemplate(@javax.annotation.Nullable final java.lang.Object value) {
            this.jsiiSet("jsonTemplate", value);
        }

        /**
         * Map of JSON paths to be extracted from the event. These are key-value
         * pairs, where each value is a JSON path. You must use JSON dot notation,
         * not bracket notation.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getPathsMap() {
            return this.jsiiGet("pathsMap", java.util.Map.class);
        }

        /**
         * Map of JSON paths to be extracted from the event. These are key-value
         * pairs, where each value is a JSON path. You must use JSON dot notation,
         * not bracket notation.
         */
        @Override
        public void setPathsMap(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this.jsiiSet("pathsMap", value);
        }

        /**
         * Input template where you can use the values of the keys from
         * inputPathsMap to customize the data sent to the target. Enclose each
         * InputPathsMaps value in brackets: <value>
         * 
         * The value passed here will be double-quoted to indicate it's a string value.
         * This option is mutually exclusive with `jsonTemplate`.
         * @example { textTemplate: 'Build <buildid> started', pathsMap: { buildid: '$.detail.id' } }
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getTextTemplate() {
            return this.jsiiGet("textTemplate", java.lang.Object.class);
        }

        /**
         * Input template where you can use the values of the keys from
         * inputPathsMap to customize the data sent to the target. Enclose each
         * InputPathsMaps value in brackets: <value>
         * 
         * The value passed here will be double-quoted to indicate it's a string value.
         * This option is mutually exclusive with `jsonTemplate`.
         * @example { textTemplate: 'Build <buildid> started', pathsMap: { buildid: '$.detail.id' } }
         */
        @Override
        public void setTextTemplate(@javax.annotation.Nullable final java.lang.Object value) {
            this.jsiiSet("textTemplate", value);
        }
    }
}
