package software.amazon.awscdk.services.events;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.8 (build 100f5ad)", date = "2018-11-06T21:17:43.426Z")
public interface EventRuleTargetProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The Amazon Resource Name (ARN) of the target.
     */
    java.lang.String getArn();
    /**
     * The Amazon Resource Name (ARN) of the target.
     */
    void setArn(final java.lang.String value);
    /**
     * A unique, user-defined identifier for the target. Acceptable values
     * include alphanumeric characters, periods (.), hyphens (-), and
     * underscores (_).
     */
    java.lang.String getId();
    /**
     * A unique, user-defined identifier for the target. Acceptable values
     * include alphanumeric characters, periods (.), hyphens (-), and
     * underscores (_).
     */
    void setId(final java.lang.String value);
    /**
     * The Amazon ECS task definition and task count to use, if the event target
     * is an Amazon ECS task.
     */
    software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty getEcsParameters();
    /**
     * The Amazon ECS task definition and task count to use, if the event target
     * is an Amazon ECS task.
     */
    void setEcsParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty value);
    /**
     * Settings that control shard assignment, when the target is a Kinesis
     * stream. If you don't include this parameter, eventId is used as the
     * partition key.
     */
    software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty getKinesisParameters();
    /**
     * Settings that control shard assignment, when the target is a Kinesis
     * stream. If you don't include this parameter, eventId is used as the
     * partition key.
     */
    void setKinesisParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty value);
    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management
     * (IAM) role to use for this target when the rule is triggered. If one rule
     * triggers multiple targets, you can use a different IAM role for each
     * target.
     */
    java.lang.String getRoleArn();
    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management
     * (IAM) role to use for this target when the rule is triggered. If one rule
     * triggers multiple targets, you can use a different IAM role for each
     * target.
     */
    void setRoleArn(final java.lang.String value);
    /**
     * Parameters used when the rule invokes Amazon EC2 Systems Manager Run
     * Command.
     */
    software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty getRunCommandParameters();
    /**
     * Parameters used when the rule invokes Amazon EC2 Systems Manager Run
     * Command.
     */
    void setRunCommandParameters(final software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty value);

    /**
     * @return a {@link Builder} of {@link EventRuleTargetProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link EventRuleTargetProps}
     */
    final class Builder {
        private java.lang.String _arn;
        private java.lang.String _id;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty _ecsParameters;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty _kinesisParameters;
        @javax.annotation.Nullable
        private java.lang.String _roleArn;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty _runCommandParameters;

        /**
         * Sets the value of Arn
         * @param value The Amazon Resource Name (ARN) of the target.
         * @return {@code this}
         */
        public Builder withArn(final java.lang.String value) {
            this._arn = java.util.Objects.requireNonNull(value, "arn is required");
            return this;
        }
        /**
         * Sets the value of Id
         * @param value A unique, user-defined identifier for the target. Acceptable values
include alphanumeric characters, periods (.), hyphens (-), and
underscores (_).
         * @return {@code this}
         */
        public Builder withId(final java.lang.String value) {
            this._id = java.util.Objects.requireNonNull(value, "id is required");
            return this;
        }
        /**
         * Sets the value of EcsParameters
         * @param value The Amazon ECS task definition and task count to use, if the event target
is an Amazon ECS task.
         * @return {@code this}
         */
        public Builder withEcsParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty value) {
            this._ecsParameters = value;
            return this;
        }
        /**
         * Sets the value of KinesisParameters
         * @param value Settings that control shard assignment, when the target is a Kinesis
stream. If you don't include this parameter, eventId is used as the
partition key.
         * @return {@code this}
         */
        public Builder withKinesisParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty value) {
            this._kinesisParameters = value;
            return this;
        }
        /**
         * Sets the value of RoleArn
         * @param value The Amazon Resource Name (ARN) of the AWS Identity and Access Management
(IAM) role to use for this target when the rule is triggered. If one rule
triggers multiple targets, you can use a different IAM role for each
target.
         * @return {@code this}
         */
        public Builder withRoleArn(@javax.annotation.Nullable final java.lang.String value) {
            this._roleArn = value;
            return this;
        }
        /**
         * Sets the value of RunCommandParameters
         * @param value Parameters used when the rule invokes Amazon EC2 Systems Manager Run
Command.
         * @return {@code this}
         */
        public Builder withRunCommandParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty value) {
            this._runCommandParameters = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventRuleTargetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public EventRuleTargetProps build() {
            return new EventRuleTargetProps() {
                private java.lang.String $arn = java.util.Objects.requireNonNull(_arn, "arn is required");
                private java.lang.String $id = java.util.Objects.requireNonNull(_id, "id is required");
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty $ecsParameters = _ecsParameters;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty $kinesisParameters = _kinesisParameters;
                @javax.annotation.Nullable
                private java.lang.String $roleArn = _roleArn;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty $runCommandParameters = _runCommandParameters;

                @Override
                public java.lang.String getArn() {
                    return this.$arn;
                }

                @Override
                public void setArn(final java.lang.String value) {
                    this.$arn = java.util.Objects.requireNonNull(value, "arn is required");
                }

                @Override
                public java.lang.String getId() {
                    return this.$id;
                }

                @Override
                public void setId(final java.lang.String value) {
                    this.$id = java.util.Objects.requireNonNull(value, "id is required");
                }

                @Override
                public software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty getEcsParameters() {
                    return this.$ecsParameters;
                }

                @Override
                public void setEcsParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty value) {
                    this.$ecsParameters = value;
                }

                @Override
                public software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty getKinesisParameters() {
                    return this.$kinesisParameters;
                }

                @Override
                public void setKinesisParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty value) {
                    this.$kinesisParameters = value;
                }

                @Override
                public java.lang.String getRoleArn() {
                    return this.$roleArn;
                }

                @Override
                public void setRoleArn(@javax.annotation.Nullable final java.lang.String value) {
                    this.$roleArn = value;
                }

                @Override
                public software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty getRunCommandParameters() {
                    return this.$runCommandParameters;
                }

                @Override
                public void setRunCommandParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty value) {
                    this.$runCommandParameters = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.EventRuleTargetProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The Amazon Resource Name (ARN) of the target.
         */
        @Override
        public java.lang.String getArn() {
            return this.jsiiGet("arn", java.lang.String.class);
        }

        /**
         * The Amazon Resource Name (ARN) of the target.
         */
        @Override
        public void setArn(final java.lang.String value) {
            this.jsiiSet("arn", java.util.Objects.requireNonNull(value, "arn is required"));
        }

        /**
         * A unique, user-defined identifier for the target. Acceptable values
         * include alphanumeric characters, periods (.), hyphens (-), and
         * underscores (_).
         */
        @Override
        public java.lang.String getId() {
            return this.jsiiGet("id", java.lang.String.class);
        }

        /**
         * A unique, user-defined identifier for the target. Acceptable values
         * include alphanumeric characters, periods (.), hyphens (-), and
         * underscores (_).
         */
        @Override
        public void setId(final java.lang.String value) {
            this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
        }

        /**
         * The Amazon ECS task definition and task count to use, if the event target
         * is an Amazon ECS task.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty getEcsParameters() {
            return this.jsiiGet("ecsParameters", software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty.class);
        }

        /**
         * The Amazon ECS task definition and task count to use, if the event target
         * is an Amazon ECS task.
         */
        @Override
        public void setEcsParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.cloudformation.RuleResource.EcsParametersProperty value) {
            this.jsiiSet("ecsParameters", value);
        }

        /**
         * Settings that control shard assignment, when the target is a Kinesis
         * stream. If you don't include this parameter, eventId is used as the
         * partition key.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty getKinesisParameters() {
            return this.jsiiGet("kinesisParameters", software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty.class);
        }

        /**
         * Settings that control shard assignment, when the target is a Kinesis
         * stream. If you don't include this parameter, eventId is used as the
         * partition key.
         */
        @Override
        public void setKinesisParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.cloudformation.RuleResource.KinesisParametersProperty value) {
            this.jsiiSet("kinesisParameters", value);
        }

        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management
         * (IAM) role to use for this target when the rule is triggered. If one rule
         * triggers multiple targets, you can use a different IAM role for each
         * target.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getRoleArn() {
            return this.jsiiGet("roleArn", java.lang.String.class);
        }

        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management
         * (IAM) role to use for this target when the rule is triggered. If one rule
         * triggers multiple targets, you can use a different IAM role for each
         * target.
         */
        @Override
        public void setRoleArn(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("roleArn", value);
        }

        /**
         * Parameters used when the rule invokes Amazon EC2 Systems Manager Run
         * Command.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty getRunCommandParameters() {
            return this.jsiiGet("runCommandParameters", software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty.class);
        }

        /**
         * Parameters used when the rule invokes Amazon EC2 Systems Manager Run
         * Command.
         */
        @Override
        public void setRunCommandParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.events.cloudformation.RuleResource.RunCommandParametersProperty value) {
            this.jsiiSet("runCommandParameters", value);
        }
    }
}
